function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/NiagaraPointUxManager
 */
define(['baja!', 'baja!control:ControlPoint', 'Promise', 'lex!workbench', 'log!nmodule.niagaraDriver.rc.wb.mgr.NiagaraPointUxManager', 'nmodule/bql/rc/builder/BqlQueryBuilder', 'nmodule/bql/rc/util/parseBql', 'nmodule/driver/rc/wb/mgr/point/PointLearnModel', 'nmodule/driver/rc/wb/mgr/PointMgr', 'nmodule/driver/rc/wb/mgr/PointMgrModel', 'nmodule/niagaraDriver/rc/wb/mgr/NiagaraPointLearn', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraPointManagerModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo'], function (baja, types, Promise, lexs, log, BqlQueryBuilder, parseBql, PointLearnModel, PointMgr, PointMgrModel, NiagaraPointLearn, NiagaraPointManagerModel, compUtils, feDialogs, MgrLearn, MgrTypeInfo) {
  'use strict';

  var NavNode = require('bajaScript/baja/nav/NavNode');
  var _lexs = _slicedToArray(lexs, 1),
    WB_LEX = _lexs[0];
  var COLUMNS = PointLearnModel.COLUMNS;
  var toSelect = parseBql.toSelect;
  var logSevere = log.severe.bind(log);
  var loadSlotInfo = function loadSlotInfo(manager, subject) {
    var pathString = subject.get('toPathString'),
      slotPath = 'slot:' + pathString;
    return manager.$getPointDeviceExt().rpc('loadNodesPartially', [slotPath]).then(function (slots) {
      return slots[slotPath];
    });
  };
  var addNumericPointTypes = PointMgrModel.addNumericPointTypes,
    addBooleanPointTypes = PointMgrModel.addBooleanPointTypes,
    addEnumPointTypes = PointMgrModel.addEnumPointTypes,
    addStringPointTypes = PointMgrModel.addStringPointTypes;
  var FACETS_DEFAULT = baja.Facets.DEFAULT;
  var _toNavNode = function toNavNode(obj) {
    return Promise.all((obj.kids || []).map(function (kid) {
      return _toNavNode({
        name: kid.n,
        displayName: kid.d,
        ord: kid.o,
        icon: kid.i,
        kids: kid.k
      });
    })).then(function (kids) {
      var navNode = new NavNode({
        navName: obj.name,
        displayName: obj.displayName,
        description: obj.description,
        ord: String(obj.ord),
        icon: obj.icon
      });
      navNode.getNavChildren = function () {
        return Promise.resolve(kids);
      };
      return navNode;
    });
  };
  function getBqlQuery(ordStr) {
    var bqlOrdParts = ordStr.match(/(\|bql:)|(bql:)/gi);
    var pieces = bqlOrdParts ? ordStr.split(bqlOrdParts[0]) : [ordStr];
    return pieces.length > 1 ? pieces[pieces.length - 1] : pieces[0];
  }

  /**
   * A bajaux Point Manager View for NiagaraDriver
   *
   * @class
   * @extends module:nmodule/driver/rc/wb/mgr/PointMgr
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraPointUxManager
   */
  return /*#__PURE__*/function (_PointMgr) {
    /**
     * 
     * @param {object} [params] 
     * @param {string} [params.extentTypeSpec] a specific type spec to be used as extent for the 
     *  BQL query. Defaults to control:ControlPoint
     */
    function NiagaraPointUxManager() {
      var _this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$extentTypeSpec = _ref.extentTypeSpec,
        extentTypeSpec = _ref$extentTypeSpec === void 0 ? 'control:ControlPoint' : _ref$extentTypeSpec;
      _classCallCheck(this, NiagaraPointUxManager);
      _this = _callSuper(this, NiagaraPointUxManager, [{
        moduleName: 'niagaraDriver',
        keyName: 'NiagaraPointUxManager',
        folderType: 'niagaraDriver:NiagaraPointFolder',
        subscriptionDepth: 3
      }]);
      _this.$extentTypeSpec = extentTypeSpec;
      MgrLearn(_this);
      return _this;
    }

    /**
     * Make the model backing this manager
     * @param {baja.Component} component 
     * @returns {Promise}
     */
    _inherits(NiagaraPointUxManager, _PointMgr);
    return _createClass(NiagaraPointUxManager, [{
      key: "makeModel",
      value: function makeModel(component) {
        return NiagaraPointManagerModel.make(component);
      }
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return PointLearnModel.make();
      }

      /**
       * 
       * @param {baja.Value} subject 
       * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        return this.$getInstance(subject).then(function (val) {
          var type = val.getType();
          var types = [];
          if (type.is("baja:IBoolean")) {
            types = addBooleanPointTypes(false, types);
            types = addEnumPointTypes(false, types);
          } else if (type.is("baja:INumeric")) {
            types = addNumericPointTypes(false, types);
          } else if (type.is("baja:IEnum")) {
            types = addEnumPointTypes(false, types);
          }
          addStringPointTypes(false, types);
          return MgrTypeInfo.make(types);
        });
      }

      /**
       * Returns an object with the proposed subject for the manager AddCommand 
       * @param {baja.Component} discovery
       * @param {module:baja/comp/ControlPoint} point when a match is done, it is the database point that we are matching to
       * @returns {Promise.<Object>}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, point) {
        return loadSlotInfo(this, discovery).then(function (slotInfo) {
          if (!slotInfo) {
            return [];
          }
          var s = slotInfo.s;
          var _ref2 = s || {},
            f = _ref2.f;
          return Promise.all([slotInfo, f ? FACETS_DEFAULT.decodeAsync(f) : FACETS_DEFAULT]);
        }).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            slotInfo = _ref4[0],
            facets = _ref4[1];
          if (!slotInfo) {
            return {};
          }
          var o = slotInfo.o,
            s = slotInfo.s,
            _ref5 = s || {},
            d = _ref5.d,
            n = _ref5.n;
          return {
            name: point && point.getName() ? point.getName() : n,
            values: {
              pointId: o,
              facets: facets,
              __displayName: d,
              deviceFacets: facets
            }
          };
        });
      }

      /**
       * Returns true if the slot paths match
       * 
       * @param {baja.Component} subject 
       * @param {baja.Value} point 
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(subject, point) {
        if (!baja.hasType(point, 'control:ControlPoint')) {
          return false;
        }
        return point.getProxyExt().getPointId() === 'slot:' + subject.get('toPathString');
      }

      /**
       * Starts a discovery job. Pops open an instance of BqlQueryBuilder
       * editor rooted to the remote config space.
       * 
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this2 = this;
        return this.$getDeviceNavContainer().then(function (deviceNavContainer) {
          return feDialogs.showFor({
            title: WB_LEX.get('bqlQueryBuilder.queryBuilder'),
            type: BqlQueryBuilder,
            value: _this2.$bqlQuery || _this2.getDefaultBqlQuery(),
            formFactor: 'compact',
            properties: {
              hideProjection: true,
              rootNode: deviceNavContainer
            }
          }).then(function (bqlQuery) {
            if (!bqlQuery) {
              return;
            }
            if (bqlQuery) {
              var bqlQueryStr = String(bqlQuery);
              return toSelect(getBqlQuery(bqlQueryStr)).then(function (select) {
                var projection = select.get('projection'),
                  projCol = projection && projection.get('ProjCol'),
                  path = projCol && projCol.get('Path');
                if (String(path).equals('*')) {
                  bqlQueryStr = bqlQueryStr.replace('*', _this2.getBqlProjection());
                }
                return _this2.$doBqlDiscover(bqlQueryStr, _this2.$getPointDeviceExt());
              });
            }
          })["catch"](function (e) {
            logSevere(e);
            throw e;
          });
        });
      }

      /**
       * Get the default BQL Query with a default projection.
       * @returns {baja.Ord}
       */
    }, {
      key: "getDefaultBqlQuery",
      value: function getDefaultBqlQuery() {
        return baja.Ord.make('bql:select ' + this.getBqlProjection() + ' from ' + this.$extentTypeSpec);
      }

      /**
       * Returns the default projection for a point discovery bql query
       * @returns {string}
       */
    }, {
      key: "getBqlProjection",
      value: function getBqlProjection() {
        var columns = COLUMNS.filter(function (column) {
          return column.getName() !== 'icon';
        }).map(function (column) {
          return column.getName();
        });
        columns.push('icon.encodeToString');
        return columns.join(', ');
      }

      /**
       *
       * @returns {{learnModel: (object)}}
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        if (this.$bqlResults) {
          return {
            learnModel: this.$bqlResults
          };
        }
      }

      /**
       *
       * @param state
       * @returns {Promise}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(state) {
        var learnModel = state.learnModel;
        var modelData;
        if (learnModel !== undefined) {
          if (_typeof(learnModel) !== 'object') {
            modelData = JSON.parse(learnModel);
          } else {
            modelData = learnModel;
          }
          this.$bqlResults = modelData;
          var niagaraLearn = new NiagaraPointLearn(this.$bqlQuery, this.$getPointDeviceExt());
          return niagaraLearn.$updateTable(modelData.contents, this.getLearnModel());
        } else {
          this.$bqlResults = undefined;
        }
        return Promise.resolve();
      }

      /**
       * @param state
       * @returns {Promise}
       */
    }, {
      key: "postRestore",
      value: function postRestore(state) {
        var _this3 = this;
        if (!this.$bqlResults) {
          if (this.$bqlQuery && this.$ptDevExtOrd) {
            return baja.Ord.make(this.$ptDevExtOrd).get().then(function (pointDeviceExt) {
              return _this3.$doBqlDiscover(_this3.$bqlQuery, pointDeviceExt);
            })["catch"](logSevere);
          }
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @param {string} bqlQuery 
       * @param {baja.Component} pointDeviceExt 
       * @returns {Promise}
       */
    }, {
      key: "$doBqlDiscover",
      value: function $doBqlDiscover(bqlQuery, pointDeviceExt) {
        var _this4 = this;
        this.$bqlQuery = bqlQuery;
        var niagaraLearn = new NiagaraPointLearn(bqlQuery, pointDeviceExt);
        return niagaraLearn.bqlDiscover({
          learnModel: this.getLearnModel()
        }).then(function (value) {
          _this4.$bqlResults = niagaraLearn.$bqlResults;
          return value;
        });
      }

      /**
       * Returns a baja.NavContainer
       * @private
       * @returns {Promise<baja.NavContainer>} 
       */
    }, {
      key: "$getDeviceNavContainer",
      value: function $getDeviceNavContainer() {
        return this.$getPointDeviceExt().rpc('discoverDeviceRoots').then(function (r) {
          var roots = r.k[0]; // Filter the top level out
          return _toNavNode({
            name: roots.n,
            displayName: roots.d,
            ord: roots.o,
            icon: roots.i,
            kids: roots.k
          });
        });
      }

      /**
      * Returns the point ext for the current loaded component. As we may have a folder
      * loaded, this may be several levels up in the component tree.
      *
      * @private
      * @returns {baja.Component}
      */
    }, {
      key: "$getPointDeviceExt",
      value: function $getPointDeviceExt() {
        return compUtils.closest(this.value(), 'niagaraDriver:NiagaraPointDeviceExt');
      }

      /**
       * Get an instance for the given type by loading it from the registry or
       * importing the type if required.
       * @private
       * @param {baja.Component} subject 
       * @returns {Promise.<*>}
       */
    }, {
      key: "$getInstance",
      value: function $getInstance(subject) {
        var typeSpec = subject.get('type');
        return baja.importTypes([typeSpec]).then(function (_ref6) {
          var _ref7 = _slicedToArray(_ref6, 1),
            loadedType = _ref7[0];
          return baja.$(loadedType);
        });
      }
    }]);
  }(PointMgr);
});
