function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryExportLearn
 */

define(['baja!', 'Promise', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportLearnNode'], function (baja, Promise, NiagaraHistoryExportLearnNode) {
  'use strict';

  /**
   * Handles the building of the learn model
   * @class
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryExportLearn
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function () {
    function NiagaraHistoryExportLearn() {
      _classCallCheck(this, NiagaraHistoryExportLearn);
    }
    return _createClass(NiagaraHistoryExportLearn, [{
      key: "rpcDiscovery",
      value:
      /**
       * @param {object} params
       * @param {module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportLearnModel} params.learnModel
       * @param {string} params.targetOrd the string that represents the target ord
       * @returns {Promise}
       */
      function rpcDiscovery(params) {
        var _this = this;
        var learnModel = params.learnModel,
          targetOrd = params.targetOrd;
        return baja.rpc({
          typeSpec: "niagaraDriver:NiagaraHistoryExportRpc",
          method: "getExportHistoryDiscoveryRpc",
          args: [targetOrd]
        }).then(function (results) {
          return results && _this.$updateTable(results.devices, learnModel);
        });
      }

      /**
       * @private
       * @param {Array.<Object>|Object} data the data returned from the station
       * @param learnModel
       * @returns {Promise}
       */
    }, {
      key: "$updateTable",
      value: function $updateTable(data, learnModel) {
        var _this2 = this;
        if (Array.isArray(data)) {
          return Promise.all(data.map(function (device) {
            return _this2.$makeNode(device);
          })).then(function (devices) {
            return learnModel.clearRows().then(function () {
              return learnModel.insertRows(devices);
            });
          });
        }
        return Promise.resolve();
      }
    }, {
      key: "$makeNode",
      value: function $makeNode(device) {
        return new NiagaraHistoryExportLearnNode(device);
      }
    }]);
  }();
});
