/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/ndio/rc/fe/Shunt500OhmConversionEditor
 */
define(['baja!', 'nmodule/driver/rc/fe/ProxyConversionEditor', 'nmodule/ndio/rc/baja/Shunt500OhmConversion', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, ProxyConversionEditor, Shunt500OhmConversion, typeUtils) {
  'use strict';

  /**
   * Editor for handling `ndio:Shunt500OhmConversion` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/ndio/rc/fe/Shunt500OhmConversionEditor
   */
  var Shunt500OhmConversionEditor = function Shunt500OhmConversionEditor(params) {
    ProxyConversionEditor.apply(this, arguments);
  };
  Shunt500OhmConversionEditor.prototype = Object.create(ProxyConversionEditor.prototype);
  Shunt500OhmConversionEditor.prototype.constructor = Shunt500OhmConversionEditor;
  Shunt500OhmConversionEditor.prototype.doLoad = function (value) {
    var that = this;
    return typeUtils.importTypes(value.getSubConvTypeSpec()).then(function (loadedType) {
      var val = baja.$(loadedType).decodeFromString(value.getSubConvValStr());
      return ProxyConversionEditor.prototype.doLoad.call(that, val);
    });
  };
  Shunt500OhmConversionEditor.prototype.doRead = function () {
    var that = this;
    var conWid = that.getConversionWidget();
    if (conWid) {
      return conWid.read().then(function (subVal) {
        return Shunt500OhmConversion.make(subVal.getType().getTypeSpec(), subVal.encodeToString());
      });
    }
    return Shunt500OhmConversion.make(that.getSelect().val());
  };
  return Shunt500OhmConversionEditor;
});
