/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'underscore', 'bajaux/mixin/batchSaveMixin', 'Promise'], function (baja, _, batchSaveMixin, Promise) {
  "use strict";

  /**
   * API Status: **Private**
   *
   * Utility for saving the frozen properties from a baja:Complex
   * to a target widget's loaded value
   *
   * @exports nmodule/bql/rc/fe/filter/saveUtil
   */
  var saveUtil = function saveUtil() {};

  /**
   * Saves the frozen properties of a src baja:Complex to a BaseEditor. Note: the editor
   * MUST have bajaux/mixin/batchSaveMixin mixed in prior to calling this method.
   * @param {Widget} editor A subclass of Widget
   * @param {baja.Complex} src Source baja.Complex to save properties from
   * @param params
   * @returns {Promise} Promise resolved once save has been committed
   */
  saveUtil.save = function (editor, src, params) {
    var batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      target = editor.value(),
      props = src.getSlots().properties().toArray(),
      sets = _.map(props, function (prop) {
        var value = src.get(prop);
        if (baja.hasType(value, 'baja:Complex') && value.getParent()) {
          value = value.newCopy(true);
        }
        return target.set({
          slot: prop,
          value: value,
          batch: batch
        });
      });
    if (progressCallback) {
      progressCallback(batchSaveMixin.COMMIT_READY);
    }
    return Promise.all(sets);
  };
  return saveUtil;
});
