function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/fe/filter/StringFilterEditor
 */
define(['baja!', 'baja!bql:StringFilter', 'lex!workbench', 'jquery', 'underscore', 'Promise', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaux/mixin/batchSaveMixin', 'bajaux/mixin/subscriberMixIn', 'nmodule/bql/rc/fe/filter/saveUtil', 'hbs!nmodule/bql/rc/fe/filter/templates/StringFilterEditor', 'css!nmodule/bql/rc/bql'], function (baja, types, lexs, $, _, Promise, events, Widget, BaseEditor, OrderedMapEditor, fe, batchSaveMixin, subscriberMixin, saveUtil, template) {
  "use strict";

  var ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT,
    DESTROY_EVENT = events.DESTROY_EVENT,
    PATTERN_CLASS = "pattern",
    LIST_CLASS = "list",
    MATCH_CASE_CLASS = 'matchCase',
    PATTERN_SELECTOR = '.' + PATTERN_CLASS,
    LIST_SELECTOR = '.' + LIST_CLASS,
    MATCH_CASE_SELECTOR = '.' + MATCH_CASE_CLASS,
    lex = lexs[0],
    save = saveUtil.save,
    options = {
      mustEqual: {
        exact: true,
        include: true
      },
      mustLike: {
        exact: false,
        include: true
      },
      mustNotEqual: {
        exact: true,
        include: false
      },
      mustNotLike: {
        exact: false,
        include: false
      }
    };

  /**
   * Maps the pattern include/exact match boolean flags to the corresponding list option
   * @param exact
   * @param include
   * @returns {String} String corresponding to the option's key
   */
  function mapToOption(exact, include) {
    var key = _.find(Object.keys(options), function (key) {
      var option = options[key];
      return option.exact === exact && option.include === include;
    });
    return "filter." + key;
  }

  /**
   * Utility function to return the component UI elements of the filter editor
   * @param dom
   * @returns {{pattern: Function, list: Function, listSelection: Function, checkbox: Function}}
   */
  function utility(dom) {
    return {
      pattern: function pattern() {
        return Widget["in"](dom.find(PATTERN_SELECTOR));
      },
      list: function list() {
        return Widget["in"](dom.find(LIST_SELECTOR));
      },
      checkbox: function checkbox() {
        return Widget["in"](dom.find(MATCH_CASE_SELECTOR));
      },
      listOptions: function listOptions() {
        return this.list().$getSelect().find('option');
      },
      listSelection: function listSelection() {
        return this.list().$getSelect().find(':selected');
      },
      option: function option() {
        return this.listSelection().val();
      },
      options: options
    };
  }

  /**
   * StringFilterEditor is a field editor for a bql:StringFilter instance
   * @class
   * @alias module:nmodule/bql/rc/fe/filter/StringFilterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var StringFilterEditor = function StringFilterEditor() {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
    subscriberMixin(this);
  };
  StringFilterEditor.prototype = Object.create(BaseEditor.prototype);
  StringFilterEditor.prototype.constructor = StringFilterEditor;

  /**
   * Support utility for access to convenience methods
   * @private
   * @returns {Object} Utility object with access to useful functions
   */
  StringFilterEditor.prototype.$support = function (dom) {
    return utility(dom || this.jq());
  };
  function initListEditor(dom) {
    var map = new baja.OrderedMap();
    _.keys(options).forEach(function (key) {
      map.put("filter." + key, options[key]);
    });
    return fe.buildFor({
      dom: $(LIST_SELECTOR, dom),
      value: map,
      type: OrderedMapEditor,
      properties: {
        lexicon: 'workbench'
      },
      formFactor: 'mini'
    });
  }
  function initPatternEditor(dom) {
    return fe.buildFor({
      dom: $(PATTERN_SELECTOR, dom),
      value: "%",
      formFactor: 'mini'
    });
  }
  function initMatchCaseEditor(dom) {
    var fieldLabel = lex.get("filter.matchCase");
    return fe.buildFor({
      dom: $(MATCH_CASE_SELECTOR, dom),
      value: true,
      properties: {
        trueText: fieldLabel,
        falseText: fieldLabel
      },
      formFactor: 'mini'
    });
  }

  /**
   * Initializes the DOM with a StringEditor, a select list for specifying string
   * matching criteria, and a checkbox for specifying case-sensitive matching
   * @param dom
   * @returns {Promise}
   */
  StringFilterEditor.prototype.doInitialize = function (dom) {
    var that = this;

    //cache utility functions
    this.$util = utility(dom);
    dom.addClass('StringFilterEditor');
    dom.html(template({
      list: LIST_CLASS,
      pattern: PATTERN_CLASS,
      matchCase: MATCH_CASE_CLASS
    }));

    //prevent StringEditor subeditor from bubbling up events
    dom.on([ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT, INITIALIZE_EVENT, LOAD_EVENT, DESTROY_EVENT].join(' '), PATTERN_SELECTOR + ", " + LIST_SELECTOR + ", " + MATCH_CASE_SELECTOR, false);
    dom.on(MODIFY_EVENT, PATTERN_SELECTOR + ", " + LIST_SELECTOR + ", " + MATCH_CASE_SELECTOR, function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([initListEditor(dom), initPatternEditor(dom), initMatchCaseEditor(dom)]);
  };

  /**
   * Loads the editor with a bql:StringFilter
   * @param filter An instance of bql:StringFilter
   * @returns {Promise}
   */
  StringFilterEditor.prototype.doLoad = function (filter) {
    if (!baja.hasType(filter, 'bql:StringFilter')) {
      return Promise.reject(new Error('editor must be loaded with bql:StringFilter'));
    }
    var util = this.$util,
      pattern = util.pattern(),
      list = util.list(),
      checkbox = util.checkbox(),
      exact,
      include,
      matchCase,
      key;
    exact = filter.getExact();
    include = filter.getInclude();
    matchCase = filter.getMatchCase();
    key = mapToOption(exact, include);

    //set the string matching criteria list item
    list.setSelectedKey(key);

    //load the pattern and checkbox editors
    return Promise.all([pattern.load(filter.getPattern()), checkbox.load(matchCase)]);
  };

  /**
   * Reads the current value of the StringFilter
   * @returns {Promise} Promise resolved with a new instance of a bql:StringFilter
   */
  StringFilterEditor.prototype.doRead = function () {
    return this.getChildEditors().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        option = _ref2[0],
        pattern = _ref2[1],
        matchCase = _ref2[2];
      return baja.$('bql:StringFilter', {
        pattern: pattern,
        exact: option.exact,
        include: option.include,
        matchCase: matchCase
      });
    });
  };

  /**
   * Save the current states of the pattern, list and checkbox
   * @param {bql:StringFilter} filter object returned by StringEditor#read()
   * @returns {Promise} Promise resolved when the filter properties have been saved
   */
  StringFilterEditor.prototype.doSave = function (filter, params) {
    return save(this, filter, params);
  };

  /**
   * Sets the readonly state of the StringFilterEditor
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  StringFilterEditor.prototype.doReadonly = function doReadonly(readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Sets the enabled state of the StringFilterEditor
   * @param enabled
   * @returns {Promise}
   */
  StringFilterEditor.prototype.doEnabled = function doEnabled(enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Destroys the StringFilterEditor
   * @returns {Promise} Promise that resolves when the pattern editor is destroyed
   */
  StringFilterEditor.prototype.doDestroy = function (params) {
    this.jq().removeClass('StringFilterEditor');
    return this.getChildEditors().destroyAll(params);
  };
  return StringFilterEditor;
});
