/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module ord
 * @private
 */
define(["bajaScript/boxcs", "bajaScript/baja/comp/LocalHost", "bajaScript/baja/ord/AlarmScheme", "bajaScript/baja/ord/BatchResolve", "bajaScript/baja/ord/BinderCacheScheme", "bajaScript/baja/ord/BogScheme", "bajaScript/baja/ord/FileScheme", "bajaScript/baja/ord/FoxScheme", "bajaScript/baja/ord/HandleScheme", "bajaScript/baja/ord/HierarchyScheme", "bajaScript/baja/ord/HistoryScheme", "bajaScript/baja/ord/HttpScheme", "bajaScript/baja/ord/IpScheme", "bajaScript/baja/ord/LocalScheme", "bajaScript/baja/ord/NSpaceScheme", "bajaScript/baja/ord/Ord", "bajaScript/baja/ord/OrdCoalescer", "bajaScript/baja/ord/OrdList", "bajaScript/baja/ord/OrdQuery", "bajaScript/baja/ord/OrdQueryList", "bajaScript/baja/ord/OrdQueryListCursor", "bajaScript/baja/ord/OrdScheme", "bajaScript/baja/ord/ServiceScheme", "bajaScript/baja/ord/SingleScheme", "bajaScript/baja/ord/SlotPath", "bajaScript/baja/ord/SlotScheme", "bajaScript/baja/ord/StationScheme", "bajaScript/baja/ord/UnknownScheme", "bajaScript/baja/ord/ViewQuery", "bajaScript/baja/ord/ViewScheme", "bajaScript/baja/ord/VirtualPath", "bajaScript/baja/ord/VirtualScheme"], function (baja, LocalHost, AlarmScheme, BatchResolve, BinderCacheScheme, BogScheme, FileScheme, FoxScheme, HandleScheme, HierarchyScheme, HistoryScheme, HttpScheme, IpScheme, LocalScheme, NSpaceScheme, Ord, OrdCoalescer, OrdList, OrdQuery, OrdQueryList, OrdQueryListCursor, OrdScheme, ServiceScheme, SingleScheme, SlotPath, SlotScheme, StationScheme, UnknownScheme, ViewQuery, ViewScheme, VirtualPath, VirtualScheme) {
  "use strict";

  var registerType = baja.registerType;
  function registerAll(obj) {
    baja.iterate(obj, function (ctor, typeSpec) {
      registerType(typeSpec, function () {
        return ctor;
      });
    });
  }
  registerAll({
    "alarm:AlarmScheme": baja.AlarmScheme = AlarmScheme,
    "baja:BinderCacheScheme": baja.BinderCacheScheme = BinderCacheScheme,
    "baja:FileScheme": baja.FileScheme = FileScheme,
    "baja:HandleScheme": baja.HandleScheme = HandleScheme,
    "baja:IpScheme": baja.IpScheme = IpScheme,
    "baja:LocalScheme": baja.LocalScheme = LocalScheme,
    "baja:Ord": baja.Ord = Ord,
    "baja:OrdList": baja.OrdList = OrdList,
    "baja:OrdScheme": baja.OrdScheme = OrdScheme,
    "baja:ServiceScheme": baja.ServiceScheme = ServiceScheme,
    "baja:SingleScheme": SingleScheme,
    "baja:SlotScheme": baja.SlotScheme = SlotScheme,
    "baja:StationScheme": baja.StationScheme = StationScheme,
    "baja:ViewScheme": baja.ViewScheme = ViewScheme,
    "baja:VirtualScheme": baja.VirtualScheme = VirtualScheme,
    "file:BogScheme": baja.BogScheme = BogScheme,
    "fox:FoxScheme": baja.FoxScheme = FoxScheme,
    "fox:FoxsScheme": FoxScheme,
    "hierarchy:HierarchyScheme": baja.HierarchyScheme = HierarchyScheme,
    "history:HistoryScheme": baja.HistoryScheme = HistoryScheme,
    "net:HttpScheme": baja.HttpScheme = HttpScheme,
    "net:HttpsScheme": HttpScheme,
    "niagaraDriver:NSpaceScheme": baja.NSpaceScheme = NSpaceScheme
  });
  baja.BatchResolve = BatchResolve;
  baja.OrdCoalescer = OrdCoalescer;
  baja.OrdQuery = OrdQuery;
  baja.OrdQueryList = OrdQueryList;
  baja.SlotPath = SlotPath;
  baja.UnknownScheme = UnknownScheme;
  baja.ViewQuery = ViewQuery;
  baja.VirtualPath = VirtualPath;

  ////////////////////////////////////////////////////////////////
  // Local Host and Component Space
  ////////////////////////////////////////////////////////////////

  /**
   * Local Host.
   * @type {baja.LocalHost}
   */
  baja.nav.localhost = baja.nav.$addChildNode(LocalHost.$getLocalSessionHost());
  var ordInHost = baja.BoxComponentSpace.$getDefaultOrdInHost();
  var componentSpace = new baja.BoxComponentSpace("station", ordInHost, baja.nav.localhost);

  /**
   * Local Station Component Space.
   * @type {baja.BoxComponentSpace}
   */
  baja.nav.localhost.station = baja.nav.localhost.$addChildNode(componentSpace);

  /**
   * Shortcut to local Station Component Space.
   *
   * @see baja.nav.localhost.station
   * @type {baja.BoxComponentSpace}
   */
  baja.station = baja.nav.localhost.station;
  return baja;
});
