/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module obj
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/obj/AbsTime", "bajaScript/baja/obj/Boolean", "bajaScript/baja/obj/Blob", "bajaScript/baja/obj/CategoryMask", "bajaScript/baja/obj/Date", "bajaScript/baja/obj/DaysOfWeekBits", "bajaScript/baja/obj/DefaultSimple", "bajaScript/baja/obj/Dimension", "bajaScript/baja/obj/Double", "bajaScript/baja/obj/DynamicEnum", "bajaScript/baja/obj/Enum", "bajaScript/baja/obj/EnumRange", "bajaScript/baja/obj/EnumSet", "bajaScript/baja/obj/Facets", "bajaScript/baja/obj/FacetsMap", "bajaScript/baja/obj/Float", "bajaScript/baja/obj/Format", "bajaScript/baja/obj/FrozenEnum", "bajaScript/baja/obj/Icon", "bajaScript/baja/obj/Integer", "bajaScript/baja/obj/Long", "bajaScript/baja/obj/Marker", "bajaScript/baja/obj/NameList", "bajaScript/baja/obj/NameMap", "bajaScript/baja/obj/Object", "bajaScript/baja/obj/OrdToCategoryMap", "bajaScript/baja/obj/Password", "bajaScript/baja/obj/Permissions", "bajaScript/baja/obj/PermissionsMap", "bajaScript/baja/obj/RelTime", "bajaScript/baja/obj/Simple", "bajaScript/baja/obj/Singleton", "bajaScript/baja/obj/Status", "bajaScript/baja/obj/StatusValue", "bajaScript/baja/obj/String", "bajaScript/baja/obj/Time", "bajaScript/baja/obj/TimeFormat", "bajaScript/baja/obj/TimeZone", "bajaScript/baja/obj/TimeZoneDatabase", "bajaScript/baja/obj/Unit", "bajaScript/baja/obj/UnitDatabase", "bajaScript/baja/obj/Value", "bajaScript/baja/obj/WsAnnotation", "bajaScript/ctypes"], function (baja, AbsTime, BBoolean, Blob, CategoryMask, BDate, DaysOfWeekBits, DefaultSimple, Dimension, Double, DynamicEnum, Enum, EnumRange, EnumSet, Facets, FacetsMap, Float, Format, FrozenEnum, Icon, Integer, Long, Marker, NameList, NameMap, BObject, OrdToCategoryMap, Password, Permissions, PermissionsMap, RelTime, Simple, Singleton, Status, StatusValue, BString, Time, TimeFormat, TimeZone, TimeZoneDatabase, Unit, UnitDatabase, Value, WsAnnotation) {
  "use strict";

  var registerType = baja.registerType;
  function registerAll(obj) {
    baja.iterate(obj, function (ctor, typeSpec) {
      registerType(typeSpec, function () {
        return ctor;
      });
    });
  }

  //all these get baja namespaced and type registered, e.g. baja.Float and 
  //"baja:Float"
  registerAll({
    "baja:AbsTime": baja.AbsTime = AbsTime,
    "baja:Blob": baja.Blob = Blob,
    "baja:Boolean": /* not in baja */BBoolean,
    "baja:CategoryMask": /* not in baja */CategoryMask,
    "baja:Date": baja.Date = BDate,
    "baja:DaysOfWeekBits": baja.DaysOfWeekBits = DaysOfWeekBits,
    "baja:Dimension": baja.Dimension = Dimension,
    "baja:Double": baja.Double = Double,
    "baja:DynamicEnum": baja.DynamicEnum = DynamicEnum,
    "baja:EnumRange": baja.EnumRange = EnumRange,
    "baja:EnumSet": baja.EnumSet = EnumSet,
    "baja:Facets": baja.Facets = Facets,
    "baja:FacetsMap": baja.FacetsMap = FacetsMap,
    "baja:Float": baja.Float = Float,
    "baja:Format": baja.Format = Format,
    "baja:FrozenEnum": baja.FrozenEnum = FrozenEnum,
    "baja:Icon": baja.Icon = Icon,
    "baja:Integer": baja.Integer = Integer,
    "baja:Long": baja.Long = Long,
    "baja:Marker": baja.Marker = Marker,
    "baja:NameList": baja.NameList = NameList,
    "baja:NameMap": baja.NameMap = NameMap,
    "baja:Object": baja.Object = BObject,
    "baja:OrdToCategoryMap": /* not in baja */OrdToCategoryMap,
    "baja:Password": /* not in baja */Password,
    "baja:Permissions": baja.Permissions = Permissions,
    "baja:PermissionsMap": baja.PermissionsMap = PermissionsMap,
    "baja:RelTime": baja.RelTime = RelTime,
    "baja:Simple": baja.DefaultSimple = DefaultSimple,
    "baja:Singleton": baja.Singleton = Singleton,
    "baja:Status": baja.Status = Status,
    "baja:StatusValue": baja.StatusValue = StatusValue,
    "baja:String": /* not in baja */BString,
    "baja:Time": baja.Time = Time,
    "baja:TimeZone": baja.TimeZone = TimeZone,
    "baja:Unit": baja.Unit = Unit,
    "baja:Value": baja.Value = Value,
    "baja:WsAnnotation": /* not in baja */WsAnnotation
  });

  //and now special cases - these go in the baja namespace, but don't
  //register a type
  baja.Simple = Simple;
  baja.Enum = Enum;
  baja.TimeFormat = TimeFormat;
  baja.TimeZoneDatabase = TimeZoneDatabase;
  baja.UnitDatabase = UnitDatabase;
  return baja;
});
