/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * Http-only connection that will not attempt to use a web socket.
 *
 * API Status: **Private**
 * @module baja/env/HttpOnlyConnection
 */
define(["bajaScript/comm", "bajaScript/env/Connection", "bajaScript/baja/comm/Callback"], function (baja, Connection, Callback) {
  "use strict";

  /**
   * A connection that does not attempt to use a WebSocket for communication.
   * It will perform authentication and nothing else.
   *
   * @class
   * @alias module:baja/env/HttpOnlyConnection
   * @extends module:baja/env/Connection
   */
  var _HttpOnlyConnection = function HttpOnlyConnection() {
    baja.callSuper(_HttpOnlyConnection, this, arguments);
    this.$secure = /^https/i.test(_HttpOnlyConnection.$getProtocol());
  };
  baja.subclass(_HttpOnlyConnection, Connection);

  /**
   * Authenticates by creating a new server session.
   * @returns {Promise}
   */
  _HttpOnlyConnection.prototype.doAuthenticate = function () {
    var cb = new Callback();
    baja.comm.makeServerSession(cb);
    return cb.promise();
  };

  /**
   * @private
   * @returns {string}
   */
  _HttpOnlyConnection.$getProtocol = function () {
    return location.protocol;
  };

  /**
   * @returns {boolean}
   * @since Niagara 4.14
   */
  _HttpOnlyConnection.prototype.isSecure = function () {
    return this.$secure;
  };

  /**
   * Always returns false to indicate that the caller should send the data over
   * HTTP.
   */
  _HttpOnlyConnection.prototype.send = function () {
    return false;
  };
  return _HttpOnlyConnection;
});
