/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/tag/BRelation
 */
define(["bajaScript/sys", "bajaScript/baja/comp/Struct", "bajaScript/baja/tag/Id", "bajaScript/baja/tag/RelationTags", "bajaPromises"], function (baja, Struct, Id, RelationTags, Promise) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * Represents a `baja:Relation` in BajaScript.
   *
   * @class
   * @alias module:baja/tag/BRelation
   * @extends baja.Struct
   * @private
   */
  var Relation = function Relation() {
    callSuper(Relation, this, arguments);
  };

  // Set up the prototype chain
  subclass(Relation, Struct);

  /**
   * @returns {module:baja/tag/Relation} The relation's Id
   * or null if there isn't one.
   */
  Relation.prototype.getId = function () {
    return this.getParent() ? new Id(this.getRelationId()) : null;
  };

  /**
   * @returns Returns a Promise that resolves to a Relation's Entity.
   */
  Relation.prototype.toEndpoint = function () {
    return this.getEndpointOrd().get();
  };

  /**
   * @returns Returns the ORD to the Relation's Entity.
   */
  Relation.prototype.getEndpointOrd = function () {
    return this.getSourceOrd();
  };

  /**
   * @returns {Promise} A promise that resolves to a Tags object. This method
   * is designed to be overridden/replaced if the Tags are resolved differently.
   */
  Relation.prototype.tags = function () {
    return Promise.resolve(new RelationTags(this));
  };
  return Relation;
});
