/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.SyncCursor}.
 * @module baja/sys/structures/SyncCursor
 */
define(["bajaScript/baja/sys/inherit", "bajaScript/baja/sys/structures/Cursor"], function (inherit, Cursor) {
  "use strict";

  var subclass = inherit.subclass,
    notImplementedStr = "Not implemented";

  /** 
   * A generic Synchronous cursor used for iteration.
   *
   * @class
   * @alias baja.SyncCursor
   * @extends baja.Cursor
   */
  var SyncCursor = function SyncCursor() {};
  subclass(SyncCursor, Cursor);

  /**
   * Advance cursor and return true if successful.
   *
   * @abstract
   * @returns {Boolean}
   */
  SyncCursor.prototype.next = function () {
    throw new Error(notImplementedStr);
  };
  return SyncCursor;
});
