/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

define(["bajaScript/sys"], function objUtil(baja) {
  'use strict';

  var bajaHasType = baja.hasType;

  // A caching function wrapper for decodeFromString
  function cacheDecode(decodeFunc) {
    // Since Simples are immutable, this function will cache the String used to decode the Simple
    // so when encodeToString is called, this string can be returned
    return function decodeFromString(str) {
      var v = decodeFunc.apply(this, arguments);
      v.$cEncStr = str;
      return v;
    };
  }

  // A caching function wrapper for encodeToString
  function cacheEncode(encodeFunc) {
    // Since Simples are immutable, this function will attempt to get or create a cached string 
    // encoded value
    return function encodeToString() {
      if (this.$cEncStr === undefined) {
        this.$cEncStr = encodeFunc.call(this);
      }
      return this.$cEncStr;
    };
  }

  // Removes caching wrapper for Simple constants (mainly needed for number Simples)
  function uncacheConstantEncodeDecode(constant) {
    // Take the encodeToString and decodeToString on the prototype chain 
    // and apply it directly as a property on the constant
    var c = constant; // Workaround for JsLint
    constant.decodeFromString = c.decodeFromString;
    constant.encodeToString = c.encodeToString;
    return constant;
  }

  // Default equals equivalent  
  function equalsEquivalent(obj1, obj2) {
    // By default, just perform equals
    return obj1.equals(obj2);
  }
  function objectGetIcon(obj) {
    return obj.getType().getIcon();
  }

  // New copy that gets the value of the object for the clone
  function valueOfNewCopy(obj, exact) {
    return obj.valueOf();
  }

  // Equals that uses valueOf for the comparison
  function valueOfEquals(obj1, obj2) {
    return bajaHasType(obj2) && obj2.getType().equals(obj1.getType()) && obj2.valueOf() === obj1.valueOf();
  }
  function capitalizeFirstLetter(string) {
    if (string.length > 0) {
      return string.charAt(0).toUpperCase() + string.substring(1, string.length);
    }
    return string;
  }
  return {
    cacheDecode: cacheDecode,
    cacheEncode: cacheEncode,
    capitalizeFirstLetter: capitalizeFirstLetter,
    equalsEquivalent: equalsEquivalent,
    objectGetIcon: objectGetIcon,
    uncacheConstantEncodeDecode: uncacheConstantEncodeDecode,
    valueOfEquals: valueOfEquals,
    valueOfNewCopy: valueOfNewCopy
  };
});
