function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * Defines {@link baja.Password}.
 * @private
 * @module baja/obj/Password
 */
define(["lex!", "bajaScript/sys", "bajaScript/baja/obj/DefaultSimple"], function (lexjs, baja, DefaultSimple) {
  'use strict';

  /**
   * @class
   * @alias module:baja/obj/Password
   * @private
   * @extends baja.DefaultSimple
   */
  var Password = /*#__PURE__*/function (_DefaultSimple) {
    function Password() {
      _classCallCheck(this, Password);
      return _callSuper(this, Password, arguments);
    }
    _inherits(Password, _DefaultSimple);
    return _createClass(Password, [{
      key: "encodeToString",
      value:
      /**
       * Encoding a Password to string is *only* supported when connected over a secure channel. This
       * applies whether using `Complex#set` to set a Password slot, serializing a `Complex` to BSON
       * to pass to an RPC, or simply calling `password.encodeToString()`.
       * @private
       * @returns {String}
       * @throws {Error} if doing an encodeToString() directly or BSON-encoding in an insecure context
       */
      function encodeToString() {
        if (!baja.bson.$canEncodeSecurely()) {
          throw new Error(lexjs.$getSync({
            module: 'baja',
            key: 'password.encoder.secureEnvironmentRequired',
            def: 'Cannot encode sensitive values to string in an insecure environment.'
          }));
        }
        return this.$val;
      }

      /**
       * Decode a `Password` from a `String`.
       *
       * @param {String} str
       * @returns {module:baja/obj/Password}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (!str) {
          return Password.DEFAULT;
        }
        var pw = new Password(str);
        pw.getType = this.getType;
        return pw;
      }

      /**
       * Equality test.
       * Starting in Niagara 4.13U2, this method also ensures that `Password.make('')` and
       * `Password.DEFAULT` are not equal.
       * @param {module:baja/obj/Password|*} other
       * @returns {boolean}
       */
    }, {
      key: "equals",
      value: function equals(other) {
        var iAmDefault = this === Password.DEFAULT;
        var otherIsDefault = other === Password.DEFAULT;
        if (iAmDefault !== otherIsDefault) {
          return false;
        }
        return other instanceof Password && this.$val === other.$val;
      }

      /**
       * Override toString() to return a default string representation for passwords
       * @returns {String} Default string representation
       */
    }, {
      key: "toString",
      value: function toString() {
        return "--password--";
      }
    }], [{
      key: "make",
      value:
      /**
       * @param {String} str
       * @returns {module:baja/obj/Password}
       * @since Niagara 4.13
       */
      function make(str) {
        return new Password(str);
      }
    }]);
  }(DefaultSimple);
  /**
   * Default 'Password' instance.
   * @type {Password}
   */
  Password.DEFAULT = new Password();
  return Password;
});
