function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/*eslint-env browser */

/**
 * Defines {@link baja.Blob}
 * @module baja/obj/Blob
 */
define(['bajaScript/sys', 'bajaScript/baja/obj/Simple', 'bajaScript/baja/obj/byteUtil', 'lex!'], function (baja, Simple, byteUtil, lexjs) {
  'use strict';

  /**
   * A `baja:Blob` of Bajascript is a wrapper class for raw byte array objects.
   *
   * @since Niagara 4.14
   * @class
   * @alias baja.Blob
   * @extends baja.Simple
   */
  var Blob = /*#__PURE__*/function (_Simple) {
    /**
     * When creating a `Blob` use make() instead of new Object.
     * Constructor should be considered private.
     *
     * @param {Uint8Array} byteArr array of bytes
     */
    function Blob() {
      var _this;
      var byteArr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Uint8Array();
      _classCallCheck(this, Blob);
      _this = _callSuper(this, Blob);
      if (!(byteArr && byteArr instanceof Uint8Array)) {
        throw new Error(lexjs.$getSync({
          module: 'baja',
          key: 'blob.arrayInput.message',
          def: 'array input is required.'
        }));
      }
      _this.$byteArr = byteArr;
      return _this;
    }

    /**
     * Returns the Blob as an encoded string.
     *
     * @returns {String} encoded string
     */
    _inherits(Blob, _Simple);
    return _createClass(Blob, [{
      key: "encodeToString",
      value: function encodeToString() {
        return byteUtil.byteArrayToBase64String(this.$byteArr);
      }

      /**
       * Converts the input string to a Blob.
       *
       * @param {string} base64String
       * @returns {baja.Blob}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString() {
        var base64String = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        if (base64String.length === 0) {
          return Blob.DEFAULT;
        }
        return Blob.make(byteUtil.base64StringToByteArray(base64String));
      }

      /**
       * Makes a `Blob`.
       *
       * @param {Uint8Array} byteArr array of bytes
       * @returns {baja.Blob}
       * @example
       *
       * // blob can be created with a byte array.
       * let blob = baja.Blob.make(new Uint8Array([ 1, 2, 3, 4, 5, 6 ]));
       *
       * // DEFAULT blob can be created with no parameters.
       * let blob = baja.Blob.make();
       *
       * // blob can be created as a DEFAULT.
       * let blob = baja.Blob.DEFAULT;
       */
    }, {
      key: "make",
      value: function make() {
        var byteArr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Uint8Array();
        return Blob.make(byteArr);
      }

      /**
       * @returns {Number} Byte length of the Blob
       */
    }, {
      key: "length",
      value: function length() {
        return this.$byteArr.length;
      }

      /**
       * @param {Number} index position of the bytes in the Blob
       * @returns {Number|undefined} Number if a byte is available at given index else undefined.
       */
    }, {
      key: "byteAt",
      value: function byteAt(index) {
        return this.$byteArr.at(index);
      }

      /**
       * @returns {Uint8Array} array of the Blob bytes
       */
    }, {
      key: "getBytes",
      value: function getBytes() {
        //Return a copy of the byte array to avoid instance modification.
        return this.$byteArr.slice();
      }

      /**
       * Returns the blob's byte array with the index position as the pivot.
       * In case of an empty array, bytes are copied into it and index position is not considered.
       *
       * @param {Array} arrayToCopy
       * @param index
       * @returns {Uint8Array}
       */
    }, {
      key: "copyBytes",
      value: function copyBytes(arrayToCopy, index) {
        arrayToCopy.splice.apply(arrayToCopy, [index, 0].concat(_toConsumableArray(Array.from(this.$byteArr))));
        return new Uint8Array(arrayToCopy);
      }

      /**
       *  Checks for equality of bytes in the Blob and input.
       *
       * @param {Array} byteArr
       * @returns {boolean}
       */
    }, {
      key: "bytesEqual",
      value: function bytesEqual(byteArr) {
        if (byteArr.length !== this.$byteArr.length) {
          return false;
        }
        for (var i = 0; i < this.$byteArr.length - 1; i++) {
          if (byteArr[i] !== this.$byteArr[i]) {
            return false;
          }
        }
        return true;
      }

      /**
       * @param {Uint8Array} byteArr
       * @returns {baja.Blob}
       */
    }], [{
      key: "make",
      value: function make() {
        var byteArr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Uint8Array();
        return new Blob(byteArr);
      }

      /**
       * Makes a Blob from an input hex string.
       *
       * @param {String} hexString
       * @returns {baja.Blob}
       * @example
       *
       * let blob = baja.Blob.make('00123a');
       */
    }, {
      key: "makeBlobFromHexString",
      value: function makeBlobFromHexString(hexString) {
        // If user enters an empty string, return a default Blob without invoking the Blob.DEFAULT.decodeFromString()
        if (hexString.trim().length === 0) {
          return Blob.DEFAULT;
        }
        // Check if input string is a Hex and return Blob from decoded Hex String.
        if (isHex(hexString)) {
          var base64String = hexStringToBase64String(hexString);
          return Blob.DEFAULT.decodeFromString(base64String);
        }
        // Throw an error if input is not a Hex String.
        throw new Error(lexjs.$getSync({
          module: 'baja',
          key: 'blob.notAHexString.message',
          def: '{0} is not a hexadecimal.',
          args: [hexString]
        }));
      }

      /**
       * @returns {baja.Blob}
       */
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }
    }]);
  }(Simple);
  /**
   * Converts Hex string to a Base64 array.
   *
   * @private
   * @param {String} hexString
   * @returns {String}
   */
  var hexStringToBase64String = function hexStringToBase64String(hexString) {
    // hex string cannot have odd length, prepending a '0' if it's odd.
    hexString = hexString.length % 2 === 0 ? hexString : '0' + hexString;
    return btoa(String.fromCharCode.apply(null, hexString.replace(/([A-Fa-f\d]{2})/g, "0x$1;") // 00123a => [ 0x00;0x12;0x3a]
    .replace(/;$/, "").split(";")) // removes end ; and splits them
    );
  };

  /**
   * Validates if input string is Hexadecimal.
   *
   * @private
   * @param {String} str
   * @returns {boolean}
   */
  var isHex = function isHex(str) {
    return !str.match(/[^A-Fa-f\d]/);
  };
  var DEFAULT = Blob.make();
  return Blob;
});
