/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/SetFacetsOp
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/obj/Facets", "bajaScript/baja/boxcs/SyncOp"], function (baja, Facets, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper,
    bajaDef = baja.def;

  /**
   * @class Set dynamic Slot Facets SyncOp.
   *
   * @name SetFacetsOp
   * @extends SyncOp
   * @inner
   * @private
   *
   * @param comp the Component for the slot the facets are being set upon.
   * @param {baja.Slot} slot the target dynamic slot for the facets change.
   * @param {baja.Facets} facets the new Slot facets.
   */
  function SetFacetsOp(comp, slot, facets) {
    callSuper(SetFacetsOp, this, arguments);

    // Encode argument to a data structure
    var a = {
      nm: this.getId(),
      h: comp.getHandle(),
      n: slot.getName(),
      x: facets.encodeToString()
    };
    this.$arg = a;
  }
  subclass(SetFacetsOp, SyncOp);
  SetFacetsOp.id = "x";

  /**
   * Decode and commit the SyncOp.
   *
   * @private
   *
   * @param comp the Component the set facets op will happen upon.
   * @param sp the syncOp data structure to be decoded.
   */
  SetFacetsOp.decodeAndCommit = function (comp, sp) {
    if (comp !== null) {
      var name = sp.n,
        fcts = Facets.DEFAULT.decodeFromString(bajaDef(sp.x, ""), baja.Simple.$unsafeDecode),
        displayName = sp.dn,
        display = sp.d;
      comp.setFacets({
        "slot": name,
        "facets": fcts,
        "cx": {
          commit: true,
          displayName: displayName,
          display: display,
          serverDecode: true
        }
      });
    }
  };
  return SetFacetsOp;
});
