/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/RemoveKnobOp
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/boxcs/SyncOp"], function (baja, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * @class Remove Knob SyncOp.
   *
   * @name RemoveKnobOp
   * @extends SyncOp
   * @inner
   * @private
   */
  function RemoveKnobOp() {
    callSuper(RemoveKnobOp, this, arguments);
    throw new Error("Unsupported");
  }
  subclass(RemoveKnobOp, SyncOp);
  RemoveKnobOp.id = "j";

  /**
   * Decode and commit the SyncOp.
   *
   * @private
   *
   * @param comp the Component the knob will be added too.
   * @param sp the syncOp data structure to be decoded.
   */
  RemoveKnobOp.decodeAndCommit = function (comp, sp) {
    if (comp !== null) {
      comp.$fw("uninstallKnob", sp.id, sp.ss, {
        commit: true,
        serverDecode: true
      });
    }
  };
  return RemoveKnobOp;
});
