/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/AddKnobOp
 * @private
 */
define(["bajaScript/bson", "bajaScript/baja/boxcs/SyncOp"], function (baja, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper,
    bsonDecodeKnob = baja.bson.decodeKnob;

  /**
   * @class Add Knob SyncOp
   *
   * @name AddKnobOp
   * @extends SyncOp
   * @inner
   * @private
   */
  function AddKnobOp() {
    callSuper(AddKnobOp, this, arguments);
    throw new Error("Unsupported");
  }
  subclass(AddKnobOp, SyncOp);
  AddKnobOp.id = "k";

  /**
   * Decode and commit the SyncOp.
   *
   * @name AddKnobOp.decodeAndCommit
   * @function
   * @private
   *
   * @param comp the Component the knob will be added too.
   * @param sp the syncOp data structure to be decoded.
   */
  AddKnobOp.decodeAndCommit = function (comp, sp) {
    return comp && comp.$fw("installKnob", bsonDecodeKnob(sp.nk), {
      commit: true,
      serverDecode: true
    });
  };
  return AddKnobOp;
});
