function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/*jshint browser: true */ /* eslint-env browser */

/**
 * API Status: **Private**
 * @module  module:nmodule/naxisVideo/rc/naxisVideo/NAxisVideoStream
 */
define(['baja!', 'lex!naxisVideo', 'lex!videoDriver', 'log!nmodule.naxisVideo.rc.naxisVideo.NAxisVideoStream', 'bajaux/Properties', 'bajaux/Widget', 'jquery', 'mediaStreamLibrary', 'Promise', 'underscore', 'nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/naxisVideo/rc/naxisVideo/naxisVideoUtils', 'css!nmodule/naxisVideo/rc/naxisVideo'], function (baja, axisLexs, lexs, log, Properties, Widget, $, mediaStreamLibrary, Promise, _, StreamConfigurationMixin, asyncUtils, videoDriverUtils, VideoFeedMixin, BaseEditor, naxisVideoUtils) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var _axisLexs = _slicedToArray(axisLexs, 1),
    axisLex = _axisLexs[0];
  var logFine = log.fine.bind(log);
  var logSevere = log.severe.bind(log);
  var CONNECTION_STATUS_CHANGED_EVENT = VideoFeedMixin.CONNECTION_STATUS_CHANGED_EVENT,
    STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT,
    TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;
  var H264_ENCODING = 'h264';
  var JPEG_ENCODING = 'jpeg';
  var tpl = function tpl() {
    return "  \n    <video autoplay muted class='videoInsert'></video> \n    <canvas width='718' height='531' class='videoInsert'></canvas>";
  };

  /**
   * Baja Widget for LiveVideo via Axis Communication's media-stream-library
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/naxisVideo/rc/naxisVideo/NAxisVideoStream
   * @mixes module:nmodule/videoDriver/rc/live/VideoFeedMixin
   */
  var NAxisVideoStream = /*#__PURE__*/function (_BaseEditor) {
    function NAxisVideoStream(params) {
      var _this;
      _classCallCheck(this, NAxisVideoStream);
      _this = _callSuper(this, NAxisVideoStream, [_.extend({
        keyName: 'NAxisVideoStream',
        moduleName: 'naxisVideo'
      }, {}, params)]);
      _this.$pipeline = null;
      _this.$connectionTimeoutMillis = 25000;
      _this.$fps = 4;
      _this.$compression = 0;
      _this.$resolution = '800x450';
      StreamConfigurationMixin(_this);
      VideoFeedMixin(_this);
      return _this;
    }

    /**
     *
     * @param {jQuery} dom
     * @returns {Promise}
     */
    _inherits(NAxisVideoStream, _BaseEditor);
    return _createClass(NAxisVideoStream, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('NAxisVideoStream');
      }

      /**
       * @param {baja.Component} value that should be a `naxisVideo:AxisVideoCamera`
       * @param {object} [params]
       * @param {boolean} [params.fullLoad] if true, the camera must be fully
       * connected, logged in, and streaming before `load()` will resolve.
       * Otherwise, the widget will show the connecting/logging-in process to the
       * user.
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          fullLoad = _ref.fullLoad;
        //Some host names are entered as just 172.31.67.222, for rtsp, some hostnames are entered as 172.31.67.222/axis-media/media.amp
        this.$hostName = value.get("hostName").split("/")[0];
        if (_.isUndefined(this.$hostName) || _.isEmpty(this.$hostName)) {
          return Promise.resolve(); //nothing to stream
        }

        //close any previous stream if the hostName is different
        //TODO: keep the Pipeline going if the hostname is the same as before, there could be spurious load calls
        //from px pages.
        if (this.$pipeline) {
          this.$pipeline.close();
        }
        this.$wsScheme = window.location.protocol.indexOf('https') > -1 ? 'wss' : 'ws';
        this.$httpPort = value.get(this.$wsScheme === 'wss' ? 'webClientHttpsPort' : 'webClientHttpPort');
        this.$rtspPort = value.get('controlPort');
        this.$axisCameraOrd = value.getNavOrd();
        return Promise.resolve(fullLoad);
      }

      /**
       * Set user preferences will be used to load and stream the camera.
       *
       * @param {module:nmodule/videoDriver/rc/live/stream/StreamSettings} settings
       * @see module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
       */
    }, {
      key: "applyStreamSettings",
      value: function applyStreamSettings() {
        var settings = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var _settings$preferredRe = settings.preferredResolution,
          preferredResolution = _settings$preferredRe === void 0 ? baja.$('videoDriver:VideoResolutionEnum').make(0) : _settings$preferredRe,
          _settings$preferredFr = settings.preferredFrameRate,
          preferredFrameRate = _settings$preferredFr === void 0 ? baja.$('videoDriver:VideoFrameRateEnum').make(0) : _settings$preferredFr,
          _settings$preferredCo = settings.preferredCompression,
          preferredCompression = _settings$preferredCo === void 0 ? baja.$('videoDriver:VideoCompressionEnum').make(0) : _settings$preferredCo;
        // Look at AxisVideoStreamRequest for the logic behind the conversion of the axis camera's compression, resolution and frame rate.
        // Fps values, high = 30, medium = 15 and low = 4.
        this.$fps = naxisVideoUtils.getFps(preferredFrameRate);
        // Compression values, high = 80, medium = 30, low = 10 and none = 0.
        this.$compression = naxisVideoUtils.getCompression(preferredCompression);
        // Resolution values(WxH), high = 1920x1080, medium = 1280x720 and low = 800x450.
        this.$resolution = naxisVideoUtils.getResolution(preferredResolution, this.value().getResolutionSettings());
        // Load the axis video camera after receiving the stream settings.
        return this.$loadCamera();
      }

      /**
       * Loads the camera.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$loadCamera",
      value: function $loadCamera() {
        var _this2 = this;
        return this.$validateInputParams().then(function () {
          _this2.$setVideoConnectionStatus(lex.get("connection.inProgress"));
          var promise = Promise.resolve(_this2.$authorize().then(function (token) {
            var cameraStream = _this2.$play(token);
            return cameraStream;
          })).then(function () {
            _this2.$setVideoConnectionStatus(lex.get("connection.successful"));
          })["catch"](function (err) {
            baja.error(err);
            _this2.$setVideoConnectionStatus(lex.get("connection.failed"));
            throw err;
          });
          asyncUtils.waitInterval(_this2.$connectionTimeoutMillis).then(function () {
            if ((!_this2.$clock || !_this2.$clock.getCurrentTimestamp()) && lex.get("connection.successful") !== _this2.getVideoConnectionStatus()) {
              _this2.$setVideoConnectionStatus(lex.get("connection.timeout"));
            }
          })["catch"](baja.error);
          return promise;
        });
      }

      /**
       * Authorizes using a token.
       *
       * @private
       * @return {Promise}
       */
    }, {
      key: "$authorize",
      value: function $authorize() {
        var _this3 = this;
        return baja.rpc({
          ord: this.$axisCameraOrd,
          args: ['/axis-cgi/rtspwssession.cgi'],
          //tokenURI
          methodName: 'getToken'
        }).then(function (response) {
          if (response['token'] === '-1' && response['responseMessage'] === 'Browser') {
            var fetchOptions = {
              credentials: 'include',
              headers: {
                'Axis-Orig-Sw': true,
                'X-Requested-With': 'XMLHttpRequest'
              },
              mode: 'no-cors'
            };
            return window.fetch("".concat(window.location.protocol, "//").concat(_this3.$hostName, ":").concat(_this3.$httpPort, "/axis-cgi/usergroup.cgi"), fetchOptions);
          } else if (response['responseCode'] === '200' && response['token'] !== '-1') {
            return response['token'];
          } else if (response['responseCode'] === '400' && response['token'] === '-1') {
            logSevere(axisLex.get("token.api.error"));
            throw new Error(axisLex.get("token.api.error"));
          } else if (response['responseCode'] === '-1' && response['token'] === '-1' && response['responseMessage'].includes('SSLException')) {
            logSevere(axisLex.get("failedCertificateValidationOnCameraPing"));
            throw new Error(axisLex.get("failedCertificateValidationOnCameraPing"));
          } else {
            logSevere(response['responseMessage']);
            throw new Error(response['responseMessage']);
          }
        });
      }

      /**
       * Plays the video stream.
       *
       * @private
       * @param {String} token
       * @return {Promise}
       */
    }, {
      key: "$play",
      value: function $play(token) {
        var _this4 = this;
        var videoEl = $('video', this.jq())[0];
        var canvasEl = $('canvas', this.jq())[0];
        // Grab a reference to the video element
        var Pipeline;
        var mediaElement;
        var encoding = this.$getEncoding();
        logFine("NAxisVideoStream#play- encoding: ".concat(encoding));
        if (encoding === 'h264') {
          Pipeline = mediaStreamLibrary.pipelines.Html5VideoPipeline;
          mediaElement = videoEl;
          if (canvasEl) {
            canvasEl.remove();
          }
        } else {
          Pipeline = mediaStreamLibrary.pipelines.Html5CanvasPipeline;
          mediaElement = canvasEl;
          if (videoEl) {
            videoEl.remove();
          }
        }

        // Token will be type of String when it's fetched from Axis Camera
        // Token will not be required if the response type is other than String, in this case
        // window.fetch's response will be the Object type
        // and Camera doesn't expect a token for this api request.
        if (typeof token === 'string') {
          this.$wsUri = "".concat(this.$wsScheme, "://").concat(this.$hostName, ":").concat(this.$httpPort, "/rtsp-over-websocket?rtspwssession=").concat(token);
        } else {
          this.$wsUri = "".concat(this.$wsScheme, "://").concat(this.$hostName, ":").concat(this.$httpPort, "/rtsp-over-websocket");
        }
        this.$rtspUri = "rtsp://".concat(this.$hostName, ":").concat(this.$rtspPort, "/axis-media/media.amp?videocodec=").concat(encoding, "&resolution=").concat(this.$resolution, "&fps=").concat(this.$fps, "&compression=").concat(this.$compression);
        // Setup a new pipeline
        var pipeline = new Pipeline({
          ws: {
            uri: this.$wsUri
          },
          rtsp: {
            uri: this.$rtspUri
          },
          mediaElement: mediaElement
        });

        // notify live stream -- FIX for Firefox
        pipeline.onSourceOpen = function (mse) {
          mse.duration = 0;
        };
        this.$pipeline = pipeline;
        var startTimestampSync = _.once(function () {
          _this4.$updateClockTime();
          if (encoding === JPEG_ENCODING) {
            try {
              //Workaround for `jpeg` encoding to tell when we have a new frame and so we know when to display Connection Timeout
              //https://github.com/AxisCommunications/media-stream-library-js/issues/36
              var scheduler = pipeline.lastComponent._scheduler,
                handler = scheduler._handler,
                that = _this4;
              scheduler._handler = function (e) {
                that.timeUpdate();
                return handler.apply(scheduler, arguments);
              };
            } catch (err) {
              logSevere("NAxisVideoStream cannot display timeouts", err);
            }
          } else if (encoding === H264_ENCODING && _this4.$isSafari()) {
            //Safari Desktop will stop playing if the buffer edge is ever reached so its needs continuous  play calls until this issue is fixed
            //https://github.com/AxisCommunications/media-stream-library-js/issues/141
            clearInterval(_this4.$safariPlayTicket);
            _this4.$safariPlayTicket = setInterval(function () {
              if (videoEl) {
                videoEl.play();
              }
            }, 500);
          }
        });
        pipeline.onSync = function (ntpTimestampMilliseconds) {
          _this4.$clock = new NAxisVideoClock(ntpTimestampMilliseconds);
          startTimestampSync();
        };
        return pipeline.ready.then(function () {
          return pipeline.rtsp.play();
        });
      }

      /**
       * Validates the input parameters required to authorize and play the camera stream.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$validateInputParams",
      value: function $validateInputParams() {
        var inputParams = {
          hostname: this.$hostName,
          'http(s)Port': this.$httpPort,
          rtspPort: this.$rtspPort
        };
        var missedParams = [];
        for (var param in inputParams) {
          if (_.isUndefined(inputParams[param])) {
            missedParams.push(param);
          }
        }
        if (missedParams.length > 0) {
          return Promise.reject(new Error(axisLex.get('naxisVideoStream.missingParams.error') + missedParams));
        }
        return Promise.resolve();
      }

      /**
       * Return the encoding to use. Either `jpeg` or `h264`.
       * This can be overridden with a ViewQuery parameter with the name `encoding` in the window.location.href.
       *
       * @private
       * @return {string}
       */
    }, {
      key: "$getEncoding",
      value: function $getEncoding() {
        var viewParamEncoding = videoDriverUtils.getViewParameter('encoding');
        if (viewParamEncoding === JPEG_ENCODING || viewParamEncoding === H264_ENCODING) {
          //only supported encodings
          return viewParamEncoding;
        }
        if (!this.$canPlayWithVideoTag()) {
          return JPEG_ENCODING;
        }
        return H264_ENCODING;
      }

      /**
       * @returns {number}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "getVideoTimestamp",
      value: function getVideoTimestamp() {
        return this.$currentTimestamp;
      }

      /**
       * @returns {boolean}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "isVideoStreaming",
      value: function isVideoStreaming() {
        return !!this.$isVideoStreaming;
      }

      /**
       * Notifies of a clock time change based upon the clock time.
       * @private
       */
    }, {
      key: "$updateClockTime",
      value: function $updateClockTime() {
        if (!this.$clock) {
          return;
        }
        this.$currentTimestamp = this.$clock.getCurrentTimestamp();
        this.emit(TIMESTAMP_CHANGED_EVENT);
        this.emit(STREAM_DATA_RECEIVED_EVENT);
      }

      /**
       * Is called when a new video frame is available.
       */
    }, {
      key: "timeUpdate",
      value: function timeUpdate() {
        var _this5 = this;
        this.$isVideoStreaming = true;
        this.$updateClockTime();
        //if duration doesn't change again in a while, make sure to display a timeout message
        clearTimeout(this.$connectionTimeout);
        this.$connectionTimeout = setTimeout(function () {
          _this5.$setVideoConnectionStatus(lex.get("connection.timeout"));
        }, this.$connectionTimeoutMillis);
      }

      /**
       * @returns {String}
       * @see module:nmodule/videoDriver/rc/live/VideoDriverMixin
       */
    }, {
      key: "getVideoConnectionStatus",
      value: function getVideoConnectionStatus() {
        return this.$currentStatus;
      }

      /**
       * Calls the updated status callback if set.
       * @private
       * @param {String} status
       */
    }, {
      key: "$setVideoConnectionStatus",
      value: function $setVideoConnectionStatus(status) {
        this.$currentStatus = status;
        this.emit(CONNECTION_STATUS_CHANGED_EVENT);
      }

      /**
       * Return true if this is iOS
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isIOS",
      value: function $isIOS() {
        return navigator.userAgent.toLowerCase().indexOf('like mac os x') > -1;
      }

      /**
       * Return true if video can be used.
       * `h264` for most browsers and `jpeg` for iOS and JxBrowser.
       * @private
       * @return {boolean}
       */
    }, {
      key: "$canPlayWithVideoTag",
      value: function $canPlayWithVideoTag() {
        //ios 12 says it can play, but it can't
        //https://stackoverflow.com/questions/21120717/h-264-video-wont-play-on-ios
        //Level 3.1 AVC is supported on IOS but mediaStreamLibrary uses 'High Level 4.1'
        //https://cconcolato.github.io/media-mime-support/

        //https://caniuse.com/#feat=mediasource ios13 with ipadPro might work if we get one to test

        if (this.$isIOS()) {
          return false;
        }

        //JxBrowser is false for now https://jxbrowser-support.teamdev.com/docs/guides/media.html#video
        return window.MediaSource && window.MediaSource.isTypeSupported('video/mp4; codecs="avc1.640029"');
      }

      /**
       * Return true if this is the Safari Browser
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isSafari",
      value: function $isSafari() {
        return /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        if (this.$pipeline) {
          this.$pipeline.close();
          this.$pipeline = null;
          this.jq().removeClass('NAxisVideoStream');
        }
        clearTimeout(this.$connectionTimeout);
        clearInterval(this.$safariPlayTicket);
      }
    }]);
  }(BaseEditor);
  /**
   * Utility class that is responsible for providing the axis cameras current time via
   * comparison with the local machine time.
   */
  var NAxisVideoClock = /*#__PURE__*/function () {
    /**
     * Sets the sync time stamp and captures the current time for later comparison.
     * @param {number} syncTimestampMillis the cameras current time in millis
     */
    function NAxisVideoClock(syncTimestampMillis) {
      _classCallCheck(this, NAxisVideoClock);
      this.$syncTimestamp = syncTimestampMillis;
      this.$computerTimeAtSync = new Date().getTime();
    }

    /**
     * Gets the current time of the camera.
     * @returns {number} The cameras current time in millis
     */
    return _createClass(NAxisVideoClock, [{
      key: "getCurrentTimestamp",
      value: function getCurrentTimestamp() {
        var now = new Date().getTime();
        var offset = now - this.$computerTimeAtSync;
        return this.$syncTimestamp + offset;
      }
    }]);
  }();
  return NAxisVideoStream;
});
