/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/LoopPoint
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:LoopPoint` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/LoopPoint}
   */
  var LoopPoint = function LoopPoint() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(controlledVariable|setpoint)$': 'inputFacets',
      '^(proportionalConstant|integralConstant|derivativeConstant)$': 'tuningFacets'
    });
  };
  LoopPoint.prototype = Object.create(Component.prototype);
  LoopPoint.prototype.constructor = LoopPoint;
  return LoopPoint;
});
