function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/nrio/rc/wb/mgr/model/NrioDeviceManagerModel
 */

define(['baja!', 'baja!nrio:NrioDevice,nrio:NrioLearnDeviceEntry,nrio:NrioDeviceTypeEnum,nrio:NrioDeviceFolder', 'lex!nrio', 'Promise', 'nmodule/driver/rc/wb/mgr/DeviceMgrModel', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/BlobMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, type, lexs, Promise, DeviceMgrModel, DeviceExtsMgrColumn, MgrTypeInfo, BlobMgrColumn, NameMgrColumn, PropertyMgrColumn, IconMgrColumn, TypeMgrColumn, Column) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    NRIO_LEX = _lexs[0];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var NRIO_TYPE = baja.lt('nrio:NrioDevice');

  /**
   * Makes the columns for the manager model
   * @returns {Array<module:nmodule/webEditors/rc/wb/table/model/Column>}
   */
  function makeColumns() {
    return [new IconMgrColumn(), new NameMgrColumn({
      flags: EDITABLE
    }), new PropertyMgrColumn('deviceType', {
      flags: READONLY | EDITABLE,
      type: NRIO_TYPE
    }), new DeviceExtsMgrColumn('deviceExts', {
      dynamic: true
    }), new PropertyMgrColumn('status', {
      type: NRIO_TYPE
    }), new PropertyMgrColumn('enabled', {
      flags: EDITABLE | UNSEEN,
      type: NRIO_TYPE
    }), new PropertyMgrColumn('health', {
      flags: UNSEEN,
      type: NRIO_TYPE
    }), new PropertyMgrColumn('address', {
      flags: EDITABLE | READONLY,
      type: NRIO_TYPE
    }), new PropertyMgrColumn('secAddr', {
      displayName: NRIO_LEX.get('deviceManager.learn.secAddr'),
      flags: EDITABLE | READONLY,
      getDefaultValue: function getDefaultValue(comp) {
        if (comp.getType().getTypeSpec() === 'nrio:Nrio16Module') {
          return "";
        } else {
          return "0";
        }
      }
    }), new BlobMgrColumn('uid', {
      flags: EDITABLE | READONLY,
      type: NRIO_TYPE
    }), new PropertyMgrColumn('installedVersion', {
      type: NRIO_TYPE
    }), new PropertyMgrColumn('secVersion', {
      displayName: NRIO_LEX.get('deviceManager.learn.secVersion'),
      type: NRIO_TYPE
    }), new PropertyMgrColumn('availableVersion', {
      type: NRIO_TYPE
    })];
  }

  /**
   * Manager model for NrioDeviceUxManager
   * @class
   * @alias module:nmodule/nrio/rc/wb/mgr/model/NrioDeviceManagerModel
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgrModel
   */
  var NrioDeviceManagerModel = /*#__PURE__*/function (_DeviceMgrModel) {
    function NrioDeviceManagerModel() {
      _classCallCheck(this, NrioDeviceManagerModel);
      return _callSuper(this, NrioDeviceManagerModel, arguments);
    }
    _inherits(NrioDeviceManagerModel, _DeviceMgrModel);
    return _createClass(NrioDeviceManagerModel, null, [{
      key: "make",
      value: function make(component) {
        return Promise.all([makeColumns(), resolveNewTypes()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            columns = _ref2[0],
            newTypes = _ref2[1];
          return new NrioDeviceManagerModel({
            component: component,
            columns: columns,
            newTypes: newTypes,
            folderType: baja.lt('nrio:NrioDeviceFolder')
          });
        });
      }
    }]);
  }(DeviceMgrModel);
  /**
   * Return the types for new model entries
   * @returns {Promise<Array<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
   */
  function resolveNewTypes() {
    return MgrTypeInfo.make({
      from: 'nrio:NrioDevice',
      concreteTypes: true
    }).then(function (newTypes) {
      newTypes = newTypes.filter(function (type) {
        var typeSpec = type.getType().getTypeSpec();
        return typeSpec === 'nrio:Nrio16Module' || typeSpec === 'nrio:Nrio34Module';
      });
      return newTypes.sort();
    });
  }
  return NrioDeviceManagerModel;
});
