function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/nrio/rc/wb/mgr/NrioMgrTypeImpl
 */

define(['baja!', 'lex!nrio', 'baja!driver:DefaultProxyConversion,nrio:LinearCalibrationExt,nrio:NrioThermistorType3Conversion', 'Promise', 'underscore'], function (baja, lexs, types, Promise, _) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    NRIO_LEX = _lexs[0];
  return /*#__PURE__*/function () {
    function NrioMgrTypeImpl(pntType, extType, uiType, converter, displayKey) {
      _classCallCheck(this, NrioMgrTypeImpl);
      this.$extType = extType;
      this.$pntType = pntType;
      this.$uiType = uiType;
      this.$converter = converter;
      this.$displayName = NRIO_LEX.get(displayKey);
      if (this.$converter == null) {
        this.$converter = baja.$('driver:DefaultProxyConversion');
      }
    }

    /**
     * TypeImpl provides a different implementation of getDisplayName(), where
     * the module name will be appended to the resulting string in the case where
     * the type name is a duplicate.
     *
     * @returns {string}
     */
    return _createClass(NrioMgrTypeImpl, [{
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }

      /**
       * @returns {baja.Icon} The icon configured for the type.
       */
    }, {
      key: "getIcon",
      value: function getIcon() {
        return null;
      }

      /**
       * Get the underlying type wrapped by this instance.
       * @returns {baja.Type}
       */
    }, {
      key: "getType",
      value: function getType() {
        return this.$pntType;
      }

      /**
       * Returns a Promise to create a new instance
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "newInstance",
      value: function newInstance() {
        var _this = this;
        var pnt = this.$pntType.getInstance(),
          ext = this.$extType.getInstance();
        ext.setConversion(this.$converter);
        pnt.setProxyExt(ext);
        return baja.UnitDatabase.get().then(function (db) {
          var facets = pnt.get('facets');
          if (_this.$converter && _this.$converter.getType().is('nrio:NrioThermistorType3Conversion')) {
            var unitFacet = baja.Facets.make({
              units: db.getUnit("celsius")
            });
            facets = baja.Facets.make(facets, unitFacet);
          } else {
            var facetsValue = ext.getDeviceFacets().get("units");
            if (facetsValue != null) {
              var _unitFacet = baja.Facets.make({
                units: facetsValue
              });
              facets = baja.Facets.make(facets, _unitFacet);
            }
          }
          pnt.set({
            slot: 'facets',
            value: facets
          });
          var linearCalibrationExt = baja.$('nrio:LinearCalibrationExt');
          if (ext.getType().is('nrio:NrioVoltageInputProxyExt')) {
            linearCalibrationExt.setUnits(db.getUnit("volt"));
            pnt.add({
              slot: 'linearCalibration',
              value: linearCalibrationExt
            });
          } else if (ext.getType().is('nrio:NrioResistiveInputProxyExt')) {
            if (_this.$converter.getType().is('nrio:NrioThermistorType3Conversion')) {
              linearCalibrationExt.setUnits(db.getUnit("celsius"));
            } else {
              linearCalibrationExt.setUnits(db.getUnit("ohm"));
            }
            pnt.add({
              slot: 'linearCalibration',
              value: linearCalibrationExt
            });
          }
          return pnt;
        });
      }

      /**
       * Test whether the wrapped type can be matched against the given database component's type.
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(db) {
        return false;
      }

      /**
       * @returns {baja.Component} The control point type.
       */
    }, {
      key: "getPointTypeInfo",
      value: function getPointTypeInfo() {
        return this.$pntType;
      }

      /**
       * @returns {baja.Component} The ext type
       */
    }, {
      key: "getExtTypeInfo",
      value: function getExtTypeInfo() {
        return this.$extType;
      }

      /**
       * @returns {baja.Component} The convertor instance.
       */
    }, {
      key: "getConverter",
      value: function getConverter() {
        return this.$converter;
      }
    }]);
  }();
});
