function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/* eslint-disable promise/no-promise-in-callback */

/**
 * API Status: **Private**
 * @module bajaux/util/ErrorDetailsWidget
 */
define(['lex!bajaux', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'dialogs', 'jquery', 'Promise'], function (lexs, Widget, Command, CommandButton, dialogs, $, Promise) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bajauxLex = _lexs[0];
  var errorDetailsHtml = "\n    <div class=\"errorMessage\"/>\n      <pre class=\"errorDetails\" style=\"display: none;\"/>\n      <div class=\"detailsButton\" style=\"display: none;\">\n      <button class=\"ux-btn\"/>\n    </div>";
  function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ErrorDetailsWidget ux-fg',
        messageSummary: ''
      }
    };
  }
  function getErrorStack(err) {
    if (err.javaStackTrace) {
      // baja.comm.BoxError
      return err.javaStackTrace;
    } else if (err && err.stack) {
      return String(err.stack);
    }
  }

  /**
   * Determines if the passed Error is a LocalizableError or not
   * @param {Error} err the error to check
   * @returns {boolean} true if the error is a LocalizableError, false if it is not
   */
  function isLocalizedErr(err) {
    // note: this is safe vis a vis minification - this is not constructor.name
    return err instanceof Error && err.name === 'LocalizableError';
  }

  /**
   * Determines the title to be used in the error dialog box
   * @param {Error} err the error that will be displayed
   * @returns {Promise.<String>}
   */
  function resolveErrorTitle(err) {
    var javaClass = err && err.javaClass;
    if (isLocalizedErr(err) && typeof err.toTitle === 'function') {
      return err.toTitle().then(function (title) {
        return title ? title + (javaClass ? ": " + javaClass : '') : bajauxLex.get('errorDetails.title');
      });
    }
    return Promise.resolve(javaClass || bajauxLex.get('errorDetails.title'));
  }

  /**
   * Looks at the error and current messageSummary value and resolves the correct value
   * @param {Error} err the error being display
   * @param {String} messageSummary the current message summary
   * @returns {Promise.<String>}
   */
  function resolveMessageSummary(err, messageSummary) {
    if (isLocalizedErr(err) && typeof err.toSummaryMessage === 'function') {
      return err.toSummaryMessage();
    }
    return Promise.resolve(messageSummary);
  }

  /**
   * Resolves the correct error message to be used, by looking at the error
   * @param {Error} err the error being displayed
   * @returns {Promise.<String>}
   */
  function resolveErrorStr(err) {
    if (isLocalizedErr(err) && typeof err.toMessage === 'function') {
      return err.toMessage();
    }
    return Promise.resolve(err instanceof Error ? err.message : String(err));
  }

  /**
   * Widget for showing error details.
   * ErrorDetailsWidget supports an addition web property called `messageSummary` of type `String`
   * which can be set to prepend an additional message to the Error's message.
   *
   * @private
   * @class
   * @alias module:bajaux/util/ErrorDetailsWidget
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_Widget) {
    function ErrorDetailsWidget(params) {
      _classCallCheck(this, ErrorDetailsWidget);
      return _callSuper(this, ErrorDetailsWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(ErrorDetailsWidget, _Widget);
    return _createClass(ErrorDetailsWidget, [{
      key: "$getDetailsElement",
      value: function $getDetailsElement() {
        return this.jq().children('.errorDetails');
      }
    }, {
      key: "$getMessageElement",
      value: function $getMessageElement() {
        return this.jq().children('.errorMessage');
      }
    }, {
      key: "$getDetailsButtonElement",
      value: function $getDetailsButtonElement() {
        return this.jq().children('.detailsButton');
      }
    }, {
      key: "$getDetailsButton",
      value: function $getDetailsButton() {
        return Widget["in"](this.$getDetailsButtonElement().children('button'));
      }

      /**
       * Build HTML and add `ErrorDetailsWidget` class.
       * @param {JQuery} dom
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(errorDetailsHtml);
      }

      /**
       * Load details about the error. If the error has additional detail to show,
       * create a "details" button that will show the detail when clicked.
       *
       * @param {Error} err
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(err) {
        var _this = this;
        return resolveErrorStr(err).then(function (errString) {
          var stack = getErrorStack(err);
          var messageSummary = _this.properties().getValue('messageSummary');
          var msg;
          if (messageSummary && errString) {
            msg = messageSummary + '\n' + errString;
          } else {
            msg = messageSummary || errString;
          }
          _this.$getMessageElement().text(msg);
          if (stack) {
            var buttonDom = _this.$getDetailsButtonElement();
            _this.$getDetailsElement().text(stack);
            var commandButton = new CommandButton();
            return commandButton.initialize(buttonDom.children('button')).then(function () {
              return commandButton.load(new Command({
                displayName: '%lexicon(bajaux:errorDetails.showDetails)%',
                func: function func() {
                  _this.$getDetailsElement().show();
                  buttonDom.hide();
                }
              }));
            }).then(function () {
              return buttonDom.show();
            });
          }
        });
      }

      /**
       * Remove `ErrorDetailsWidget` class and destroy the details button.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var btn = this.$getDetailsButton();
        return btn && btn.destroy();
      }
    }], [{
      key: "dialog",
      value: function dialog(err) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var title;
        return resolveErrorTitle(err).then(function (errorTitle) {
          title = params.title || errorTitle;
          return ErrorDetailsWidget.$resolveMessageSummary(params, err);
        }).then(function (messageSummary) {
          var detailsWidget = new ErrorDetailsWidget({
            properties: {
              messageSummary: messageSummary
            }
          });
          return dialogs.showOk({
            title: title,
            content: function content(dlg, dom) {
              return detailsWidget.initialize($('<div></div>').appendTo(dom)).then(function () {
                return detailsWidget.load(err);
              });
            }
          }).ok(function () {
            return detailsWidget.destroy();
          }).promise();
        }).then(function () {
          return undefined;
        });
      }

      /**
       * Private function that resolves the message summary and then modifies it as needed
       * @param {Object} params parameters needed to determine the message summary
       * @param {String} [params.messageSummary] the message summary to be used
       * @param {Command} [params.command] the command that generated the error
       * @param {Error} err the current error being displayed
       * @returns {Promise.<String>}
       */
    }, {
      key: "$resolveMessageSummary",
      value: function $resolveMessageSummary(params, err) {
        var messageSummary = params.messageSummary,
          command = params.command;
        return resolveMessageSummary(err, messageSummary).then(function (summary) {
          if (command instanceof Command) {
            return command.toDisplayName().then(function (displayName) {
              var firstLine = bajauxLex.get('errorDetails.commandError', displayName);
              if (summary) {
                return firstLine + '\n' + summary;
              } else {
                return firstLine;
              }
            });
          } else {
            return summary;
          }
        });
      }
    }]);
  }(Widget);
});
