function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * @module bajaux/util/CommandButton
 */
define(['jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommand', 'bajaux/icon/iconUtils', 'nmodule/js/rc/log/Log'], function ($, Promise, _, events, Widget, Command, ToggleCommand, iconUtils, Log) {
  'use strict';

  var contains = _.contains,
    debounce = _.debounce,
    isFunction = _.isFunction;
  var COMMAND_CHANGE_EVENT = events.command.CHANGE_EVENT;
  var DISABLE_EVENT = events.DISABLE_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT;
  var toHtml = iconUtils.toHtml;
  var logError = Log.logMessage.bind(Log, 'nmodule.bajaux.rc.util.CommandButton', Log.Level.SEVERE);
  var cmdButtonsWaiting = [];
  var updateAll = debounce(function () {
    cmdButtonsWaiting.forEach(function (button) {
      button.$updateDom()["catch"](logError);
    });
    cmdButtonsWaiting = [];
  }, 250);

  /**
   * When enabling/disabling multiple buttons at once, don't throttle each call
   * separately as they'll resolve at different times and give you multiple
   * repaints. Throttle all commands at once to minimize repaints.
   * @param {module:bajaux/util/CommandButton} cmdButton
   */
  function updateCommandButtonDom(cmdButton) {
    if (!contains(cmdButtonsWaiting, cmdButton)) {
      cmdButtonsWaiting.push(cmdButton);
      updateAll();
    }
  }

  /**
   * A widget for displaying and invoking a Command.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:bajaux/util/CommandButton
   */
  var CommandButton = function CommandButton() {
    Widget.apply(this, arguments);
  };
  CommandButton.prototype = Object.create(Widget.prototype);
  CommandButton.prototype.constructor = CommandButton;

  /**
   * Get the element that will hold the icon `img`s.
   *
   * @private
   * @returns {JQuery}
   */
  CommandButton.prototype.$getIconElement = function () {
    return this.jq().children('.display').children('.icon');
  };

  /**
   * Get the element that will hold the command's display name.
   *
   * @private
   * @returns {JQuery}
   */
  CommandButton.prototype.$getDisplayNameElement = function () {
    return this.jq().children('.display').children('.displayName');
  };

  /**
   * Arms a click handler that will invoke the loaded Command. Adds a
   * `CommandButton` CSS class.
   *
   * Technically, this widget can be initialized in any DOM element, but makes
   * the most sense in a `button` element.
   *
   * @param {JQuery} dom
   */
  CommandButton.prototype.doInitialize = function (dom) {
    var _this = this;
    dom.on('click', function (e) {
      var cmd = _this.value();
      Promise.resolve(_this.doInvoke(cmd, e))["catch"](function (err) {
        logError(err);
        return cmd.defaultNotifyUser(err);
      });
    });
    var el = dom[0];
    if (!el) {
      return;
    }
    el.classList.add('CommandButton');
    var displaySpan = document.createElement('span');
    displaySpan.className = 'display';
    var iconSpan = document.createElement('span');
    iconSpan.className = 'icon';
    var displayNameSpan = document.createElement('span');
    displayNameSpan.className = 'displayName';
    displaySpan.appendChild(iconSpan);
    displaySpan.appendChild(displayNameSpan);
    el.append(displaySpan);
  };

  /**
   * Override point to allow customized command invocation from a DOM event. By
   * default, will check that the widget and command are both enabled and then
   * invoke it.
   *
   * @param {module:bajaux/commands/Command} cmd
   * @param {JQuery.TriggeredEvent} e
   * @returns {Promise|undefined}
   * @since Niagara 4.11
   */
  CommandButton.prototype.doInvoke = function (cmd, e) {
    if (!cmd.isEnabled() || !this.isEnabled()) {
      return;
    }
    if (isFunction(cmd.invokeFromEvent)) {
      return cmd.invokeFromEvent(e);
    }
    return cmd.invoke();
  };

  /**
   * Updates the display name, description, icon, and enabled status of the
   * button widget. Should be called once on load and whenever the loaded
   * Command changes.
   *
   * @private
   * @returns {Promise} promise to be resolved when the DOM has finished
   * updating
   */
  CommandButton.prototype.$updateDom = function () {
    var that = this,
      jq = that.jq(),
      cmd = that.value();
    if (!jq || !jq.length) {
      return Promise.resolve();
    }
    return Promise.all([cmd.toDisplayName(), cmd.toDescription()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        displayName = _ref2[0],
        description = _ref2[1];
      if (!that.isInitialized()) {
        return;
      }
      var iconElement = that.$getIconElement(),
        displayNameElement = that.$getDisplayNameElement(),
        isToggled = cmd.isToggleCommand() && cmd.isSelected(),
        icon = cmd.getIcon(),
        canInvoke = that.canInvokeCommand();
      jq.attr('title', description);
      displayNameElement.text(displayName);
      jq.toggleClass('ux-toggled', isToggled);
      that.$lookEnabled(canInvoke);
      that.trigger(canInvoke ? ENABLE_EVENT : DISABLE_EVENT);
      return icon && toHtml(icon).then(function (html) {
        return iconElement.html(html);
      });
    });
  };

  /**
   * Loads a Command. Binds an event handler to update the DOM whenever the
   * Command's properties are changed.
   *
   * @param {module:bajaux/commands/Command} cmd
   * @returns {Promise} promise to be resolved when the `Command` is
   * loaded, or rejected if no `Command` given
   */
  CommandButton.prototype.doLoad = function (cmd) {
    if (!(cmd instanceof Command)) {
      throw new Error('Command required');
    }
    var that = this,
      changeHandler = that.$changeHandler;
    cmd.loading().then(function () {
      if (changeHandler) {
        cmd.off(COMMAND_CHANGE_EVENT, changeHandler);
      }
      cmd.on(COMMAND_CHANGE_EVENT, that.$changeHandler = function () {
        updateCommandButtonDom(that);
      });
    })["catch"](logError);
    return that.$updateDom();
  };

  /**
   * Removes the click handler and CSS class from `doInitialize`.
   */
  CommandButton.prototype.doDestroy = function () {
    this.jq().removeClass('CommandButton').removeClass('ux-disabled');
    var cmd = this.value();
    if (cmd) {
      cmd.off(COMMAND_CHANGE_EVENT, this.$changeHandler);
    }
  };

  /**
   * Updates the DOM to look enabled/disabled depending on whether this widget
   * is enabled and the loaded command can be invoked.
   */
  CommandButton.prototype.doEnabled = function () {
    this.$lookEnabled(this.canInvokeCommand());
  };

  /**
   * @returns {boolean} true if both the CommandButton and the loaded Command
   * are enabled
   * @since Niagara 4.13
   */
  CommandButton.prototype.canInvokeCommand = function () {
    var cmd = this.value();
    return !!cmd && this.isEnabled() && cmd.isEnabled();
  };

  /**
   * Updates the DOM to reflect whether the loaded Command can be invoked
   * @private
   * @param {boolean} enabled
   */
  CommandButton.prototype.$lookEnabled = function (enabled) {
    this.jq().prop('disabled', !enabled).toggleClass('bajaux-disabled ux-disabled', !enabled);
  };
  return CommandButton;
});
