function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Size
 */
define(['baja!'], function (baja) {
  'use strict';

  /**
   * BajaScript representation of a `BSize`
   *
   * @class
   * @alias module:nmodule/gx/rc/baja/Size
   * @extends baja.Simple
   */
  var Size = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Constructs a Size with the given width and height. Will throw an error if width or height is not a numeric type.
     * Not a number, positive infinite, and negative infinite values are accepted.
     *
     * @param {number} width
     * @param {number} height
     */
    function Size(width, height) {
      var _this;
      _classCallCheck(this, Size);
      _this = _callSuper(this, Size);
      if (!isNumber(width)) {
        throw new Error('Width must be a number.');
      }
      if (!isNumber(height)) {
        throw new Error('Height must be a number.');
      }
      _this.$width = width;
      _this.$height = height;
      return _this;
    }

    // noinspection JSMethodCanBeStatic
    /**
     * Constructs a Size with the given width and height; this is an instance method.
     *
     * @param {number} width
     * @param {number} height
     * @returns {module:nmodule/gx/rc/baja/Size}
     */
    _inherits(Size, _baja$Simple);
    return _createClass(Size, [{
      key: "make",
      value: function make(width, height) {
        return Size.make(width, height);
      }

      /**
       * Constructs a Size with the given width and height.
       *
       * @param {number} width
       * @param {number} height
       * @returns {module:nmodule/gx/rc/baja/Size}
       */
    }, {
      key: "getWidth",
      value:
      /**
       * Gets the width of the Size
       *
       * @returns {number}
       */
      function getWidth() {
        return this.$width;
      }

      /**
       * Gets the height of the Size
       *
       * @returns {number}
       */
    }, {
      key: "getHeight",
      value: function getHeight() {
        return this.$height;
      }

      /**
       * Encodes the Size to the "width,height" format. If the Size is the null value, returns "null"
       *
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this === Size.NULL) {
          return 'null';
        }
        var stringWidth = this.$width.encodeToString();
        var stringHeight = this.$height.encodeToString();
        return "".concat(stringWidth, ",").concat(stringHeight);
      }

      // noinspection JSMethodCanBeStatic
      /**
       * Converts a string value into a Size tuple. Throws an error if the string is not in the valid format
       * "width,height".
       *
       * @param {string} string
       * @returns {module:nmodule/gx/rc/baja/Size}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        if (string === 'null') {
          return Size.NULL;
        }
        var _string$split$map = string.split(',').map(baja.Double.DEFAULT.decodeFromString),
          _string$split$map2 = _slicedToArray(_string$split$map, 2),
          width = _string$split$map2[0],
          height = _string$split$map2[1];
        try {
          return new Size(width, height);
        } catch (error) {
          throw new Error("Incorrect format for Size: ".concat(error));
        }
      }
    }], [{
      key: "make",
      value: function make(width, height) {
        return new Size(width, height);
      }
    }]);
  }(baja.Simple);
  /**
   * @type {module:nmodule/gx/rc/baja/Size}
   */
  Size.DEFAULT = new Size(0, 0);

  /**
   * Null value for a Size.
   *
   * @type {module:nmodule/gx/rc/baja/Size}
   */
  Size.NULL = new Size(0, 0);
  function isNumber(number) {
    return typeof number === 'number';
  }
  return Size;
});
