function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Brush
 */
define(['baja!', 'bajaux/icon/iconUtils', 'log!nmodule.gx.rc.baja.Brush', 'Promise', 'nmodule/gx/rc/baja/Color', 'nmodule/gx/rc/util/gradientUtils', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, iconUtils, log, Promise, Color, gradientUtils, htmlUtils) {
  'use strict';

  var createLinearGradientCss = gradientUtils.createLinearGradientCss,
    createRadialGradientCss = gradientUtils.createRadialGradientCss;
  var logWarning = log.warning.bind(log);
  var escapeHtml = htmlUtils.escapeHtml;
  /**
   * Fetches the image in order to get the image's dimensions.
   * @param {string} imgSrc the image to get the dimensions for.
   * @inner
   * @returns {Promise.<Array>} Resolves with values of [width, height] in
   * pixels. Rejects if image fetch fails.
   */
  function calculateImageDimensions(imgSrc) {
    return new Promise(function (resolve, reject) {
      //eslint-disable-line promise/avoid-new
      var img = new Image();
      img.onload = function () {
        resolve([this.width, this.height]);
        img.onload = null;
        img = null;
      };
      img.onerror = reject;
      img.onabort = reject;
      img.src = imgSrc;
    });
  }

  /**
   * @alias module:nmodule/gx/rc/baja/Brush
   * @extends baja.Simple
   */
  var Brush = /*#__PURE__*/function (_baja$Simple) {
    function Brush() {
      _classCallCheck(this, Brush);
      return _callSuper(this, Brush, arguments);
    }
    _inherits(Brush, _baja$Simple);
    return _createClass(Brush, [{
      key: "make",
      value:
      /**
       * @param str
       * @returns {module:nmodule/gx/rc/baja/Brush}
       */
      function make(str) {
        return Brush.make(str);
      }

      /**
       * @param {baja.Image} image
       * @returns {module:nmodule/gx/rc/baja/Brush}
       * @since Niagara 4.13
       */
    }, {
      key: "decodeFromString",
      value:
      /**
       * @param str
       * @returns {module:nmodule/gx/rc/baja/Brush}
       */
      function decodeFromString(str) {
        return Brush.make(str);
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return this.isNull() ? 'null' : this.$paint.encodeToString();
      }

      /**
       * @returns {string}
       */
    }, {
      key: "toString",
      value: function toString() {
        return this.isNull() ? 'none' : this.$paint.toString();
      }

      /**
       * @return {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        var paint = this.$paint;
        return paint ? paint.encodeToString() === 'null' : true;
      }

      /**
       * @return {boolean}
       */
    }, {
      key: "isGradientBrush",
      value: function isGradientBrush() {
        var paint = this.$paint;
        return !!(paint && typeof paint.isGradient === 'function' && paint.isGradient());
      }

      /**
       * Applies foreground color or gradient to element
       *
       * Note: You may need to call this from the doLayout method of
       * your widget to apply gradients correctly.
       *
       * @param {Element} el
       */
    }, {
      key: "applyForegroundToElement",
      value: function applyForegroundToElement(el) {
        var style = el.style;
        /**
         * Reset foreground style
         */
        function resetForegroundCss() {
          style['background-clip'] = '';
          style['-webkit-background-clip'] = '';
          style['-webkit-text-fill-color'] = '';
        }
        resetForegroundCss();
        if (this.isNull()) {
          style.color = '';
        } else {
          this.$paint.applyForegroundToElement(el);
        }
      }

      /**
       * Applies background color or gradient to element
       *
       * Note: You may need to call this from the doLayout method of
       * your widget to apply gradients correctly.
       *
       * @param {Element} el
       */
    }, {
      key: "applyBackgroundToElement",
      value: function applyBackgroundToElement(el) {
        var style = el.style;
        if (this.isNull()) {
          style.background = '';
        } else {
          this.$paint.applyBackgroundToElement(el);
        }
      }

      /**
       * Applies this brush to the svg element stroke
       * 
       * @param {Element} shapeEl
       * @param {Element} svgEl
       * @param {Object} params
       * @returns {Promise}
       */
    }, {
      key: "applyStrokeToSvgElement",
      value: function applyStrokeToSvgElement(shapeEl, svgEl, params) {
        if (this.isNull()) {
          shapeEl.setAttribute('stroke', '');
          return Promise.resolve();
        } else {
          return Promise.resolve(this.$paint.applyStrokeToSvgElement(shapeEl, svgEl, params));
        }
      }

      /**
       * Applies this brush to fill the svg element
       * 
       * @param {Element} shapeEl
       * @param {Element} svgEl
       * @param {Object} params
       * @returns {Promise}
       */
    }, {
      key: "applyFillToSvgElement",
      value: function applyFillToSvgElement(shapeEl, svgElm, params) {
        if (this.isNull()) {
          shapeEl.setAttribute('fill', '');
          return Promise.resolve();
        } else {
          return Promise.resolve(this.$paint.applyFillToSvgElement(shapeEl, svgElm, params));
        }
      }
    }], [{
      key: "make",
      value:
      /**
       * @param {string} str
       * @returns {module:nmodule/gx/rc/baja/Brush}
       */
      function make(str) {
        if (str === 'null') {
          return Brush.NULL;
        }
        var brush = new Brush();
        brush.$paint = parseBrush(str);
        return brush;
      }
    }, {
      key: "makeImageBrush",
      value: function makeImageBrush(image) {
        if (!image) {
          return Brush.NULL;
        }
        var imageOrds = image.getOrdList().getOrds();
        var str = imageOrds.length > 0 && !imageOrds[0].isNull() ? 'image( source(' + imageOrds[0].toString() + ') )' : 'null';
        return Brush.make(str);
      }
    }]);
  }(baja.Simple);
  /**
   * Inner implementation of different types of brushes.
   * @memberOf module:nmodule/gx/rc/baja/Brush
   */
  var Paint = /*#__PURE__*/function () {
    function Paint() {
      _classCallCheck(this, Paint);
    }
    return _createClass(Paint, [{
      key: "encodeToString",
      value:
      /**
       * Every Paint subclass must implement its own encodeToString.
       * @abstract
       * @returns {string}
       */
      function encodeToString() {
        throw new Error('not implemented');
      }

      /**
       * Every Paint subclass must implement its own toString.
       * @abstract
       * @returns {string}
       */
    }, {
      key: "toString",
      value: function toString() {
        throw new Error('not implemented');
      }
    }]);
  }();
  /**
   * Brush implementation for a solid color.
   * @memberOf module:nmodule/gx/rc/baja/Brush
   */
  var Solid = /*#__PURE__*/function (_Paint) {
    /**
     * @param {module:nmodule/gx/rc/baja/Color} color
     */
    function Solid(color) {
      var _this;
      _classCallCheck(this, Solid);
      _this = _callSuper(this, Solid);
      _this.$color = color;
      return _this;
    }

    /**
     * @returns {module:nmodule/gx/rc/baja/Color}
     */
    _inherits(Solid, _Paint);
    return _createClass(Solid, [{
      key: "getColor",
      value: function getColor() {
        return this.$color;
      }

      /**
       * @returns {string} the color encoded to string
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return this.$color.encodeToString();
      }

      /**
       * Applies background color to element
       * @param {Element} el
       */
    }, {
      key: "applyBackgroundToElement",
      value: function applyBackgroundToElement(el) {
        var style = el.style;
        style.background = this.toString();
      }

      /**
       * Applies foreground color to element
       * @param {Element} el
       */
    }, {
      key: "applyForegroundToElement",
      value: function applyForegroundToElement(el) {
        var style = el.style;
        style.color = this.toString();
      }

      /**
       * Applies a solid color to the svg element stroke
       * @param {Element} shapeEl
       */
    }, {
      key: "applyStrokeToSvgElement",
      value: function applyStrokeToSvgElement(shapeEl) {
        shapeEl.setAttribute('stroke', this.toString());
      }

      /**
       * Applies a solid color to fill the svg element
       * @param {Element} shapeEl
       */
    }, {
      key: "applyFillToSvgElement",
      value: function applyFillToSvgElement(shapeEl) {
        shapeEl.setAttribute('fill', this.toString());
      }

      /**
       * @returns {string} the color's toCssString
       */
    }, {
      key: "toString",
      value: function toString() {
        return this.$color.toString();
      }
    }]);
  }(Paint);
  /**
   * Brush implementation for a linear gradience of colors.
   * @memberOf module:nmodule/gx/rc/baja/Brush
   */
  var LinearGradient = /*#__PURE__*/function (_Paint2) {
    function LinearGradient(encoding) {
      var _this2;
      _classCallCheck(this, LinearGradient);
      _this2 = _callSuper(this, LinearGradient);
      Object.assign(_this2, parseGradienceParams(encoding));
      _this2.$encoding = encoding;
      return _this2;
    }
    _inherits(LinearGradient, _Paint2);
    return _createClass(LinearGradient, [{
      key: "encodeToString",
      value: function encodeToString() {
        return this.$encoding;
      }
    }, {
      key: "applyBackgroundToElement",
      value: function applyBackgroundToElement(el) {
        var style = el.style;
        style.background = this.toString();
      }
    }, {
      key: "applyForegroundToElement",
      value: function applyForegroundToElement(el) {
        applyTextGradient(el, this.toString(), getFirstColorStop(this.$stops));
      }

      /**
       * Applies a gradient to the svg element stroke
       * @param {Element} shapeEl
       * @param {Element} svgEl
       */
    }, {
      key: "applyStrokeToSvgElement",
      value: function applyStrokeToSvgElement(shapeEl, svgEl, params) {
        var linearDefId = this.$makeLinearDef(svgEl, params);
        shapeEl.setAttribute('stroke', 'url(#' + linearDefId + ')');
      }

      /**
       * Applies a gradient to the svg element fill
       * @param {Element} shapeEl
       * @param {Element} svgEl
       * @param {Object} params
       */
    }, {
      key: "applyFillToSvgElement",
      value: function applyFillToSvgElement(shapeEl, svgEl, params) {
        var linearDefId = this.$makeLinearDef(svgEl, params);
        shapeEl.setAttribute('fill', 'url(#' + linearDefId + ')');
      }
    }, {
      key: "toString",
      value: function toString() {
        return 'linear-gradient' + createLinearGradientCss(this.$angle, this.$stops);
      }

      /**
       * A valid encoding is of the form, e.g. 'linearGradient( stop(0.0% red) stop(100.0% navy) )'
       * @returns {boolean}
       */
    }, {
      key: "isGradient",
      value: function isGradient() {
        return /^linearGradient\(/.test(this.$encoding);
      }

      /**
       * Makes a linear gradient def for the svg
       *
       * @private
       * @param {Element} svgEl
       * @param {Object} [params]
       * @param {String} [params.linearGradientTransform]
       * @returns {String} the def id value
       */
    }, {
      key: "$makeLinearDef",
      value: function $makeLinearDef(svgEl) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var linearDefId = generateId(this, params);
        var gradientTransform = params.linearGradientTransform;
        var makeParams = {
          id: linearDefId
        };
        if (gradientTransform) {
          makeParams.gradientTransform = gradientTransform;
        }
        var lg = makeLinearGradientSvgDef(this.$stops, this.$angle, makeParams);
        lg.classList.add('lg');
        var defs = svgEl && svgEl.querySelector('defs');
        if (defs) {
          var existingDef = defs.querySelector('#' + linearDefId);
          if (existingDef) {
            defs.removeChild(existingDef); // Remove the existing gradient
          }
          defs.appendChild(lg);
        } else if (svgEl) {
          defs = document.createElementNS('http://www.w3.org/2000/svg', 'defs');
          defs.appendChild(lg);
          svgEl.appendChild(defs);
        }
        return linearDefId;
      }
    }]);
  }(Paint);
  /**
   * Brush implementation for a radial gradience of colors.
   * @memberOf module:nmodule/gx/rc/baja/Brush
   */
  var RadialGradient = /*#__PURE__*/function (_Paint3) {
    function RadialGradient(encoding) {
      var _this3;
      _classCallCheck(this, RadialGradient);
      _this3 = _callSuper(this, RadialGradient);
      Object.assign(_this3, parseGradienceParams(encoding));
      _this3.$encoding = encoding;
      return _this3;
    }
    _inherits(RadialGradient, _Paint3);
    return _createClass(RadialGradient, [{
      key: "encodeToString",
      value: function encodeToString() {
        return this.$encoding;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.toCssString('circle', 'center');
      }
    }, {
      key: "$getRadiusInUserUnits",
      value: function $getRadiusInUserUnits() {
        // Calculate radius - The incoming radius is in percentage and 
        // we cannot calculate it without the bounding box dimensions. 
        // applyForegroundToElement and applyBackgroundToElement will update the radius later on.
        return this.$radius ? parseInt(this.$radius.substring(0, this.$radius.length - 1), 10) / 100 : 0.5;
      }

      /**
       * @param {string} radius
       * @param {string} center
       * @returns {string}
       */
    }, {
      key: "toCssString",
      value: function toCssString(radius, center) {
        return 'radial-gradient' + createRadialGradientCss(radius, center, this.$stops);
      }
    }, {
      key: "applyBackgroundToElement",
      value: function applyBackgroundToElement(el) {
        var style = el.style;
        var radius, center;
        if (el.clientWidth && el.clientHeight) {
          radius = Math.max(el.clientWidth, el.clientHeight) * this.$getRadiusInUserUnits() + 'px';
          center = this.$center;
        } else {
          radius = 'circle';
          center = 'center';
        }
        style.background = this.toCssString(radius, center);
      }
    }, {
      key: "applyForegroundToElement",
      value: function applyForegroundToElement(el) {
        var radius, center;
        if (el.clientWidth && el.clientHeight) {
          radius = Math.max(el.clientWidth, el.clientHeight) * this.$getRadiusInUserUnits();
          center = this.center;
        } else {
          radius = 'circle';
          center = 'center';
        }
        applyTextGradient(el, this.toCssString(radius, center), getFirstColorStop(this.$stops));
      }
    }, {
      key: "applyStrokeToSvgElement",
      value: function applyStrokeToSvgElement(shapeEl, svgEl, params) {
        var radialDefId = this.$makeRadialDef(svgEl, params);
        shapeEl.setAttribute('stroke', 'url(#' + radialDefId + ')');
      }
    }, {
      key: "applyFillToSvgElement",
      value: function applyFillToSvgElement(shapeEl, svgEl, params) {
        var radialDefId = this.$makeRadialDef(svgEl, params);
        shapeEl.setAttribute('fill', 'url(#' + radialDefId + ')');
      }

      /**
       * A valid encoding is of the form, e.g. 'radialGradient( stop(0.0% red) stop(100.0% navy) )'
       * @returns {boolean}
       */
    }, {
      key: "isGradient",
      value: function isGradient() {
        return /^radialGradient\(/.test(this.$encoding);
      }

      /**
       * Makes a radial gradient def for the svg
       *
       * @private
       * @param {Element} svgEl
       * @param {Object} [params]
       * @param {String} [params.radialGradientTransform]
       * @param {Number} [params.radialXFactor]
       * @param {Number} [params.radialYFactor]
       * @returns {string} the def id value
       */
    }, {
      key: "$makeRadialDef",
      value: function $makeRadialDef(svgEl) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var radialDefId = generateId(this, params),
          c = this.$center.split(' '),
          f = this.$focus.split(' ');
        var cx = getValue(c[0]);
        var cy = getValue(c[1]);
        var fx = getValue(f[0]);
        var fy = getValue(f[1]);
        var r = getValue(this.$radius);
        var radialXFactor = params.radialXFactor,
          radialYFactor = params.radialYFactor;
        if (isFinite(radialXFactor)) {
          cx = applyFactor(cx, radialXFactor);
          fx = applyFactor(fx, radialXFactor);
        }
        if (isFinite(radialYFactor)) {
          cy = applyFactor(cy, radialYFactor);
          fy = applyFactor(fy, radialYFactor);
        }

        //https://developer.mozilla.org/en-US/docs/Web/SVG/Tutorial/Gradients
        //Note If the focal point is moved outside the circle described, it's impossible for the gradient to be rendered correctly.
        var unsafePercentDifference = r * 0.34; //33.3334% of radius seems to be safe
        if (Math.abs(cx - fx) >= r - unsafePercentDifference) {
          if (cx > fx) {
            fx = cx - r + unsafePercentDifference;
          } else {
            fx = cx + r - unsafePercentDifference;
          }
        }
        if (Math.abs(cy - fy) >= r - unsafePercentDifference) {
          if (cy > fy) {
            fy = cy - r + unsafePercentDifference;
          } else {
            fy = cy + r - unsafePercentDifference;
          }
        }
        var gradientTransform = params.radialGradientTransform;
        var makeParams = {
          id: radialDefId,
          r: r + '%',
          cx: cx + '%',
          cy: cy + '%',
          fx: fx + '%',
          fy: fy + '%'
        };
        if (gradientTransform) {
          makeParams.gradientTransform = gradientTransform;
        }
        var rg = makeRadialGradientSvgDef(this.$stops, makeParams);
        rg.classList.add('rg');
        var defs = svgEl && svgEl.querySelector('defs');
        if (defs) {
          var existingDef = defs.querySelector('#' + radialDefId);
          if (existingDef) {
            defs.removeChild(existingDef); // Remove the existing gradient
          }
          defs.appendChild(rg);
        } else if (svgEl) {
          defs = document.createElementNS('http://www.w3.org/2000/svg', 'defs');
          defs.appendChild(rg);
          svgEl.appendChild(defs);
        }
        return radialDefId;
      }
    }]);
  }(Paint);
  /**
   * Brush implementation for Image based brushes.
   * @memberOf module:nmodule/gx/rc/baja/Brush
   */
  var ImageBrush = /*#__PURE__*/function (_Paint4) {
    function ImageBrush(encoding) {
      var _this4;
      _classCallCheck(this, ImageBrush);
      _this4 = _callSuper(this, ImageBrush);
      _this4.$encoding = encoding;
      Object.assign(_this4, parseImageParams(encoding));
      return _this4;
    }
    _inherits(ImageBrush, _Paint4);
    return _createClass(ImageBrush, [{
      key: "encodeToString",
      value: function encodeToString() {
        return this.$encoding;
      }
    }, {
      key: "applyBackgroundToElement",
      value: function applyBackgroundToElement(el) {
        var style = el.style;
        style.background = this.toString();
      }
    }, {
      key: "applyForegroundToElement",
      value: function applyForegroundToElement(el) {
        var style = el.style;
        style.color = Color.make('black').toCssString();
      }

      /**
       * Applies this brush to the stroke of the svg element
       *
       * @param {Element} shapeEl
       * @param {Element} svgEl
       * @param {Object} params
       * @returns {Promise}
       */
    }, {
      key: "applyStrokeToSvgElement",
      value: function applyStrokeToSvgElement(shapeEl, svgEl) {
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        if (this.$tile === "true") {
          return this.$makeImageDef(svgEl, params).then(function (imageDefId) {
            return shapeEl.setAttribute('stroke', 'url(#' + imageDefId + ')');
          })["catch"](logWarning);
        }
        shapeEl.setAttribute('stroke', 'transparent');
        return Promise.resolve();
      }

      /**
       * Applies this brush to fill the svg element
       *
       * @param {Element} shapeEl
       * @param {Element} svgEl
       * @param {Object} params
       * @returns {Promise}
       */
    }, {
      key: "applyFillToSvgElement",
      value: function applyFillToSvgElement(shapeEl, svgEl) {
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        if (this.$tile === "true") {
          return this.$makeImageDef(svgEl, params).then(function (imageDefId) {
            return shapeEl.setAttribute('fill', 'url(#' + imageDefId + ')');
          })["catch"](logWarning);
        }
        shapeEl.setAttribute('fill', 'transparent');
        return Promise.resolve();
      }

      /**
       * Gets a css string representation of this image brush.
       * @returns {string}
       */
    }, {
      key: "toString",
      value: function toString() {
        var uri = iconUtils.toUris(this.$sourceOrd)[0];
        return "url(\"".concat(escapeHtml(uri), "\") ").concat(this.$hAlign, " ").concat(this.$vAlign, " ").concat(tileParamToCssProperty(this.$tile));
      }

      /**
       * Makes the def for an image pattern
       *
       * @private
       * @param {Element} svgEl
       * @param {Object} [params]
       * @param {String} [params.patternTransform]
       * @returns {String} the def id value
       */
    }, {
      key: "$makeImageDef",
      value: function $makeImageDef(svgEl) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var imageDefId = generateId(this, params);
        var uri = iconUtils.toUris(this.$sourceOrd)[0];
        return calculateImageDimensions(uri).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            width = _ref2[0],
            height = _ref2[1];
          var makeParams = {
            id: imageDefId,
            uri: uri,
            width: width,
            height: height
          };
          if (params.patternTransform) {
            makeParams.patternTransform = params.patternTransform;
          }
          var image = makeImageSvgDef(makeParams);
          var defs = svgEl && svgEl.querySelector('defs');
          if (defs) {
            var existingDef = defs.querySelector('#' + imageDefId);
            if (existingDef) {
              defs.removeChild(existingDef);
            }
            defs.appendChild(image);
          } else if (svgEl) {
            defs = document.createElementNS('http://www.w3.org/2000/svg', 'defs');
            defs.appendChild(image);
            svgEl.appendChild(defs);
          }
          return imageDefId;
        });
      }
    }]);
  }(Paint);
  /**
   * Apply the factor to the distance from 50%.
   * @param {Number} value
   * @param {Number} factor
   * @return {Number}
   */
  function applyFactor(value, factor) {
    value = (value - 50) * factor + 50;
    return value;
  }

  /**
   * @param {String} string
   * @return {number}
   */
  function getValue(string) {
    return parseFloat(string.split('%')[0]);
  }

  // Parse a String and return a paint Object
  function parseBrush(encoding) {
    if (encoding.match(/^linearGradient\(/)) {
      return new LinearGradient(encoding);
    } else if (encoding.match(/^radialGradient\(/)) {
      return new RadialGradient(encoding);
    } else if (encoding.match(/^image\(/)) {
      return new ImageBrush(encoding);
    }
    return new Solid(Color.DEFAULT.decodeFromString(encoding));
  }

  /*
  * Get the `Math.abs` and if the number is pretty close to zero, just make it zero since
  * Math.PI can cause this often.
  * @param {Number} value
  * @returns {Number}
  */
  function absAndCleanupFractions(value) {
    value = Math.abs(value);
    if (value < 0.0001) {
      return 0;
    }
    return value;
  }
  function tileParamToCssProperty(tile) {
    switch (tile) {
      case 'true':
        return 'repeat';
      case 'x':
        return 'repeat-x';
      case 'y':
        return 'repeat-y';
      default:
        return 'no-repeat';
    }
  }
  function parseImageParams(encoding) {
    var imageMatcher = /([a-zA-Z]*)\((.*?)\)(\s|$)+/g;
    var str = encoding,
      sourceOrd = '',
      tile = "false",
      hAlign = 'center',
      vAlign = 'center',
      res;

    // Remove image(...)
    str = str.substring(6, str.length - 1).trim();
    res = imageMatcher.exec(str);
    while (res) {
      var functionName = res[1];
      if (functionName === 'source') {
        var source = res[2].trim();
        if (source.indexOf("module://") !== -1) {
          var splitSource = source.split("|");
          source = splitSource[splitSource.length - 1];
        }
        sourceOrd = baja.Ord.make(source);
      } else if (functionName === 'halign') {
        hAlign = res[2].trim();
      } else if (functionName === 'valign') {
        vAlign = res[2].trim();
      } else if (functionName === 'tile') {
        tile = res[2].trim();
      }
      res = imageMatcher.exec(str);
    }

    // Make tile alignment closer to that of workbench.
    if (tile === 'true') {
      hAlign = 'left';
      vAlign = 'top';
    } else if (tile === 'x') {
      hAlign = 'left';
      vAlign = 'center';
    } else if (tile === 'y') {
      hAlign = 'center';
      vAlign = 'top';
    }
    return {
      $sourceOrd: sourceOrd,
      $hAlign: hAlign,
      $vAlign: vAlign,
      $tile: tile
    };
  }

  /**
   * @param {String} encoding a String encoding of a BBrush.LinearGradient or Brush.RadialGradient
   * @returns {Object} an object with <code>angle<code> and <code>stops</code>
   * properties. The stops are a two-dimensional array in the form
   * <code>[["0%", "color1"], ["100%", "color2"]]<code>
   */
  function parseGradienceParams(encoding) {
    var gradientMatcher = /([a-zA-Z]*)\(([^()]*)\)/g;
    var str = encoding,
      focalSet = false,
      stops = [],
      angle = 0,
      center = '50% 50%' /* Defaults to center of bounding element */,
      focalPt = center /* Point from which the brush radiates - defaults to center*/,
      res,
      radius = '50%';

    // Remove linearGradient|radialGradient(...)        
    str = str.substring(15, str.length - 1);
    res = gradientMatcher.exec(str);
    while (res) {
      // We need to decode the stops in order
      if (res[1] === "stop") {
        // Parse out offset color
        var stop = parseStop(res);
        stops.push([stop.offset, stop.color]);
      } else if (res[1] === "angle") {
        angle = parseInt(res[2], 10);
      } else if (res[1] === "c") {
        center = res[2];
        if (!focalSet) {
          focalPt = res[2];
        }
      } else if (res[1] === "r") {
        radius = res[2];
      } else if (res[1] === "f") {
        focalPt = res[2];
        focalSet = true;
      }
      res = gradientMatcher.exec(str);
    }

    // Build base CSS
    return {
      $angle: angle,
      $stops: stops,
      $center: center,
      $radius: radius,
      $focus: focalPt
    };
  }
  function parseStop(res) {
    // Parse out 'offset color'
    var stopSplitStr = res[2].split(" "),
      color = Color.DEFAULT.decodeFromString(stopSplitStr[1]),
      offset = stopSplitStr[0];
    return {
      color: color,
      offset: offset,
      toString: function toString() {
        return color.toCssString() + " " + offset;
      }
    };
  }

  /**
   *
   * @param {Element} el
   * @param {String} backgroundCss
   * @param {String} fallbackColor
   */
  function applyTextGradient(el, backgroundCss, fallbackColor) {
    var style = el.style;
    style.background = backgroundCss;
    style.color = 'transparent';
    style['background-clip'] = 'text';
    style['-webkit-background-clip'] = 'text';
    style['-webkit-text-fill-color'] = 'transparent';
    // If the clipping is supported then 'text' will be added to the gradient function
    // If clipping is not supported then try to fallback to the first color stop
    if (style.background.indexOf('text') === -1 && fallbackColor) {
      style.color = fallbackColor;
    }
  }

  /**
   *
   * @param {Array} stops
   * e.g: [ ['45%', Color.make('red')] ]
   */
  function getFirstColorStop(stops) {
    return stops && stops.length > 0 && stops[0].length === 2 ? stops[0][1].toCssString() : null;
  }

  /**
   * Generate a unique DOM ID. The ID will include the name of this editor's
   * constructor just for tracing/debugging purposes.
   *
   * @private
   * @inner
   * @param {Object} paintBrush
   * @param {Object} [params]
   * @param {String} [params.radialGradientTransform]
   * @param {String} [params.linearGradientTransform]
   * @param {Number} [params.radialXFactor]
   * @param {Number} [params.radialYFactor]
   * @param {String} [params.patternTransform]
   * @returns {string}
   */
  function generateId(paintBrush) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var prefix = paintBrush.constructor.name || 'Paint';
    var encoding = paintBrush.encodeToString();
    var radialGradientTransform = params.radialGradientTransform,
      linearGradientTransform = params.linearGradientTransform,
      radialXFactor = params.radialXFactor,
      radialYFactor = params.radialYFactor,
      patternTransform = params.patternTransform;
    if (radialGradientTransform) {
      encoding += radialGradientTransform;
    }
    if (linearGradientTransform) {
      encoding += linearGradientTransform;
    }
    if (radialXFactor || radialXFactor === 0) {
      encoding += radialXFactor;
    }
    if (radialYFactor || radialYFactor === 0) {
      encoding += radialYFactor;
    }
    if (patternTransform) {
      encoding += patternTransform;
    }
    var hash = 0,
      i,
      chr;
    for (i = 0; i < encoding.length; i++) {
      chr = encoding.charCodeAt(i);
      hash = (hash << 5) - hash + chr;
      hash |= 0; // Convert to 32bit integer
    }
    return prefix + '__id__' + hash;
  }

  /**
   *
   * @param {Object} params
   * @param {number} params.width the width of the pattern
   * @param {number} params.height the height of the pattern
   * @param {string} params.uri the image's uri to load
   * @param {string} [params.patternTransform] patternTransform for the image
   * @returns {SVGPatternElement}
   */
  function makeImageSvgDef(params) {
    var pattern = document.createElementNS('http://www.w3.org/2000/svg', 'pattern');
    var image = document.createElementNS('http://www.w3.org/2000/svg', 'image');
    pattern.setAttribute('id', params.id);
    pattern.setAttribute('patternUnits', 'userSpaceOnUse');
    pattern.setAttribute('x', '0');
    pattern.setAttribute('y', '0');
    pattern.setAttribute('width', params.width);
    pattern.setAttribute('height', params.height);
    if (params.patternTransform) {
      pattern.setAttribute('patternTransform', params.patternTransform);
    }
    image.setAttribute('width', params.width);
    image.setAttribute('height', params.height);
    image.setAttribute('href', params.uri);
    pattern.appendChild(image);
    return pattern;
  }

  /**
   *
   * @param {Array} stops
   * @param {Number} angleDegrees
   * @param {Object} params Parameters to be sent to `applyParamsToGradientDefs`
   * @param {Object} params.id Identifier of the gradient def
   * @param {String} [params.gradientTransform] gradientTransform for the LinearGradient
   */
  function makeLinearGradientSvgDef(stops, angleDegrees, params) {
    var angle = (angleDegrees - 90) / 180 * Math.PI; // radians
    angle %= 2 * Math.PI;
    var xPercent = Math.sin(angle) * 100,
      yPercent = Math.cos(angle) * 100;
    params.x1 = (xPercent > 0 ? absAndCleanupFractions(xPercent) : 0) + '%';
    params.x2 = (xPercent < 0 ? absAndCleanupFractions(xPercent) : 0) + '%';
    params.y1 = (yPercent > 0 ? absAndCleanupFractions(yPercent) : 0) + '%';
    params.y2 = (yPercent < 0 ? absAndCleanupFractions(yPercent) : 0) + '%';
    var lgSvg = document.createElementNS('http://www.w3.org/2000/svg', 'linearGradient');
    applyParamsToGradientDefs(params, lgSvg);
    applyStopsToGradientDef(stops, lgSvg);
    return lgSvg;
  }

  /**
   *
   * @param {Array} stops
   * @param {Object} params
   * @param {Object} params.id Identifier of the gradient def
   * @param {Object} params.cx x center for RadialGradient
   * @param {Object} params.cy y center for RadialGradient
   * @param {Object} params.fx x focal for RadialGradient
   * @param {Object} params.fy y focal for RadialGradient
   * @param {Object} params.r radius for RadialGradient
   * @param {String} [params.gradientTransform] gradientTransform for the RadialGradient
   */
  function makeRadialGradientSvgDef(stops, params) {
    var rgSvg = document.createElementNS('http://www.w3.org/2000/svg', 'radialGradient');
    applyParamsToGradientDefs(params, rgSvg);
    applyStopsToGradientDef(stops, rgSvg);
    return rgSvg;
  }

  /**
   *
   * @param {Array} stops
   * @param {Element} gSvg
   */
  function applyStopsToGradientDef(stops, gSvg) {
    stops.forEach(function (s) {
      var stopSvg = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
      stopSvg.setAttribute('offset', s[0]);
      stopSvg.setAttribute('stop-color', s[1]);
      gSvg.appendChild(stopSvg);
    });
  }

  /**
   *
   * @param {Object} params
   * @param {Element} gSvg
   */
  function applyParamsToGradientDefs(params, gSvg) {
    if (params) {
      // eslint-disable-next-line guard-for-in
      for (var prop in params) {
        gSvg.setAttribute(prop, params[prop]);
      }
    }
  }
  Brush.NULL = new Brush('null');
  Brush.DEFAULT = new Brush('black');
  Brush.Paint = Paint;
  Brush.Solid = Solid;
  Brush.LinearGradient = LinearGradient;
  Brush.RadialGradient = RadialGradient;
  Brush.Image = ImageBrush;
  return Brush;
});
