function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/DeleteStationCommand
 */
define(['log!nmodule.saml.rc.util.DeleteStationCommand', 'lex!saml', 'Promise', 'baja!', 'bajaux/commands/Command', 'dialogs', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'baja!baja:X509Certificate', 'baja!saml:StationServiceProvider', 'css!nmodule/js/rc/dialogs/dialogs'], function (log, lexs, Promise, baja, Command, dialogs, MgrCommand) {
  'use strict';

  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;
  var samlLex = lexs[0];

  /**
   * Command associated with manager `Delete Station` command button, to delete an existing
   * station (StationServiceProvider) in circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/util/DeleteStationCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     */
    function DeleteStationCommand(manager) {
      var _this;
      _classCallCheck(this, DeleteStationCommand);
      return _this = _callSuper(this, DeleteStationCommand, [{
        module: 'saml',
        lex: 'CircleOfTrust.command.delete.station',
        enabled: false,
        flags: ALL_BARS | MAIN_CONTEXT_MENU,
        func: function func() {
          return _this.$deleteStation(manager);
        }
      }]);
    }

    /**
     * Handles deleting a station in Circle of Trust.
     *
     * @private
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     * @returns {Promise}
     */
    _inherits(DeleteStationCommand, _Command);
    return _createClass(DeleteStationCommand, [{
      key: "$deleteStation",
      value: function $deleteStation(manager) {
        var _this2 = this;
        var selectedRow = manager.getMainTable().getSelectedRows()[0],
          station = selectedRow.getSubject(),
          stationName = station.get('name');
        dialogs.showOkCancel({
          title: samlLex.get('CircleOfTrust.commands.dialog.delete.title', stationName),
          text: samlLex.get('CircleOfTrust.commands.dialog.delete.content', stationName)
        }).ok(function () {
          return _this2.$continueDeleteStation(manager, stationName, selectedRow);
        }).cancel(function () {
          return Promise.resolve(null);
        });
      }

      /**
       * Handles deleting a station in Circle of Trust.
       *
       * @private
       * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
       * @param {string} stationName
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} selectedRow
       * @returns {Promise}
       */
    }, {
      key: "$continueDeleteStation",
      value: function $continueDeleteStation(manager, stationName, selectedRow) {
        var circleOfTrust = manager.value();
        var stationProviders = circleOfTrust.getServiceProviders();
        return stationProviders.remove(stationName).then(function () {
          return manager.getModel().removeRows([selectedRow]);
        }).then(function () {
          return manager.reSort();
        });
      }
    }]);
  }(Command);
});
