/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/AddPrototypeCommand
 */
define(['baja!', 'jquery', 'Promise', 'lex!saml', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, $, Promise, lexs, Command, feDialogs) {
  'use strict';

  var samlLex = lexs[0];

  /**
   * Open a dialog editor to get the name of the prototype to add.
   * It makes sure that the names are unique and adds the name to the Circle of the
   * Trust's prototypes. It also adds the new row to the model.
   * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
   * @returns {Promise}
   */
  function addNewPrototypeItem(manager) {
    return feDialogs.showFor({
      value: '',
      formFactor: 'mini',
      title: samlLex.get('CircleOfTrust.commands.addPrototypeDialog')
    }).then(function (newPrototypeValue) {
      if (newPrototypeValue === null) {
        return;
      }
      if (newPrototypeValue.trim() === '') {
        throw new Error(samlLex.get('CircleOfTrust.commands.prototypeDialog.enterValidName'));
      }
      var escapedPrototypeValue = baja.SlotPath.escape(newPrototypeValue);
      var currentPrototypesFolder = manager.value().getPrototypes();
      if (checkForDuplicatePrototypeEntry(currentPrototypesFolder, escapedPrototypeValue)) {
        var prototypeItem = baja.$('baja:Component', {
            name: escapedPrototypeValue,
            displayName: newPrototypeValue,
            selected: true,
            category: 'prototypes'
          }),
          row = manager.getModel().makeRow(prototypeItem);
        return Promise.all([currentPrototypesFolder.add({
          slot: escapedPrototypeValue,
          value: newPrototypeValue
        }), manager.getModel().insertRows([row]) //todo do not insert this if failed
        ]);
      } else {
        throw new Error(samlLex.get('CircleOfTrust.commands.prototypeDialog.nameAlreadyExist'));
      }
    })["catch"](feDialogs.error);
  }
  function checkForDuplicatePrototypeEntry(currentPrototypesFolder, escapedPrototypeValue) {
    var prototypesUnderTheFolder = currentPrototypesFolder.getSlots().toValueArray();
    for (var i = 0; i < prototypesUnderTheFolder.length; i++) {
      if (prototypesUnderTheFolder[i] === escapedPrototypeValue) {
        return false;
      }
    }
    return true;
  }

  /**
   * Command to append a new prototype value to the Circle of Trust's Prototype
   * @class
   * @alias module:nmodule/saml/rc/util/AddPrototypeCommand
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
   */
  var AddPrototypeCommand = function AddPrototypeCommand(manager) {
    Command.call(this, {
      module: 'saml',
      lex: 'CircleOfTrust.commands.addPrototype',
      enabled: false,
      func: function func() {
        return addNewPrototypeItem(manager);
      }
    });
  };
  AddPrototypeCommand.prototype = Object.create(Command.prototype);
  AddPrototypeCommand.prototype.constructor = AddPrototypeCommand;

  /**
   * Set the command button enabled/disabled based on the tab changed.
   */
  AddPrototypeCommand.prototype.tabChanged = function (enabled) {
    this.setEnabled(enabled);
  };
  return AddPrototypeCommand;
});
