/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Robert Staley
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/samlCoTPrototypesMgrAgent
 */
define(['baja!', 'baja!baja:User,saml:SAMLCoTPrototypesMixIn', 'lex!saml', 'nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, MixinMgrColumn, Column) {
  'use strict';

  var samlLex = lexs[0],
    USER_TYPE = baja.lt('baja:User'),
    SAML_PROTOTYPES_TYPE = baja.lt('saml:SAMLCoTPrototypesMixIn'),
    COLUMN_NAME = samlLex.get('samlPrototypes'),
    OBJECT_ICON = '/module/icons/x16/object.png';
  var SamlCoTPrototypesMgrColumn = function SamlCoTPrototypesMgrColumn() {
    MixinMgrColumn.call(this, SAML_PROTOTYPES_TYPE, {
      type: USER_TYPE,
      displayName: COLUMN_NAME,
      flags: Column.flags.EDITABLE
    });
  };
  SamlCoTPrototypesMgrColumn.prototype = Object.create(MixinMgrColumn.prototype);
  SamlCoTPrototypesMgrColumn.prototype.constructor = SamlCoTPrototypesMgrColumn;

  /**
   * Return the icon to be used for the column in the batch component editor.
   * @returns {String}
   */
  SamlCoTPrototypesMgrColumn.prototype.getColumnIcon = function () {
    return OBJECT_ICON;
  };
  var exports = {};
  exports.getColumns = function () {
    return [new SamlCoTPrototypesMgrColumn()];
  };
  return exports;
});
