function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/CircleOfTrustEditor
 */
define(['baja!', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/util/SaveCommand', 'nmodule/webEditors/rc/fe/BaseWidget', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'bajaux/mixin/responsiveMixIn', 'jquery', 'Promise', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/saml/rc/fe/CircleOfTrustPropertySheet', 'nmodule/saml/rc/fe/CircleOfTrustTabsWidget', 'nmodule/saml/rc/util/circleOfTrustUtils', 'css!nmodule/saml/rc/saml'], function (baja, Properties, Widget, SaveCommand, BaseWidget, events, subscriberMixin, responsiveMixIn, $, Promise, CircleOfTrustManager, PropertySheet, CircleOfTrustPropertySheet, CircleOfTrustTabsWidget, circleOfTrustUtils) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var tpl = function tpl() {
    return "\n    <div class=\"CircleOfTrustPropertySheet\"></div>\n    <div class=\"CircleOfTrustTabs\"></div>\n  ";
  };

  /**
   * Shows information about circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/fe/CircleOfTrustEditor
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function CircleOfTrustEditor() {
      var _this;
      _classCallCheck(this, CircleOfTrustEditor);
      _this = _callSuper(this, CircleOfTrustEditor, arguments);
      subscriberMixin(_this);
      _this.getCommandGroup().add(new SaveCommand());
      return _this;
    }

    /**
     * Adds child editors and initializes each of them.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(CircleOfTrustEditor, _BaseWidget);
    return _createClass(CircleOfTrustEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.addClass('CircleOfTrustEditor');
        dom.html(tpl());
        dom.on(MODIFY_EVENT, '.bajaux-initialized', function () {
          _this2.setModified(true);
          return false;
        });

        // Handles event triggered when circle of trust manager is saved independently from this parent
        // editor.  Currently the modified property of the editor is set to false if the editor's property
        // sheet is also not in a modified state.
        dom.on(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_SAVE_EVENT, '.bajaux-initialized', function () {
          if (!_this2.$propertySheet.isModified()) {
            _this2.setModified(false);
          }
          return false;
        });

        // Handles event triggered when circle of trust manager is reset independently from this parent
        // editor.  Currently the modified property of the editor is set to false if the editor's property
        // sheet is also not in a modified state.
        dom.on(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_RESET_EVENT, '.bajaux-initialized', function () {
          if (!_this2.$propertySheet.isModified()) {
            _this2.setModified(false);
          }
          return false;
        });
        var propertySheet = this.$propertySheet = new CircleOfTrustPropertySheet();
        var tabsWidget = this.$circleOfTrustTabsWidget = new CircleOfTrustTabsWidget();
        return Promise.all([propertySheet.initialize(dom.find('.CircleOfTrustPropertySheet')), tabsWidget.initialize(dom.find('.CircleOfTrustTabs'))]);
      }

      /**
       * Loads, and reloads, child editors.
       *
       * @param {baja.Component} circleOfTrust
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(circleOfTrust) {
        return Promise.all([this.$propertySheet.load(circleOfTrust), this.$circleOfTrustTabsWidget.load(circleOfTrust)]);
      }

      /**
       * Saves the property sheet and manager values associated with this editor.
       */
    }, {
      key: "doSave",
      value: function doSave() {
        return Promise.all([this.$propertySheet.save(), this.$circleOfTrustTabsWidget.$circleOfTrustManager.save({
          currentTabValue: this.$circleOfTrustTabsWidget.$currentTabValue
        })]);
      }

      /**
       * Called when the layout of the Widget changes.
       *
       * @returns {Promise}
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }

      /**
       * Removes the class from the jq() at the end of widget life cycle
       * and destroys all child widgets.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CircleOfTrustEditor');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseWidget);
});
