function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/weather/rc/wb/baja/UxMoonView
 */
define(['baja!', 'bajaux/spandrel', 'bajaux/mixin/subscriberMixIn', 'nmodule/bajaui/rc/ux/Label', 'nmodule/bajaui/rc/model/UxModelSupport', 'baja!gx:Font,gx:Brush,weather:WeatherIconSize,weather:MoonPosition', 'lex!weather', 'css!nmodule/weather/rc/weather'], function (baja, spandrel, subscriberMixIn, Label, UxModelSupport, types, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    weatherLex = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'weather',
      keyName: 'UxMoonView',
      properties: {
        rootCssClass: '-t-UxMoonView',
        enabled: true,
        visible: true,
        iconSize: baja.$('weather:WeatherIconSize', 'x64'),
        northernHemisphere: true,
        phaseFont: baja.$('gx:Font', weatherLex.get('phase.font')),
        phaseBrush: baja.$('gx:Brush', 'black'),
        illuminatedFont: baja.$('gx:Font', weatherLex.get('illumination.font')),
        illuminatedBrush: baja.$('gx:Brush', 'black')
      }
    };
  };
  var getMoonIcon = function getMoonIcon(ordinal, isNorthernHemisphere) {
    var moonPhase = baja.$('weather:MoonPhase', ordinal);
    var iconMap = {
      'newMoon': 'moonNew',
      'fullMoon': 'moonFull',
      'waningCrescent': isNorthernHemisphere ? 'moonWaningCrescent' : 'moonWaxingCrescent',
      'lastQuarter': isNorthernHemisphere ? 'moonLastQuarter' : 'moonFirstQuarter',
      'waningGibbous': isNorthernHemisphere ? 'moonWaningGibbous' : 'moonWaxingGibbous',
      'waxingGibbous': isNorthernHemisphere ? 'moonWaxingGibbous' : 'moonWaningGibbous',
      'firstQuarter': isNorthernHemisphere ? 'moonFirstQuarter' : 'moonLastQuarter',
      'waxingCrescent': isNorthernHemisphere ? 'moonWaxingCrescent' : 'moonWaningCrescent'
    };
    return iconMap[moonPhase.getTag()];
  };
  var getIconSize = function getIconSize(size) {
    var sizeMap = {
      'x64': 64,
      'x32': 32
    };
    return sizeMap[size.getTag()];
  };
  var LEFT = baja.$('bajaui:Halign', 'left');
  var LABEL_MARGIN = baja.$('gx:Insets', 3, 0, 0, 5);

  /**
   * UxView for weather:MoonPosition
   *
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/weather/rc/wb/baja/UxMoonView
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var UXMoonView = /*#__PURE__*/function (_spandrel) {
    function UXMoonView(params) {
      var _this;
      _classCallCheck(this, UXMoonView);
      _this = _callSuper(this, UXMoonView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      UxModelSupport(_this);
      subscriberMixIn(_this);
      _this.getSubscriber().attach('changed', function () {
        return _this.rerender();
      });
      return _this;
    }

    /**
     * @private
     * @return {module:nmodule/bajaui/rc/ux/Label}
     */
    _inherits(UXMoonView, _spandrel);
    return _createClass(UXMoonView, [{
      key: "$getMoonPhaseLabel",
      value: function $getMoonPhaseLabel() {
        return this.queryWidget('**/moonPhaseLabel');
      }

      /**
       * @private
       * @return {module:nmodule/bajaui/rc/ux/Label}
       */
    }, {
      key: "$getIlluminationLabel",
      value: function $getIlluminationLabel() {
        return this.queryWidget('**/illuminationLabel');
      }
    }]);
  }(spandrel(function (uxModel, _ref) {
    var props = _ref.props;
    //Proceed only if moonPosition is defined.
    var moonPosition = uxModel.getValue();
    if (!moonPosition) {
      return;
    }
    var phase = moonPosition.getPhase();
    var northernHemisphere = props.northernHemisphere,
      phaseFont = props.phaseFont,
      phaseBrush = props.phaseBrush,
      illuminatedFont = props.illuminatedFont,
      illuminatedBrush = props.illuminatedBrush,
      iconSize = props.iconSize;
    var imageName = getMoonIcon(phase.getOrdinal(), northernHemisphere);
    var icon = baja.$('baja:Icon', "module://weather/rc/".concat(imageName).concat(getIconSize(iconSize), ".png"));
    var moonPhaseText = phase.toString();
    var illuminatedText = weatherLex.get('UxMoonView.illuminationText', moonPosition.getIllumination());
    return spandrel.jsx("div", {
      className: "-t-UxMoonView-wrapper"
    }, spandrel.jsx("any", {
      value: icon
    }), spandrel.jsx("div", {
      className: "-t-UxMoonView-textWrapper"
    }, spandrel.jsx(Label, {
      spandrelKey: "moonPhaseLabel",
      className: "-t-UxMoonView-moonPhaseLabel",
      properties: {
        font: phaseFont,
        foreground: phaseBrush,
        text: moonPhaseText,
        halign: LEFT,
        margin: LABEL_MARGIN
      }
    }), spandrel.jsx(Label, {
      spandrelKey: "illuminationLabel",
      className: "-t-UxMoonView-illuminatedLabel",
      properties: {
        font: illuminatedFont,
        foreground: illuminatedBrush,
        text: illuminatedText,
        halign: LEFT,
        margin: LABEL_MARGIN
      }
    })));
  }, {
    strategy: 'niagara'
  }));
  return UXMoonView;
});
