function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/weather/rc/wb/baja/UxAirQualityView
 */
define(['baja!', 'baja!gx:Brush,gx:Font', 'lex!weather', 'bajaux/spandrel', 'bajaux/mixin/subscriberMixIn', 'nmodule/bajaui/rc/ux/Label', 'nmodule/weather/rc/util/airQualityUtil', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber'], function (baja, types, lexs, spandrel, subscriberMixIn, Label, airQualityUtil, DepthSubscriber) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    weatherLex = _lexs[0];
  var getAqiForConditions = airQualityUtil.getAqiForConditions;
  var DEFAULT_FONT = baja.$('gx:Font', weatherLex.get('state.font'));
  var LABEL_PROPS = [[-1, 'unknown', 'white', 'black'], [50, 'good', 'rgb(0, 228, 0)', 'black'], [100, 'moderate', 'rgb(255, 255, 0)', 'black'], [150, 'unhealthyForSensitiveGroups', 'rgb(255, 126, 0)', 'black'], [200, 'unhealthy', 'rgb(255, 0, 0)', 'white'], [300, 'veryUnhealthy', 'rgb(143, 63, 151)', 'white'], [Number.MAX_VALUE, 'hazardous', 'rgb(126, 0, 35)', 'white']].map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 4),
      max = _ref2[0],
      key = _ref2[1],
      background = _ref2[2],
      foreground = _ref2[3];
    return {
      max: max,
      text: weatherLex.get('airQuality.' + key),
      background: baja.$('gx:Brush', background),
      foreground: baja.$('gx:Brush', foreground)
    };
  });
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        font: DEFAULT_FONT,
        rootCssClass: '-t-AirQualityView',
        showAqi: false
      }
    };
  };

  /**
   * Shows the AQI (air quality index) for a `weather:CurrentConditions`, `weather:Forecast`, or
   * `weather:WeatherReport`.
   *
   * @class
   * @alias module:nmodule/weather/rc/wb/baja/UxAirQualityView
   * @extends module:bajaux/Widget
   */
  var UxAirQualityView = /*#__PURE__*/function (_spandrel) {
    function UxAirQualityView(params) {
      var _this;
      _classCallCheck(this, UxAirQualityView);
      _this = _callSuper(this, UxAirQualityView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      var sub = _this.$subscriber = new DepthSubscriber({
        depth: 2,
        subscriptionFilter: function subscriptionFilter(_ref3) {
          var component = _ref3.component;
          return component.getType().is('weather:CurrentConditions');
        }
      });
      sub.attach('changed', function () {
        return _this.rerender();
      });
      subscriberMixIn(_this);
      return _this;
    }

    /**
     * @private
     * @param {baja.Component} conditions
     * @returns {number}
     */
    _inherits(UxAirQualityView, _spandrel);
    return _createClass(UxAirQualityView, [{
      key: "$getAqi",
      value: function $getAqi(conditions) {
        return getAqiForConditions(conditions);
      }
    }]);
  }(spandrel(function (conditions, _ref4) {
    var enabled = _ref4.enabled,
      properties = _ref4.properties,
      self = _ref4.self;
    var font = properties.font,
      showAqi = properties.showAqi;
    var aqi = !enabled ? -1 : self.$getAqi(conditions);
    var _LABEL_PROPS$find = LABEL_PROPS.find(function (_ref5) {
        var max = _ref5.max;
        return aqi <= max;
      }),
      text = _LABEL_PROPS$find.text,
      background = _LABEL_PROPS$find.background,
      foreground = _LABEL_PROPS$find.foreground;
    var shouldShowAqi = aqi !== -1 && showAqi;
    var suffix = shouldShowAqi ? " (".concat(aqi, ")") : '';
    return spandrel.jsx(Label, {
      properties: {
        text: text + suffix,
        background: background,
        foreground: foreground,
        font: font
      }
    });
  }));
  return UxAirQualityView;
});
