/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
 
/**
 * Tab JavaScript support for BHxTabbedView.
 */
var save = new Save();
function Save()
{ 

  this.skipConfirm=false;
  this.locked=false;
  this.saveId="";
  this.savePath="";
  this.warningMessage="You have made changes, which have not been saved ...";
  
  this.modified = function()
  {
    if(save.locked)
      return;
    var saveElem = smartTable.$$("smartTableSave");
    if(saveElem == null)
      return;

    saveElem.className='ux-btn-tb';
    saveElem.removeAttribute("disabled");
    
    if(!save.skipConfirm)
      window.onbeforeunload = save.confirm;
  }
  
  this.isModified = function()
  {
    var saveElem = smartTable.$$("smartTableSave");
    if(saveElem == null)
      return false;
    return saveElem.className == 'ux-btn-tb';
  }
  
  this.save = function()
  {
    var saveElem = smartTable.$$("smartTableSave");
    if(saveElem == null)
      return;
    save.pending();
    hx.fireEvent(save.savePath, save.saveId);
  }
  
  this.confirm = function(e)
  {
    var saveElem = smartTable.$$("smartTableSave");
    if(saveElem == null)
    {
      if(hx.ie && smartTable != null)
        smartTable.endEvent(e);
      return null;
    }
    else
    {
      return save.warningMessage;
    }
  }
  
  this.pending = function()
  {
    var saveElem = smartTable.$$("smartTableSave");
    if(saveElem == null)
      return;
    saveElem.className='ux-btn-tb ux-disabled smartTableButton-pending';
    saveElem.setAttribute("disabled", "true");
    if(!save.skipConfirm)
      window.onbeforeunload = save.confirm;
  }
  
  this.saved = function()
  {
    var saveElem = smartTable.$$("smartTableSave");
    if(saveElem== null)
      return;
    saveElem.className='ux-btn-tb ux-disabled';
    saveElem.setAttribute("disabled", "true");
    window.onbeforeunload = null;    
  }
  
  this.enable = function()
  {
    save.locked=false;
    save.modified();
  }
  
  this.disable = function()
  {
    save.locked=true;
    save.saved();
  }

  /**
   * setup event listeners on bajaux and hx field editors so that
   * changes to elements within the specified 'elem' cause the save to enable.
   * @param {HTMLElement} elem
   * @param {String} savePath
   * @param {String} id
   */
  this.attachSave = function (elem, savePath, id) {
    var originalModified = hx.modified;
    hx.modified = function (target) {

      if (elem.contains(target)) {
        save.modified();
      }
      originalModified.apply(hx, arguments);
    };

    this.saveId=id;
    this.savePath=savePath;
    var inputs = elem.getElementsByTagName("input");
    var selects = elem.getElementsByTagName("select");
    var textareas = elem.getElementsByTagName("textarea");
    
    this.addPress(inputs);
    this.addKey(inputs);
    this.addChange(selects);
    this.addChange(textareas);
    this.addTextAreaKey(textareas);
    
    try
    {
      hx.focus(inputs);
    }
    catch(err)
    {}
  };
  
  this.addChange = function(inputs)
  {
    for (var i=0; i<inputs.length; i++) 
    {
      if(inputs[i].getAttribute("noSave") != null)
        continue;
      
      if(hx.ie)
        inputs[i].attachEvent("onchange", this.change);
      else  
        inputs[i].addEventListener("change", this.change, false);            
    }
  }
  
  this.addPress = function(inputs)
  {
    for (var i=0; i<inputs.length; i++) 
    {
      if(inputs[i].getAttribute("noSave") != null)
        continue;
        
      if(hx.ie)
        inputs[i].attachEvent("onkeypress", this.press);
      else  
        inputs[i].addEventListener("keypress", this.press, true);
      
      if(inputs[i].type == "checkbox" || inputs[i].type == "radio")
      {
        if(hx.ie)
          inputs[i].attachEvent("onclick", this.change);
        else  
          inputs[i].addEventListener("click", this.change, false);            
      }
      else if(inputs[i].type == "file")
      {
        if(hx.ie)
          inputs[i].attachEvent("onchange", this.change);
        else  
          inputs[i].addEventListener("change", this.change, false);            
      }
    }    
  }
  
  this.addKey = function(inputs)
  {
    for (var i=0; i<inputs.length; i++) 
    {
      if(inputs[i].getAttribute("noSave") != null)
        continue;
        
      if(hx.ie)
        inputs[i].attachEvent("onkeydown", this.key);
      else  
        inputs[i].addEventListener("keydown", this.key, false);
    }    
  }
  
  this.addTextAreaKey = function(inputs)
  {
    for (var i=0; i<inputs.length; i++) 
    {
      if(inputs[i].getAttribute("noSave") != null)
        continue;
        
      if(hx.ie)
        inputs[i].attachEvent("onkeydown", this.textAreaKey);
      else  
        inputs[i].addEventListener("keydown", this.textAreaKey, false);
    }    
  }
  
  this.change = function(e)
  {
    save.modified();
  }    
  
  this.key = function(e)
  {
    var i;
    if (hx.ie) 
      i = e.keyCode;
    else 
      i = e.which; 
      
    var elem = smartTable.elemFromEvent(e);
    if(elem != null && elem.readOnly)
      return false;  
    
    if(save.isControlKey(i))
      return true;
    else if( i == 13 )
    {
      if(smartTable.$$("smartTableSave").className.indexOf("disabled") == -1)
      { 
        save.pending();
        hx.fireEvent(save.savePath, save.saveId);
      }
      return false;
    }
    save.modified();
    return true;
  }    
  
  this.textAreaKey = function(e)
  {
    var i;
    if (hx.ie) 
      i = e.keyCode;
    else 
      i = e.which; 
    
    if(save.isControlKey(i))
      return true;
    save.modified();
    return true;
  }    
  
  this.press = function(e)
  {
    var i;
    if (hx.ie && e.keyCode)
      i = e.keyCode;
    else 
      i = e.which;     
    
    if( i == 13) //enter
    {
      if(!hx.ie)
        e.preventDefault();
      return false;
    }
    else
      return true;
  }
  
  this.isControlKey = function(i)
  {
    return  i == 27 || i == 9 || i == 91 || i == 92 || (i >= 16 && i <= 20) || (i >= 33 && i <= 40);
  }
} 
