function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * Widget to show the filter options for the Component Tags pane.
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/filter/ComponentTagFilter
 */
define(['baja!', 'lex!tagdictionary', 'jquery', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor'], function (baja, lexs, $, _, Promise, fe, BaseEditor, BooleanEditor) {
  'use strict';

  var tagdictionaryLex = lexs[0];

  /**
   * Widget to manage filter settings for the Component Tags pane.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/tagdictionary/rc/filter/ComponentTagFilter
   * @param {Object} [params]
   * @param {Function} [params.updateFunction] function called when values in the editor change
   */
  var ComponentTagFilter = function ComponentTagFilter(params) {
    this.$updateFunction = params && params.updateFunction ? params.updateFunction : _.noop;
    BaseEditor.apply(this, arguments);
  };
  ComponentTagFilter.prototype = Object.create(BaseEditor.prototype);
  ComponentTagFilter.prototype.constructor = ComponentTagFilter;

  /**
   * Initialize the widget.
   *
   * @param {JQuery} dom the DOM element to load the widget into.
   */
  ComponentTagFilter.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('ComponentTagFilter');
    dom.html('<span class="showDirect" />' + '<span class="showImplied" />');
    dom.on('change', '.showDirect, .showImplied', function () {
      return Promise.all([that.$showDirectEditor.read(), that.$showImpliedEditor.read()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          showDirectValue = _ref2[0],
          showImpliedValue = _ref2[1];
        that.$updateFunction({
          showDirect: showDirectValue,
          showImplied: showImpliedValue
        });
      });
    });
    return Promise.all([fe.buildFor({
      dom: dom.find('.showDirect'),
      type: BooleanEditor,
      value: true,
      formFactor: 'mini',
      properties: {
        trueText: tagdictionaryLex.getSafe('tagManager.direct'),
        falseText: tagdictionaryLex.getSafe('tagManager.direct')
      }
    }), fe.buildFor({
      dom: dom.find('.showImplied'),
      type: BooleanEditor,
      value: false,
      formFactor: 'mini',
      properties: {
        trueText: tagdictionaryLex.getSafe('tagManager.implied'),
        falseText: tagdictionaryLex.getSafe('tagManager.implied')
      }
    })]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        showDirectEditor = _ref4[0],
        showImpliedEditor = _ref4[1];
      that.$showDirectEditor = showDirectEditor;
      that.$showImpliedEditor = showImpliedEditor;
    });
  };

  /**
   * Save the filter settings.
   *
   * @returns {Object} an object with the state to be persisted
   */
  ComponentTagFilter.prototype.saveState = function () {
    // Cannot read the field editors as this function is not expected to return a promise.
    // see MgrStateHandler#doSave = specifically the call to #saveForKey
    var jq = this.jq();
    return {
      showDirect: jq.find('.showDirect > input').is(':checked'),
      showImplied: jq.find('.showImplied > input').is(':checked')
    };
  };

  /**
   * Restore any saved state.
   *
   * @param {Object} savedState - an object containing the saved state.
   */
  ComponentTagFilter.prototype.restoreState = function (savedState) {
    var jq = this.jq();
    jq.find('.showDirect > input').prop('checked', savedState.showDirect);
    jq.find('.showImplied > input').prop('checked', savedState.showImplied);
  };

  /**
   * Sets the child widgets on the filter to the readonly value
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  ComponentTagFilter.prototype.setReadonly = function (readonly) {
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * Destroy the widget.
   *
   * @returns {Promise|*}
   */
  ComponentTagFilter.prototype.doDestroy = function () {
    this.jq().removeClass('ComponentTagFilter');
    return this.getChildWidgets().destroyAll();
  };
  return ComponentTagFilter;
});
