function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/TagUxManager
 */
define(['baja!', 'lex!tagdictionary', 'log!nmodule.tagdictionary.rc.TagUxManager', 'Promise', 'jquery', 'underscore', 'bajaux/commands/CommandGroup', 'bajaux/mixin/subscriberMixIn', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/tagdictionary/rc/commands/AddTagCommand', 'nmodule/tagdictionary/rc/commands/EditTagCommand', 'nmodule/tagdictionary/rc/commands/DeleteTagCommand', 'nmodule/tagdictionary/rc/commands/RemoveComponentCommand', 'nmodule/tagdictionary/rc/filter/AvailableTagFilter', 'nmodule/tagdictionary/rc/filter/ComponentTagFilter', 'nmodule/tagdictionary/rc/model/ComponentTagModel', 'nmodule/tagdictionary/rc/model/AvailableTagModel', 'nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin', 'nmodule/tagdictionary/rc/util/rpcUtil', 'nmodule/tagdictionary/rc/util/SelectedComponentsTableSupport', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'css!nmodule/tagdictionary/rc/tagdictionary'], function (baja, lexs, log, Promise, $, _, CommandGroup, subscriberMixin, switchboard, AddTagCommand, EditTagCommand, DeleteTagCommand, RemoveComponentCommand, AvailableTagFilter, ComponentTagFilter, ComponentTagModel, AvailableTagModel, BaseTagInfoMixin, rpcUtil, selectedComponentsTableSupport, taggingUtil, compUtils, StringEditor, fe, htmlUtils, Manager, mgrUtils, MgrTypeInfo, MgrLearn) {
  'use strict';

  var Relation = require('bajaScript/baja/tag/Relation');
  var tagdictionaryLex = lexs[0];
  var findCommand = mgrUtils.findCommand;
  var logError = log.severe.bind(log);
  var MGR_DLG_STYLE_CLASS = 'TagManagerDialog';
  var DLG_WIDTH_ADJ = 20;
  var DLG_HEIGHT_ADJ = 30;
  var NO_SELECTED_COMPONENT_TXT = tagdictionaryLex.getSafe('tagManager.no.component.selected');
  var NO_SELECTED_COMPONENT_TITLE = tagdictionaryLex.getSafe('tagManager.no.component.selected.title');
  var HIDDEN = 'hidden'; // .hidden style class in webEditors-structure.css

  /**
   * Tag Manager.
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/TagUxManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   * @param {Object} [params]
   */
  var TagUxManager = function TagUxManager(params) {
    var that = this;
    Manager.call(that, _.extend({
      moduleName: 'tagdictionary',
      keyName: 'TagManager'
    }, params));
    subscriberMixin(that);
    MgrLearn(that);
    var singleComponentMode = params && params.singleComponentMode;
    if (!singleComponentMode) {
      selectedComponentsTableSupport(that);
    }
    switchboard(that, {
      'updateMainTable': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
    that.$tagTablefilterParams = taggingUtil.DEFAULT_TAG_TABLE_FILTER_PARAMS;
    that.$discoveryTableFilterParams = taggingUtil.DEFAULT_DISCOVERY_TABLE_FILTER_PARAMS;
    var superDoLayout = that.doLayout;

    /**
     * Called when the layout of the manager changes
     *
     * @returns {*|Promise}
     */
    that.doLayout = function () {
      var that = this;
      if (singleComponentMode) {
        that.resizeDialog();
        that.$getDialogContent().addClass(TagUxManager.MGR_DLG_STYLE_CLASS);

        // in conjunction with the '.TagManagerDialog.js-dialog-content-wrapper' selector
        // in tagdictionary.css, this overrides the flex box behaviour of dialog.js.
        that.$getDialogContent().removeClass('ux-fullscreen-support');
      }
      return superDoLayout.apply(that, arguments).then(function () {
        that.reformatTables();
      });
    };
    var superFinishMainTableRow = that.finishMainTableRow;

    /**
     * Override to update manager row styling
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @param {JQuery} dom
     * @returns {Promise.<JQuery>} resolves to a dom element with updated styling
     */
    that.finishMainTableRow = function (row, dom) {
      return superFinishMainTableRow.apply(that, arguments).then(function (superDom) {
        return ComponentTagModel.finishTableRow(row, superDom, that.$subscriber);
      });
    };
    var superFinishDiscoveryTableRow = that.finishDiscoveryTableRow;

    /**
     * Override to update discovery row styling
     *
     * @override
     * @function module:nmodule/webEditors/rc/wb/mgr/MgrLearn#finishDiscoveryTableRow
     *
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @param {JQuery} dom
     * @returns {Promise.<JQuery>} resolves to a dom element with updated styling
     */
    that.finishDiscoveryTableRow = function (row, dom) {
      return superFinishDiscoveryTableRow.apply(that, arguments).then(function (superDom) {
        return AvailableTagModel.finishTableRow(row, superDom, that.$subscriber);
      });
    };
  };
  TagUxManager.prototype = Object.create(Manager.prototype);
  TagUxManager.prototype.constructor = TagUxManager;
  TagUxManager.MGR_DLG_STYLE_CLASS = MGR_DLG_STYLE_CLASS;
  TagUxManager.DLG_WIDTH_ADJ = DLG_WIDTH_ADJ;
  TagUxManager.DLG_HEIGHT_ADJ = DLG_HEIGHT_ADJ;

  /**
   * resizes the manager dialog
   */
  TagUxManager.prototype.resizeDialog = function () {
    this.$setDialogContentHeight();
    this.$setDialogContentWidth();
  };

  /**
   * Adds the RemoveComponentCommand to the right-click on the components of SelectComponents pane.
   *
   * @since Niagara 4.14
   * @private
   * @param {JQuery.TriggeredEvent} e
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  TagUxManager.prototype.toContextMenuCommandGroup = function (e) {
    var _this = this;
    return Manager.prototype.toContextMenuCommandGroup.apply(this, [e]).then(function (cmdGrp) {
      if (cmdGrp) {
        var subjectArr = _this.getSubject($(e.currentTarget));
        // Selected subjects will be an array, check for type and the length.
        // Check if only Component type exist in the array, if anything else exists, do not add RemoveComponentsCommand to the context menu.
        if (subjectArr && subjectArr.length > 0 && subjectArr.every(function (subject) {
          return subject instanceof baja.Component;
        })) {
          // Context menu of the selected components to not have the Edit and Delete commands.
          cmdGrp.remove(cmdGrp.findCommand(DeleteTagCommand)).remove(cmdGrp.findCommand(EditTagCommand));

          // Add RemoveComponentCommand.
          var removeComponentCmd = _this.$selectedComponentsCommandGroup.findCommand(RemoveComponentCommand);
          if (removeComponentCmd) {
            cmdGrp.add(removeComponentCmd);
          }
        }
      }
      return cmdGrp;
    });
  };

  /**
   * reformat the tables according to the available height/width
   */
  TagUxManager.prototype.reformatTables = function () {
    var discoveryPane = this.jq().find('.split-pane-component.mgr-pane-top'),
      discoveryPaneHeader = discoveryPane.find('.mgr-pane-title-container'),
      discoveryPaneContent = discoveryPane.find('.mgr-table.discoveryTable'),
      discoveryObjectCount = discoveryPane.find('.mgr-pane-object-count.discovery-table-object-count'),
      discoveryShowHide = discoveryPane.find('.mgr-show-hide-menu-discovery'),
      databasePane = this.jq().find('.split-pane-component.mgr-pane-bottom'),
      databasePaneHeader = databasePane.find('.mgr-pane-title-container'),
      databasePaneContent = databasePane.find('.mgr-table.mainTable'),
      databaseObjectCount = databasePane.find('.mgr-pane-object-count.main-table-object-count'),
      databaseShowHide = databasePane.find('.mgr-show-hide-menu-main'),
      selectedComponentsPane = this.jq().find('.split-pane-component.mgr-pane-left'),
      selectedComponentsObjectCount = selectedComponentsPane.find('.mgr-pane-object-count.components-table-object-count'),
      selectedComponentsShowHide = selectedComponentsPane.find('.mgr-show-hide-menu-components');

    // Discovery (Available Tags) Pane

    // set discoveryPaneContent height
    discoveryPaneContent.outerHeight(discoveryPane.outerHeight() - discoveryPaneHeader.outerHeight());
    discoveryObjectCount.removeClass(HIDDEN);
    discoveryShowHide.removeClass(HIDDEN);

    // hide object count and showHide on the basis of pane width
    if (discoveryPane.outerWidth() < 824) {
      // hide object count
      discoveryObjectCount.addClass(HIDDEN);
      if (discoveryPane.outerWidth() < 764) {
        // hide showHide icon
        discoveryShowHide.addClass(HIDDEN);
      }
    }

    // Database (Showing tag on) Pane

    // set databasePaneContent height
    databasePaneContent.outerHeight(databasePane.outerHeight() - databasePaneHeader.outerHeight());
    databaseObjectCount.removeClass(HIDDEN);
    databaseShowHide.removeClass(HIDDEN);

    // hide object count and showHide on the basis of pane width
    if (databasePane.outerWidth() < 610) {
      // hide object count
      databaseObjectCount.addClass(HIDDEN);
      if (databasePane.outerWidth() < 550) {
        // hide showHide icon
        databaseShowHide.addClass(HIDDEN);
      }
    }

    // Selected Components Pane

    selectedComponentsObjectCount.removeClass(HIDDEN);
    selectedComponentsShowHide.removeClass(HIDDEN);

    // hide object count and showHide on the basis of pane width
    if (selectedComponentsPane.outerWidth() < 298) {
      // hide object count
      selectedComponentsObjectCount.addClass(HIDDEN);
      if (selectedComponentsPane.outerWidth() < 238) {
        // hide showHide icon
        selectedComponentsShowHide.addClass(HIDDEN);
      }
    }
  };

  /*
   * @private
   * @returns {JQuery} the dialog container element
   */
  TagUxManager.prototype.$getDialogContainer = function () {
    return $('.js-dialog-container.bajaux-widget-container');
  };

  /*
   * @private
   * @returns {JQuery} the dialog content element
   */
  TagUxManager.prototype.$getDialogContent = function () {
    return $('.js-dialog-content');
  };
  /*
   * @private
   * @returns {JQuery} the CommandButton container element
   */
  TagUxManager.prototype.$getCommandButtonContainer = function () {
    return $('.js-dialog-button-content');
  };

  /*
   * @private
   * sets the height of the Dialog Content element
   */
  TagUxManager.prototype.$setDialogContentHeight = function () {
    this.$getDialogContent().outerHeight(this.$getDialogContainer().outerHeight() - this.$getCommandButtonContainer().outerHeight() - TagUxManager.DLG_HEIGHT_ADJ);
  };

  /*
   * @private
   * sets the width of the Dialog Content element
   */
  TagUxManager.prototype.$setDialogContentWidth = function () {
    this.$getDialogContent().outerWidth(this.$getDialogContainer().outerWidth() - TagUxManager.DLG_WIDTH_ADJ);
  };
  TagUxManager.prototype.getTagManagerHtml = function () {
    return taggingUtil.htmlForTaggingDialog();
  };

  /**
   * @param {JQuery} dom
   * @param {Object} [params] Optional params object passed into `initialize()`.
   * @returns {Promise}
   */
  TagUxManager.prototype.doInitialize = function (dom, params) {
    var that = this;
    dom.addClass('TagUxManager');
    htmlUtils.onLongPress(dom, function (event) {
      $(event.target).click(); //click to select a row
      that.$getEditCommand().invoke()["catch"](logError);
    }, {
      selector: '.mainTable tr',
      fireClick: true
    });
    htmlUtils.onLongPress(dom, function (event) {
      $(event.target).click(); //click to select a row
      that.$getAddCommand().invoke()["catch"](logError);
    }, {
      selector: '.discoveryTable tr',
      fireClick: true
    });
    return Manager.prototype.doInitialize.call(that, dom, _.extend(params, {
      html: that.getTagManagerHtml()
    })).then(function () {
      // remove the job bar
      dom.find('.mgr-job-bar-container').remove();
      var discoveryPaneTitleElement = dom.find('.mgr-discovery-pane > .mgr-pane-title-container > .mgr-pane-title'),
        databasePaneTitleElement = dom.find('.mgr-pane-bottom > .mgr-pane-title-container > .mgr-pane-title');

      // add filter bar for discovered tags
      that.$availableTagFilter = new AvailableTagFilter({
        updateFunction: _.bind(that.updateDiscoveryTable, that)
      });

      // add filter for implied tags on tag database pane
      that.$componentTagFilter = new ComponentTagFilter({
        updateFunction: _.bind(that.updateMainTable, that)
      });
      return Promise.all([that.$availableTagFilter.initialize($('<span/>').insertAfter(discoveryPaneTitleElement)), that.$componentTagFilter.initialize($('<span/>').insertAfter(databasePaneTitleElement)), fe.buildFor({
        dom: $('<span class="current-component"/>').insertAfter(databasePaneTitleElement),
        type: StringEditor,
        value: '',
        formFactor: 'mini'
      }).then(function (stringEditor) {
        that.$currentComponentEditor = stringEditor;
        return that.$currentComponentEditor.setReadonly(true);
      })]);
    });
  };

  /**
   * updates the manager's main table with the component's current tags according to the filter parameters
   *
   * @param {Object} [filterParams]
   * @param {Boolean} [filterParams.showDirect] if true show direct tags in the table, default is true
   * @param {Boolean} [filterParams.showImplied] if true show implied tags in the table, default is false
   * @returns {Promise}
   */
  TagUxManager.prototype.updateMainTable = function (filterParams) {
    if (filterParams) {
      this.$tagTablefilterParams = filterParams;
    }
    return ComponentTagModel.populateMainTable(this);
  };

  /**
   * updates the table of available (discovered) tags according to the filter parameters
   *
   * @param {Object} [filterParams]
   * @param {String} [filterParams.dictionary] the TagDictionary to display
   * @param {String} [filterParams.showAllValidBest] whether to show All, Valid or Best tags (see workbench:TagFilterEnum)
   * @param {String} [filterParams.textFilter] show only tags whose name matches this filter
   * @returns {Promise}
   */
  TagUxManager.prototype.updateDiscoveryTable = function (filterParams) {
    var that = this,
      tagDictionary = filterParams.dictionary,
      // if the tagDictionary has changed run discover
      discoverPromise = that.$currentDictionary === tagDictionary ? Promise.resolve() : that.discover();
    that.$discoveryTableFilterParams = filterParams;
    return discoverPromise.then(function () {
      return AvailableTagModel.populateLearnTable(that);
    });
  };

  /**
   * Save the state we require for restoring after a hyperlink or page reload.
   * (visible columns is saved by the base type).
   *
   * @returns {Object} an object with the state to be persisted
   */
  TagUxManager.prototype.saveStateForKey = function () {
    var state = {};
    _.extend(state, this.$availableTagFilter.saveState());
    _.extend(state, AvailableTagModel.saveState(this));
    _.extend(state, this.$componentTagFilter.saveState());
    return state;
  };

  /**
   * Restore the state we saved in the call to saveStateForOrd().
   * This will reinstate the filters in both the discovery & tag tables.
   *
   * @param {Object} state - an object containing the saved state.
   */
  TagUxManager.prototype.restoreStateForKey = function (state) {
    // use a default setting for any key that is not present
    _.defaults(state, taggingUtil.DEFAULT_DISCOVERY_TABLE_FILTER_PARAMS);
    _.defaults(state, {
      tagsExpanded: false,
      tagGroupsExpanded: false
    });
    _.defaults(state, taggingUtil.DEFAULT_TAG_TABLE_FILTER_PARAMS);
    state.dictionary = this.$availableTagFilter.checkDictionary(state.dictionary);

    // restore is called before the discovery is set off, so update the discovery and tag table filters.
    this.$discoveryTableFilterParams = {
      dictionary: state.dictionary,
      textFilter: state.textFilter,
      showAllValidBest: state.showAllValidBest
    };
    this.$discoveryTableFolders = {
      tagsExpanded: state.tagsExpanded,
      tagGroupsExpanded: state.tagGroupsExpanded
    };
    this.$tagTablefilterParams = {
      showDirect: state.showDirect,
      showImplied: state.showImplied
    };
    this.$availableTagFilter.restoreState(state);
    this.$componentTagFilter.restoreState(state);
  };

  /**
   * updates the manager's main table to reflect a new underlying component
   *
    * @param {baja.Component} component
   * @returns {Promise}
   */
  TagUxManager.prototype.updateShowTagsOnComponent = function (component) {
    var that = this,
      previousComponent = that.value();
    that.$value = component;
    return Promise.all([previousComponent ? that.$subscriber.unsubscribe(previousComponent) : Promise.resolve(), component ? that.$subscriber.subscribe(component) : Promise.resolve()]).then(function () {
      return that.updateMainTable(that.$tagTablefilterParams);
    }).then(function () {
      // We may not need to update the discovery table, depends on how much
      //          we want to do with isValidFor/isIdealFor ...
      return that.updateDiscoveryTable(that.$discoveryTableFilterParams);
    }).then(function () {
      return that.$updateCurrentComponentEditor(component);
    });
  };

  /**
   * updates the currentComponentEditor using the passed component/relation.
   *
   * @private
   * @param {baja.Component|baja.Relation} comp
   * @returns {Promise}
   */
  TagUxManager.prototype.$updateCurrentComponentEditor = function (comp) {
    var that = this;
    var displayName = NO_SELECTED_COMPONENT_TXT,
      titleText = NO_SELECTED_COMPONENT_TITLE;
    if (comp) {
      displayName = comp.getDisplayName();
      if (!displayName) {
        displayName = taggingUtil.workOutName(comp);
      }
      titleText = compUtils.toDisplaySlotPathString(comp);
    }
    return that.$currentComponentEditor.load(displayName).then(function () {
      that.$currentComponentEditor.jq().attr('title', titleText);
    });
  };

  /**
   * Load the models into the main and discovery tables, and configure the commands.
   *
   * @param {baja.Component} component, whose tags we are going to manage.
   * @returns {Promise}
   */
  TagUxManager.prototype.doLoad = function (component) {
    var that = this;
    if (component.getType().is('baja:Relation')) {
      that.$componentTagFilter.setReadonly(true);
      that.$availableTagFilter.setFilterTypeReadonly();
    }
    return Manager.prototype.doLoad.call(that, component).then(function () {
      return ComponentTagModel.populateMainTable(that);
    }).then(function () {
      return that.updateDiscoveryTable(that.$discoveryTableFilterParams);
    }).then(function () {
      if (that.$subscriber) {
        that.$subscriber.attach('added changed', function (prop, cx) {
          // update when tag/tagGroup data is added/changed
          if (prop.getFlags() & baja.Flags.METADATA ||
          // a tag
          taggingUtil.isTagGroupRelation(component.get(prop))) {
            // a tag group
            return that.updateMainTable();
          }
        });
        that.$subscriber.attach('removed', function (prop, removedValue, cx) {
          // update main table when tag/tagGroup data is removed
          if (prop.getFlags() & baja.Flags.METADATA ||
          // a tag
          taggingUtil.isTagGroupRelation(removedValue)) {
            // a tag group
            return that.updateMainTable();
          }
        });
      } else {
        // if there's no subscriber, assume that we're dealing with tags on a relation
        // (which should also mean we're in dialog mode)
        that.on(taggingUtil.RELATION_TAGS_CHANGED_EVENT, function () {
          return that.updateMainTable();
        });
      }
      return that.$updateCurrentComponentEditor(component);
    });
  };

  /**
   * Returns the default set of Tag Manager Commands.
   *
   * @returns {Array.<module:bajaux/commands/Command>}
   */
  TagUxManager.prototype.makeCommands = function () {
    return [new EditTagCommand(this), new AddTagCommand(this), new DeleteTagCommand(this)];
  };

  /**
   * @returns {Promise} empty, to disable right-click in learn table
   * @since Niagara 4.14
   */
  TagUxManager.prototype.getLearnTableCommands = function () {
    return Promise.resolve([]);
  };

  /**
   * makes a model for the main database table.
   *
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */
  TagUxManager.prototype.makeModel = function () {
    return ComponentTagModel.make(this);
  };

  /**
   * Return the 'AddTagCommand' instance from the command group.
   *
   * @private
   * @override
   * @returns {module:nmodule/tagdictionary/rc/commands/AddTagCommand}
   */
  TagUxManager.prototype.$getAddCommand = function () {
    return findCommand(this, AddTagCommand);
  };

  /**
   * Return the 'EditTagCommand' instance from the command group.
   *
   * @private
   * @returns  {module:nmodule/tagdictionary/rc/commands/EditTagCommand}
   */
  TagUxManager.prototype.$getEditCommand = function () {
    return findCommand(this, EditTagCommand);
  };

  /**
   * Return the 'DeleteTagCommand' instance from the command group.
   *
   * @private
   * @returns  {module:nmodule/tagdictionary/rc/commands/DeleteTagCommand}
   */
  TagUxManager.prototype.$getDeleteCommand = function () {
    return findCommand(this, DeleteTagCommand);
  };

  /**
   * Return an Object with an isSelected function that returns true.
   * This is so the MgrLearnTableSupport#isLearnModeCommandSelected
   * will return true and therefore show the discovery pane.
   *
   * As an alternative, could just add LearnModeCommand to makeCommands()
   *
   * @private
   * @override
   * @returns {Object}
   */
  TagUxManager.prototype.$getLearnModeCommand = function () {
    return {
      isSelected: _.constant(true)
    };
  };

  /**
   * Make the model for the discovery table.
   *
   * @override
   * @function module:webEditors/rc/wb/mgr/MgrLearn#makeLearnModel
    * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */
  TagUxManager.prototype.makeLearnModel = function () {
    return AvailableTagModel.make();
  };

  /**
   * @override
   * @function module:webEditors/rc/wb/mgr/MgrLearn#doDiscover
   *
   * @returns {Promise}
   */
  TagUxManager.prototype.doDiscover = function () {
    var that = this;
    return taggingUtil.getTagDictionaryService().then(function (tagDictionaryService) {
      // can only discover available tag if there's a TagDictionary service
      if (!tagDictionaryService) {
        that.$tagInfos = [];
        that.$tagGroupInfos = [];
        return;
      }
      var params = that.$discoveryTableFilterParams,
        tagDictionary = params.dictionary;
      return compUtils.getNavOrd(that.value()).then(function (navOrd) {
        return that.$getTagInfosAndTagGroupInfos(tagDictionary, navOrd.toString());
      }).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          tagInfos = _ref2[0],
          tagGroupInfos = _ref2[1];
        that.$currentDictionary = tagDictionary;
        that.$tagInfos = tagInfos;
        that.$tagGroupInfos = tagGroupInfos;
      });
    });
  };

  /**
   * Returns Tags and TagGroups from the currently selected TagDictionary
   *
   * @param {String} tagDictionary
   * @param {String} targetComponentOrd, the ord of the component that we determine isValidFor, isIdealFor etc against
   *
   * @private
   * @returns {Promise.<Array.<Array>>} Promise resolving to an array containing 2 arrays
   *    Array[0] -> Array.<module:nmodule/tagdictionary/rc/taginfo/TagInfoMixin>
   *    Array[1] -> Array.<module:nmodule/tagdictionary/rc/taginfo/TagGroupInfoMixin>
   */
  TagUxManager.prototype.$getTagInfosAndTagGroupInfos = function (tagDictionary, targetComponentOrd) {
    return Promise.all([rpcUtil.getTagInfos(tagDictionary, targetComponentOrd), rpcUtil.getTagGroupInfos(tagDictionary, targetComponentOrd)]);
  };

  /**
   * Return the type(s) suitable for the given discovery item.
   *
   * @override
   * @function module:webEditors/rc/wb/mgr/MgrLearn#getTypesForDiscoverySubject
   *
   * @param {baja.Value} discoveredObject
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
   */
  TagUxManager.prototype.getTypesForDiscoverySubject = function (discoveredObject) {
    return MgrTypeInfo.make('baja:Component');
  };

  /**
   * Creates a new 'tagDictionary:TagInfo' or 'tagDictionary:TagGroupInfo' instance
   * for a particular node in the discovery table.
   *
   * @override
   * @function module:webEditors/rc/wb/mgr/MgrLearn#newInstanceFromDiscoverySubject
   *
   * @param {module:nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin} discovery an instance of a discovery object, in this case a TagInfoMixin or TagGroupInfoMixin
   * @param {Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>} typeInfos
   * @returns {Promise.<baja.Component> promise of new component instance
   */
  TagUxManager.prototype.newInstanceFromDiscoverySubject = function (discovery, typeInfos) {
    var newInstance;

    // make sure the types we need are available locally
    return baja.importTypes({
      typeSpecs: [discovery.getTagBType()]
    }).then(function () {
      newInstance = baja.$(discovery.getTagBType());
      discovery.mixinTagInfo(newInstance);

      // adding tagValue as a slot, so BatchComponentEditor can save a proposed value to it.
      return compUtils.writeSlot(newInstance, 'tagValue', newInstance.getDefaultValue(), {});
    }).then(function () {
      return newInstance;
    });
  };

  /**
   * Get the values to be set as the proposals on the batch component editor for
   * the rows being added via the AddCommand.
   *
   * @override
   * @function module:webEditors/rc/wb/mgr/MgrLearn#getProposedValuesFromDiscovery
   *
   * @param {module:nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin} discovery an item obtained from a node in discovery table.
   * @param {*} subject - the subject of the `Row` whose values are to be proposed.
   * @see module:nmodule/webEditors/rc/wb/table/tree/TreeNode
   * @returns {Object|Promise.<Object>} an object literal with the name and initial values to be used for the new component.
   */
  TagUxManager.prototype.getProposedValuesFromDiscovery = function (discovery, subject) {
    return {
      name: subject.getTagId().getQName(),
      values: {
        tagValue: subject.getDefaultValue()
      }
    };
  };

  /**
   * Override the standard #getExisting functionality to additionally check for
   * existing tags on the component that aren't currently being displayed.
   *
   * @param {baja.Complex} discovery
   *
   * @returns {Promise.<baja.Tag|baja.Relation|undefined>} the Tag/Tag Group that was
   * found to match the given discovery node, or undefined if no such match was found.
   */
  TagUxManager.prototype.getExisting = function (discovery) {
    return Promise.resolve(this.$tagExistsButIsHidden(discovery) || MgrLearn.prototype.getExisting.call(this, discovery));
  };

  /**
   * @param {baja.Complex} discovery
   * @param {baja.Tag|baja.Relation} tag
   *
   * @returns {boolean}  - true if the discovery item and tag match.
   */

  TagUxManager.prototype.$tagExists = function (discovery, tag) {
    if (!(discovery instanceof BaseTagInfoMixin)) {
      return false;
    }
    var discoveryTagId = discovery.getTagId().getQName();
    if (tag instanceof baja.Tag) {
      return tag.getId().getQName() === discoveryTagId;
    } else if (tag instanceof baja.Relation ||
    // BRelation.js, applies to direct relations
    tag instanceof Relation // Relation.js, for implied relations
    ) {
      var tagGroupId = _.result(tag, '$getTagGroupId');
      return tagGroupId && tagGroupId.getQName() === discoveryTagId;
    }
    return false;
  };

  /**
   * @param {baja.Complex} discovery
   *
   * @returns {baja.Tag|baja.Relation|undefined} the Tag/Tag Group that was
   * found to match the given discovery node, or undefined if no such match was found.
   */
  TagUxManager.prototype.$tagExistsButIsHidden = function (discovery) {
    var that = this,
      filteredOutTags = _.invoke(this.$filteredOutTags, 'getSubject');
    return _.find(filteredOutTags, function (tag) {
      return !!that.$tagExists(discovery, tag);
    });
  };

  /**
   * @param {baja.Complex} discovery
   * @param {baja.Tag|baja.Relation} existingTag
   *
   * @returns {boolean}  - true if the discovery item and tag match.
   */
  TagUxManager.prototype.isExisting = function (discovery, existingTag) {
    return this.$tagExists(discovery, existingTag);
  };

  /**
   * clean up after ourselves
   * @returns {Promise}
   */
  TagUxManager.prototype.doDestroy = function () {
    this.jq().removeClass('TagUxManager');
    return Manager.prototype.doDestroy.call(this);
  };

  /**
   * Overrides the default onMainTableDblClicked handler and invokes the EditCommand
   * @inheritDoc
   */
  TagUxManager.prototype.onMainTableDblClicked = function (event, subjects) {
    return this.$getEditCommand().invoke();
  };

  /**
   * Overrides the default logic and enables/disables the Edit and Delete commands
   * @inheritDoc
   */
  TagUxManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var mainTableSelection = selectedSubjects.mainTableSelection;
    var enabled = !(mainTableSelection.length === 0);
    this.$getEditCommand().setEnabled(enabled);
    this.$getDeleteCommand().setEnabled(enabled);
    return Promise.resolve();
  };
  return TagUxManager;
});
