/*
Widget state
============

Our dynamic spandrel widgets so far have received one argument to the spandrel
function: the value being loaded into the widget. But spandrel provides a
second argument: an object describing the current state of the widget.

This object contains properties like:

- writable: is the widget enabled and not readonly?
- properties: the current Widget property values as an object literal
- self: the actual Widget instance (provided so the spandrel function can be an
  arrow function)
- formFactor: the Widget's form factor

See the documentation for a complete list.

An upcoming example will go into much more detail about widget state.
*/

/** @jsx spandrel.jsx */

define([ 'bajaux/spandrel' ], function (spandrel) {

  'use strict';

  const StateWidget = spandrel((value, { writable, properties, self }) => {
    // "writable" will be true if the widget is enabled and not readonly.
    // "enabled" and "readonly" are also individually present,
    // but "writable" is the 99% use case.

    // note that "this" instead of "self" would fail because this is an arrow function.
    const id = self.generateId();
    const { firstName } = properties;

    return [
      <label for={id}>{ firstName }: </label>,
      <input id={id} type="text" readonly={!writable} value={value} />
    ];
  });

  const StateDemo = spandrel([
    <StateWidget properties={{ firstName: 'Moe' }} value="Howard" />,
    <StateWidget properties={{ firstName: 'Larry' }} value="Fine" readonly="true" />,
    <StateWidget properties={{ firstName: 'Curly' }} value="Howard" enabled="false" />
  ]);

  return StateDemo;
});
