/*
  bajaux fires events a developer can listen for...

  - Widget property added/removed
  - Widget property changed
  - Widget destroyed
  - Widget initialized
  - Widget layout
  - Widget modified/unmodified
  - Widget loaded
  - Widget saved
  - Widget validated
  - Widget command changed
  - Widget toggle command selected
  - Widget command invoked
  - Widget command group changed
  
  For more information regarding the events, please see..
  
  module://bajaux/rc/events.js
*/
define([
  'log!nmodule.docDeveloper.examples.bajaux.EventsWidget',
  'bajaux/Widget',
  'bajaux/events',
  'bajaux/commands/Command',
  'bajaux/util/SaveCommand',
  'dialogs' ], function (
  log,
  Widget,
  events,
  Command,
  SaveCommand,
  dialogs) {

  'use strict';

  const logSevere = log.severe.bind(log);
  const MAX_LINES = 10;

  return class EventsWidget extends Widget {
    constructor() {
      super(...arguments);

      const helloWorldCmd = new Command({
        module: "docDeveloper",
        lex: "commands.helloWorld",
        func: () => dialogs.showOk("Clicked the Hello World Command!")
      });

      helloWorldCmd.on(events.command.INVOKE_EVENT, () => {
        this.$append("Event detected from Command - Command Invoked!");
      });

      this.getCommandGroup().add(new SaveCommand(), helloWorldCmd);
    }

    doInitialize(dom) {
      dom.html(`
        <button type="button" class="modify">Set Widget Modified</button>
        <button type="button" class="save">Save Widget</button>
        <div>
          <pre>${ new Array(MAX_LINES + 1).join('\n') }</pre>
        </div>
      `);

      dom.on('click', 'button.modify', () => this.setModified(true));
      dom.on('click', 'button.save', () => this.save());

      dom.on(events.command.INVOKE_EVENT, (e, command) => {
        command.toDisplayName()
          .then((displayName) => this.$append('Invoked command: ' + displayName))
          .catch(logSevere);
      });

      Object.keys(events).forEach((eventName) => {
        const eventValue = events[eventName];
        if (typeof eventValue === 'string') {
          dom.on(eventValue, (e, ed) => this.$append(ed.constructor.name + ': received ' + eventName + ' event'));
        }
      });
    }

    $append(str) {
      // Append some new text to the widget's 'pre' DOM element...
      const pre = this.jq().find("pre");
      const lines = pre.text().split('\n');
      pre.text(lines.concat(str).slice(-MAX_LINES).join('\n'));
      return this;
    }
  };
});
