/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/httpClient/rc/PointPollCommand
 */
define(['baja!', 'Promise', 'bajaux/commands/Command'], function (baja, Promise, Command) {
  'use strict';

  var HTTP_FOLDER_TYPE = "httpClient:HttpClientPointFolder";

  /**
   * Command for calling poll on selected items.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/httpClient/rc/PointPollCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   */
  var PointPollCommand = function PointPollCommand(manager) {
    var that = this;
    Command.call(that, {
      module: 'httpClient',
      lex: 'cmd.http.poll',
      enabled: true,
      func: function func() {
        var promises = [],
          selectedRows = manager.getMainTable().getSelectedRows();
        if (!that.$shouldBeEnabled(manager)) {
          return;
        }
        selectedRows.forEach(function (row) {
          var subject = row.getSubject();
          if (subject.getType().is(HTTP_FOLDER_TYPE)) {
            promises.push(subject.pollAll());
          } else if (subject.getProxyExt()) {
            promises.push(row.getSubject().getProxyExt().send());
          }
        });
        return new baja.comm.Batch().commit(Promise.all(promises));
      }
    });
  };
  PointPollCommand.prototype = Object.create(Command.prototype);
  PointPollCommand.prototype.constructor = PointPollCommand;

  /**
   * @private
   * @param manager manager with which to check whether this should be enabled
   * @returns {boolean} true if the command should be enabled
   */
  PointPollCommand.prototype.$shouldBeEnabled = function (manager) {
    return manager.getMainTable().getSelectedRows().length > 0;
  };
  return PointPollCommand;
});
