function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/httpClient/rc/HttpClientPointManager
 */
define(['Promise', 'nmodule/ndriver/rc/NPointManager', 'nmodule/driver/rc/wb/mgr/PointMgrModel', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/httpClient/rc/PointPollCommand', 'nmodule/httpClient/rc/AddMorePointsCommand', 'css!nmodule/httpClient/rc/httpPointManager'], function (Promise, NPointManager, PointMgrModel, MgrTypeInfo, PointPollCommand, AddMorePointsCommand) {
  'use strict';

  /**
   * A bajaux Point Manager View for the HttpClientDriver
   *
   * @class
   * @extends module:nmodule/ndriver/rc/NPointManager
   * @alias module:nmodule/httpClient/rc/HttpClientPointManager
   *
   */
  var HttpClientPointManager = function HttpClientPointManager(params) {
    NPointManager.call(this, params);
  };
  HttpClientPointManager.prototype = Object.create(NPointManager.prototype);
  HttpClientPointManager.prototype.constructor = HttpClientPointManager;

  /**
   * Returns the set of Commands for the http client point manager.
   *
   * @returns {Array.<module:bajaux/commands/Command>}
   */
  HttpClientPointManager.prototype.makeCommands = function () {
    var _this = this;
    return NPointManager.prototype.makeCommands.apply(this, arguments).then(function (cmds) {
      return cmds.concat([new PointPollCommand(_this), new AddMorePointsCommand(_this)]);
    });
  };

  /**
   * Update the selection state of the buttons on a given manager.
   *
   * @param manager the manager on which to check the button selection state.
   */
  HttpClientPointManager.prototype.updateButtonSelectionState = function (manager) {
    manager.getCommandGroup().getChildren().forEach(function (cmd) {
      if (cmd.$shouldBeEnabled) {
        cmd.setEnabled(cmd.$shouldBeEnabled(manager));
      }
    });
  };

  /**
   * Load the http client point manager view.
   *
   * {baja.Component} comp - the value being loaded into the manager.
   * @returns {Promise}
   */
  HttpClientPointManager.prototype.doLoad = function (comp) {
    var that = this;
    return NPointManager.prototype.doLoad.apply(that, arguments).then(function () {
      that.updateButtonSelectionState(that);
    });
  };

  /**
   * Return `MgrTypeInfo` instances for the default new types for the Http Client point manager.
   *
   * @static
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
   */
  HttpClientPointManager.getDefaultNewTypes = function () {
    var types = [];
    PointMgrModel.addStringPointTypes(true, types);
    return MgrTypeInfo.make(types);
  };

  /**
   * Make the MgrModel for this Point Manager.
   *
   * @param {baja.Component} component - the NPointDeviceExt or NPointFolder that the Point Manager will display.
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
   */
  HttpClientPointManager.prototype.makeModel = function (component) {
    return Promise.all([NPointManager.prototype.makeModel.apply(this, arguments), HttpClientPointManager.getDefaultNewTypes()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        model = _ref2[0],
        overrideNewTypes = _ref2[1];
      model.$newTypes = overrideNewTypes;
      return model;
    });
  };

  /**
   * In addtion to enabling/disabling the default commands, this enables the commands specific to
   *  this manager.
   * @inheritDoc
   */
  HttpClientPointManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var _this2 = this;
    return NPointManager.prototype.onTableSelectionChanged.call(this, selectedSubjects).then(function () {
      _this2.updateButtonSelectionState(_this2);
    });
  };
  return HttpClientPointManager;
});
