/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ToggleButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */

/**
 * @private
 * @module mobile/px/widgets/ToggleButton
 */
define(['baja!', 'Promise', 'mobile/px/widgets/Button'], function (baja, Promise, Button) {
  "use strict";

  var logError = baja.error;

  /**
   * The Widget that represents Niagara's 'bajaui:ToggleButton' and 'bajaui:CheckBox' Type.
   *
   * @private
   * @class
   * @alias module:mobile/px/widgets/ToggleButton
   * @extends module:mobile/px/widgets/Button
   */
  var ToggleButton = function ToggleButton() {
    Button.apply(this, arguments);
  };
  ToggleButton.prototype = Object.create(Button.prototype);
  ToggleButton.prototype.constructor = ToggleButton;

  /**
   * Handle a UI Widget event.
   */
  ToggleButton.prototype.doHandleEvent = function (eventName) {
    var _this = this;
    switch (eventName) {
      case 'click':
        this.set({
          slot: 'selected',
          value: !this.get('selected')
        }).then(function () {
          return _this.update(function (prop) {
            return prop === 'selected';
          });
        })["catch"](logError);
        break;
    }
    return Button.prototype.doHandleEvent.apply(this, arguments);
  };

  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */
  ToggleButton.prototype.doUpdate = function (hasUpdate) {
    var _this2 = this;
    return Promise.resolve(Button.prototype.doUpdate.apply(this, arguments)).then(function () {
      if (hasUpdate("selected")) {
        _this2.$dom.css("border", _this2.getSelected() ? "2px solid black" : "2px solid white");
      }
    });
  };
  return ToggleButton;
});
