/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview GenericFieldEditor class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'Promise', 'bajaux/mixin/batchSaveMixin', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Promise, batchSaveMixin, Widget) {
  "use strict";

  var callSuper = baja.callSuper,
    COMMIT_READY = batchSaveMixin.COMMIT_READY;

  /**
   * @class GenericFieldEditor
   *
   * The Widget that represents Niagara's 'kitPx:GenericFieldEditor' Type.
   *
   * @name GenericFieldEditor
   * @extends Widget
   */
  function GenericFieldEditor() {
    callSuper(GenericFieldEditor, this, arguments);
    this.$fieldEditor = null;
  }
  baja.subclass(GenericFieldEditor, Widget);

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */
  GenericFieldEditor.prototype.load = function (dom) {
    this.$dom = $('<div class="widgetFieldEditor" />').appendTo(dom);
  };

  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */
  GenericFieldEditor.prototype.doUpdate = function (hasUpdate) {
    if (hasUpdate("enabled") && this.$fieldEditor) {
      this.$fieldEditor.setReadonly(!this.isEnabled());
    }
  };

  /**
   * Return true if the Widget (and all parent Widgets) are enabled.
   *
   * @return {Boolean}
   */
  GenericFieldEditor.prototype.isEnabled = function () {
    // Check whether we can read the given Slot
    var enabled = true;
    this.getSlots().is("workbench:WbFieldEditorBinding").eachValue(function (binding) {
      var target = binding.getTarget(),
        slot;
      if (target) {
        if (target.slot) {
          slot = target.slot;
        }
        if (slot && (slot.getFlags() & baja.Flags.READONLY) === baja.Flags.READONLY) {
          enabled = false;
        }
      }

      // Return true because we don't want to iterate through anything else
      return true;
    });

    // If enabled, call Super isEnabled method
    return enabled ? callSuper("isEnabled", GenericFieldEditor, this, arguments) : enabled;
  };

  /**
   * Return whether the Widget is modified or not.
   *
   * @returns {Boolean}
   */
  GenericFieldEditor.prototype.isModified = function () {
    return this.$fieldEditor && this.$fieldEditor.isModified();
  };

  /**
   * Clear the modified state of the Widget.
   */
  GenericFieldEditor.prototype.clearModified = function () {
    if (this.$fieldEditor) {
      this.$fieldEditor.setModified(false, {
        silent: true
      });
    }
  };

  /**
   * Save the Widget
   *
   * @param {Object} [params]
   * @param {baja.comm.Batch} [params.batch]
   * @param {Function} [params.progressCallback]
   */
  GenericFieldEditor.prototype.save = function (params) {
    var batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      fe = this.$fieldEditor;
    if (fe && fe.isModified()) {
      var prom = fe.save({
        batch: batch,
        progressCallback: progressCallback
      });
      if (progressCallback && !fe.hasMixIn('batchSave')) {
        progressCallback(COMMIT_READY);
      }
      return prom;
    }
  };

  /**
   * Validate the widget's field editor
   */
  GenericFieldEditor.prototype.validate = function () {
    var fe = this.$fieldEditor;
    if (fe) {
      return fe.validate();
    } else {
      return Promise.resolve();
    }
  };
  return GenericFieldEditor;
});
