function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ForwardButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */

/**
 * @private
 * @module mobile/px/widgets/ForwardButton
 */
define(['baja!', 'lex!mobile', 'mobile/px/util.px.mobile', 'mobile/px/widgets/Button'], function (baja, lexs, pxUtilMobile, Button) {
  "use strict";

  var saveModifyQuestion = pxUtilMobile.saveModifyQuestion,
    _lexs = _slicedToArray(lexs, 1),
    mobileLex = _lexs[0];

  /**
   * The Widget that represents Niagara's 'kitPx:ForwardButton' Type.
   * @private
   * @class
   * @alias module:mobile/px/widgets/ForwardButton
   * @extends module:mobile/px/widgets/Button
   */
  var ForwardButton = function ForwardButton() {
    Button.apply(this, arguments);
  };
  ForwardButton.prototype = Object.create(Button.prototype);
  ForwardButton.prototype.constructor = ForwardButton;

  /**
   * Called when the widget is first loaded.
   */
  ForwardButton.prototype.load = function () {
    Button.prototype.load.apply(this, arguments);

    // a ForwardButton is always enabled and always has text "Forward".
    // WB only enables it if there is history to move forward to; for
    // security, JS will not allow us see this info, so always enable and it
    // will just do nothing if there is no forward history
    this.setEnabled(true);
    this.setText(mobileLex.get('forward'));
  };

  /**
   * Handle a UI Widget event.
   */
  ForwardButton.prototype.doHandleEvent = function (eventName) {
    saveModifyQuestion(this, function () {
      return window.history.forward();
    });

    // Return true so the event doesn't filter down to the bindings
    return true;
  };
  return ForwardButton;
});
