/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Size class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!'], function (baja) {
  "use strict";

  var notCurrentlySupported = "Not currently supported",
    sizeCache = {};

  /**
   * @class Size.
   * 
   * This is currently a partial implementation of Niagara's 'gx:Size' Type.
   * 
   * When creating a Simple, always use the 'make' method instead of creating a new Object.
   *
   * @name Size
   * @extends baja.Simple
   */
  function Size(w, h, str) {
    var that = this;
    Size.$super.apply(that, arguments);
    that.$w = w;
    that.$h = h;
    that.$str = str;
  }
  baja.subclass(Size, baja.Simple);

  /**
   * Make Size.
   */
  Size.make = function (obj) {
    throw new Error(notCurrentlySupported);
  };

  /**
   * Make Size.
   */
  Size.prototype.make = function (obj) {
    return Size.make.apply(Size, arguments);
  };

  /**
   * Decode Size from a String.
   *
   * @param {String} str
   * @return {Size}
   */
  Size.prototype.decodeFromString = function (str) {
    // If we have a simple cached then use it.
    if (sizeCache[str]) {
      return sizeCache[str];
    }
    var res, w, h, size;
    res = /^([^,]+),([^,]+)$/.exec(str);
    w = parseFloat(res[1]);
    h = parseFloat(res[2]);
    size = new Size(w, h, str);

    // Cache the result
    sizeCache[str] = size;
    return size;
  };

  /**
   * Encode the Size to a String.
   *
   * @return {String}
   */
  Size.prototype.encodeToString = function () {
    return this.$str;
  };

  /**
   * Default Size instance.
   */
  Size.DEFAULT = Size.NULL = new Size(0, 0, "0,0");

  /**
   * Return the width.
   *
   * @returns {Number}
   */
  Size.prototype.getWidth = function () {
    return this.$w;
  };

  /**
   * Return the height.
   *
   * @returns {Number}
   */
  Size.prototype.getHeight = function () {
    return this.$h;
  };
  return Size;
});
