/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview INumericToSimple class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";

  /**
   * @class INumeric To Simple Converter.
   * 
   * A Component that represents a Niagara 'converters:BINumericToSimple' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BINumeric like their Java counterparts.
   *
   * @name INumericToSimple
   * @extends Converter
   */
  function INumericToSimple() {
    baja.callSuper(INumericToSimple, this, arguments);
  }
  baja.subclass(INumericToSimple, Converter);

  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {baja.Simple} simple value read from the converter's
   * `NumericToSimpleMap`, depending on the number read from the converted
   * value
   */
  INumericToSimple.prototype.convert = function (from, to, target) {
    // Get the Simple from the map
    var val = Number.getNumberFromINumeric(from),
      simple = this.getMap().get(val);
    if (simple === null) {
      // Default back if we can't find anything
      simple = to;
    }
    return simple;
  };
  return INumericToSimple;
});
