/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanJvln;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.pciCards.BPciCard;
import com.tridium.platHwScan.pciCards.BPciSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="LAN1", type="BEthernetPort", defaultValue="new BEthernetPort(\"en0\")", flags=1), @NiagaraProperty(name="LAN2", type="BEthernetPort", defaultValue="new BEthernetPort(\"en1\")", flags=1), @NiagaraProperty(name="COM1", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs232, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM2", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="optionSlot1", type="BOptionSlot", defaultValue="new BOptionSlot(1)", flags=1), @NiagaraProperty(name="optionSlot2", type="BOptionSlot", defaultValue="new BOptionSlot(2)", flags=1), @NiagaraProperty(name="pciSlot", type="BPciSlot", defaultValue="new BPciSlot()", flags=1)})
public class BJvlnBoard
extends BBaseBoard {
    @Generated
    public static final Property LAN1 = BJvlnBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    @Generated
    public static final Property LAN2 = BJvlnBoard.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    @Generated
    public static final Property COM1 = BJvlnBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM2 = BJvlnBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property optionSlot1 = BJvlnBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    @Generated
    public static final Property optionSlot2 = BJvlnBoard.newProperty((int)1, (BValue)new BOptionSlot(2), null);
    @Generated
    public static final Property pciSlot = BJvlnBoard.newProperty((int)1, (BValue)new BPciSlot(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJvlnBoard.class);
    private static final Lexicon lex = Lexicon.make(BJvlnBoard.class);
    private static final String BASE_BOARD_CODE = "04";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 5;
    private static final int HARDWARE_REF_COUNT = 12;

    @Generated
    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    @Generated
    public void setLAN1(BEthernetPort v) {
        this.set(LAN1, (BValue)v, null);
    }

    @Generated
    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    @Generated
    public void setLAN2(BEthernetPort v) {
        this.set(LAN2, (BValue)v, null);
    }

    @Generated
    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    @Generated
    public void setCOM1(BPort v) {
        this.set(COM1, (BValue)v, null);
    }

    @Generated
    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    @Generated
    public void setCOM2(BPort v) {
        this.set(COM2, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    @Generated
    public void setOptionSlot1(BOptionSlot v) {
        this.set(optionSlot1, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot2() {
        return (BOptionSlot)this.get(optionSlot2);
    }

    @Generated
    public void setOptionSlot2(BOptionSlot v) {
        this.set(optionSlot2, (BValue)v, null);
    }

    @Generated
    public BPciSlot getPciSlot() {
        return (BPciSlot)this.get(pciSlot);
    }

    @Generated
    public void setPciSlot(BPciSlot v) {
        this.set(pciSlot, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array<String> optCardCodes, boolean simulation) {
        this.setSimulation(simulation);
        this.setProductModel(lex.getText(Nre.getHostModel().toUpperCase()));
        this.initializeStandardPorts(simulation);
        this.nextSerialPort = 5;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        this.configureOptionSlot(this.getOptionSlot1(), (String)optCardCodes.get(0), (String)optCardCodes.get(1));
        this.configureOptionSlot(this.getOptionSlot2(), (String)optCardCodes.get(2), (String)optCardCodes.get(3));
        this.configurePciSlot();
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        Vector<BHardwareRef> v = new Vector<BHardwareRef>();
        block13: for (int i = 1; i <= 12; ++i) {
            switch (i) {
                case 1: 
                case 2: {
                    BOptionSlot slot = i == 1 ? this.getOptionSlot1() : this.getOptionSlot2();
                    v.addElement(this.makeSlotRef(i, slot));
                    if (slot.isEmpty()) continue block13;
                    BOptionCard optionCard = (BOptionCard)slot.getContents();
                    optionCard.lease(1);
                    BPort[] cardPorts = (BPort[])optionCard.getChildren(BPort.class);
                    for (int j = 0; j < cardPorts.length; ++j) {
                        v.addElement(this.makePortRef(i, j + 1, cardPorts[j]));
                    }
                    continue block13;
                }
                case 3: {
                    v.addElement(this.makeJumperRef(i));
                    continue block13;
                }
                case 4: {
                    BPciSlot pciSlot = this.getPciSlot();
                    BHardwareRef ref = new BHardwareRef();
                    ref.setReference(String.valueOf(i));
                    ref.setLocation(lex.getText("HardwareRef.pciSlot"));
                    BValue contents = pciSlot.getContents();
                    if (pciSlot.isEmpty()) {
                        ref.setDescription(BHardwareScanService.lex.getText(BHwScanStatusEnum.empty.getTag()));
                    } else {
                        ref.setDescription(((BPciCard)contents).getDescription());
                    }
                    v.addElement(ref);
                    continue block13;
                }
                case 5: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM2()));
                    continue block13;
                }
                case 6: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM1()));
                    continue block13;
                }
                case 7: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.externalBatteryBackup")));
                    continue block13;
                }
                case 8: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.contactInputs")));
                    continue block13;
                }
                case 9: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN1()));
                    continue block13;
                }
                case 10: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN2()));
                    continue block13;
                }
                case 11: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.electricalGround")));
                    continue block13;
                }
                case 12: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.antennaKnockouts")));
                }
            }
        }
        return v;
    }

    public String getImagesDirectory() {
        return lex.getText(IMAGES_DIR);
    }

    public String getView(BObject v) {
        return lex.getText(VIEW);
    }

    private void configurePciSlot() {
        BPciSlot pciSlot = this.getPciSlot();
        try {
            Hashtable cardCatalog = BPciCard.getCardCatalog();
            Enumeration cards = cardCatalog.elements();
            while (cards.hasMoreElements()) {
                BPciCard cardTemplate = (BPciCard)cards.nextElement();
                File locator = new File(cardTemplate.getLocator());
                if (!locator.exists()) continue;
                pciSlot.addCard((BPciCard)cardTemplate.newCopy(true));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pciSlot.isEmpty()) {
            pciSlot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    public void configureOptionSlot(BOptionSlot slot, String functionCode1, String functionCode2) {
        slot.removeAll();
        if (!functionCode1.equalsIgnoreCase("FF") || !functionCode2.equalsIgnoreCase("FF")) {
            BOptionCard cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2));
            if (cardTemplate == null) {
                slot.addCard(new BOptionCard(BHardwareScanService.lex.getText("unknownOptionCard", new Object[]{functionCode1, functionCode2})));
            } else {
                BOptionCard optionCard = (BOptionCard)cardTemplate.newCopy(true);
                slot.addCard(optionCard);
                BPort[] ports = optionCard.getPorts();
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] == null) continue;
                    BPort port = ports[i];
                    if (optionCard.getUsesCom()) {
                        optionCard.rename(optionCard.getProperty(port.getName()), port.getPrefix() + (slot.getSlotNumber() + 2), null);
                    } else {
                        optionCard.rename(optionCard.getProperty(port.getName()), this.makePortName(i + 1, port.getPrefix()), null);
                    }
                    if (this.simulation) continue;
                    port.initOwnerAndStatus();
                }
            }
        }
        if (slot.isEmpty()) {
            slot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    private void initializeStandardPorts(boolean simulation) {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + "1")), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + "2")), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + "1")), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + "2")), null);
        if (!simulation) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
        }
    }
}

