/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg.videoDriver;

import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.videoStream.IVideoImagePainter;
import com.tridium.videoDriver.ui.videoStream.decoder.VideoDecoder;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Size;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import org.baja.ffmpeg.FfmpegLexicon;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.enums.BFfmpegLogLevel;
import org.baja.ffmpeg.enums.BPixelFormatEnum;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodec;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodecContext;
import org.baja.ffmpeg.libavcodec.FfmpegAVFrame;
import org.baja.ffmpeg.libavcodec.FfmpegAVPacket;
import org.baja.ffmpeg.libavcodec.FfmpegAvCodecUtil;
import org.baja.ffmpeg.swscale.FfmpegSwScaleUtil;
import org.baja.ffmpeg.swscale.FfmpegSwsContext;

public abstract class FfmpegVideoDecoder
extends VideoDecoder
implements IVideoImagePainter {
    public static final int SHOW_FFMPEG_LOGO_WITHOUT_FADE_DURATION = 2000;
    public static final int SHOW_FFMPEG_LOGO_WITH_FADE_DURATION = 2000;
    protected long ticksWhenFfmpegLogoFirstShown = -1L;
    protected FfmpegAVCodecContext avDecoderContext;
    protected FfmpegAVCodec avDecoderCodec;
    protected FfmpegAVFrame mostRecentRawDecodedFfmpegFrame;
    protected FfmpegAVPacket ffmpegAVPacket;
    protected FfmpegSwsContext swsContext;
    protected int[] pixelBufferData;
    protected BCodecIdEnum decoderCodecToUse = null;
    protected BPixelFormatEnum destPixelFmt = BPixelFormatEnum.ffmpeg_PIX_FMT_BGRA;
    protected int videoWidth = -1;
    protected int videoHeight = -1;
    public static final int FF_INPUT_BUFFER_PADDING_SIZE = 8;
    public static final byte[] FF_INPUT_BUFFER_PADDING = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final Logger log = Logger.getLogger("ffmpeg.videoDecoder");
    public static final Logger nativeLog = Logger.getLogger("ffmpeg.nativeDecoder");
    public static final BImage FFMPEG_DISCONNECTED_IMAGE = BImage.make((String)"module://ffmpeg/images/VideoStreamDisconnected.png");
    private Object lock = new Object();
    public static final int FFMPEG_LOGO_BACKGROUND_RED = 50;
    public static final int FFMPEG_LOGO_FOREGROUND_RED = 255;
    public static final int FFMPEG_LOGO_BACKGROUND_GREEN = 50;
    public static final int FFMPEG_LOGO_FOREGROUND_GREEN = 255;
    public static final int FFMPEG_LOGO_BACKGROUND_BLUE = 50;
    public static final int FFMPEG_LOGO_FOREGROUND_BLUE = 255;
    public static final int FFMPEG_LOGO_INITIAL_BACKGROUND_ALPHA = 50;
    public static final int FFMPEG_LOGO_INITIAL_FOREGROUND_ALPHA = 50;

    protected FfmpegVideoDecoder() {
        this.decoderCodecToUse = null;
    }

    protected FfmpegVideoDecoder(BCodecIdEnum decoderCodecToUse) {
        this.decoderCodecToUse = decoderCodecToUse;
    }

    protected void padBufferPerFfmpegDocumentationBeforeCallingAvCodecDecodeVideo(ByteBuffer frameBuffer) {
        frameBuffer.write(FF_INPUT_BUFFER_PADDING);
    }

    protected void autoDetermineVideoWidthAndHeight() {
        Size decodedFrameSize = FfmpegAvCodecUtil.avcodec_get_dimensions(this.avDecoderContext);
        this.videoWidth = (int)decodedFrameSize.width();
        this.videoHeight = (int)decodedFrameSize.height();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeFrame(VidFrame vf) throws Exception {
        boolean[] frameFinished = new boolean[1];
        ByteBuffer nextFrameDataBuffer = vf.rawData;
        int frameSize = nextFrameDataBuffer.getLength();
        Object object = this.lock;
        synchronized (object) {
            if (this.avDecoderContext.isNull() || this.mostRecentRawDecodedFfmpegFrame.isNull()) {
                vf.image = BImage.DEFAULT;
                return;
            }
            int retVal = FfmpegAvCodecUtil.avcodec_decode_video(this.avDecoderContext, this.mostRecentRawDecodedFfmpegFrame, this.ffmpegAVPacket, frameFinished, nextFrameDataBuffer.getBytes(), frameSize);
            if (log.isLoggable(Level.FINE)) {
                log.fine("retVal = " + retVal + " frameFinished = " + frameFinished[0]);
            }
            if (!frameFinished[0]) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Frame not fully finished. Sending next frame data");
                }
                vf.image = null;
                return;
            }
            if (this.videoWidth == -1 || this.videoHeight == -1) {
                this.finishInitializing();
            }
            if (this.swsContext.isNull() || this.mostRecentRawDecodedFfmpegFrame.isNull() || this.pixelBufferData == null) {
                vf.image = BImage.DEFAULT;
                return;
            }
            retVal = FfmpegSwScaleUtil.sws_Scale(this.swsContext, this.mostRecentRawDecodedFfmpegFrame, this.pixelBufferData, this.videoWidth, this.videoHeight, this.destPixelFmt);
            if (retVal < 0) {
                throw new IllegalStateException("Unable to convert frame to " + this.destPixelFmt + " retVal=" + retVal + ").");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Got image pixels!!!");
            }
        }
        if (!frameFinished[0]) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("!frameFinished");
            }
            vf.image = null;
            return;
        }
        BImage nextImage = BImage.make((double)this.videoWidth, (double)this.videoHeight);
        nextImage.setPixels(this.pixelBufferData);
        vf.image = nextImage;
    }

    protected void initDecoder() {
        if (nativeLog.isLoggable(Level.FINE)) {
            FfmpegAvCodecUtil.setLogLevel(BFfmpegLogLevel.debug);
        } else {
            FfmpegAvCodecUtil.setLogLevel(BFfmpegLogLevel.quiet);
        }
        this.avDecoderCodec = FfmpegAvCodecUtil.avcodec_find_decoder(this.decoderCodecToUse);
        if (this.avDecoderCodec.isNull()) {
            throw new IllegalStateException("Unable to allocate FFmpeg decoder codec.");
        }
        this.avDecoderContext = FfmpegAvCodecUtil.avcodec_alloc_context(this.avDecoderCodec);
        if (this.avDecoderContext.isNull()) {
            throw new IllegalStateException("Unable to allocate FFmpeg decoder codec context.");
        }
        int result = FfmpegAvCodecUtil.avcodec_open(this.avDecoderContext, this.avDecoderCodec);
        if (result < 0) {
            throw new IllegalStateException("Unable to open decoder codec " + this.decoderCodecToUse + ". Return code " + result);
        }
    }

    protected void initSwsContext() {
        this.swsContext = FfmpegSwScaleUtil.sws_getContext(this.videoWidth, this.videoHeight, BPixelFormatEnum.ffmpeg_PIX_FMT_YUV420P, this.videoWidth, this.videoHeight, this.destPixelFmt);
        if (this.swsContext == null || this.swsContext.isNull()) {
            throw new IllegalStateException("Unable to initialize FFmpeg swsContext.");
        }
    }

    protected void initRawDecodedFfmpegFrame() {
        this.mostRecentRawDecodedFfmpegFrame = FfmpegAvCodecUtil.avcodec_alloc_frame();
        if (this.mostRecentRawDecodedFfmpegFrame.isNull()) {
            throw new IllegalStateException("Unable to allocate FFmpeg raw decode frame.");
        }
    }

    protected void initAVPacket() {
        this.ffmpegAVPacket = FfmpegAvCodecUtil.av_packet_alloc();
        if (this.ffmpegAVPacket == null || this.ffmpegAVPacket.isNull()) {
            throw new IllegalStateException("Unable to allocate ffmpegAVPacket.");
        }
    }

    protected void finishInitializing() {
        this.autoDetermineVideoWidthAndHeight();
        this.initSwsContext();
        this.initPixelBuffer();
    }

    protected void initPixelBuffer() {
        int pixelBufferSizeInInts = this.videoWidth * this.videoHeight;
        this.pixelBufferData = new int[pixelBufferSizeInInts];
    }

    public void init(BIVideoSource videoSource, BIVideoPlayer videoPlayer, BRelTime stopDecodingTimeout, IVideoSession videoSession) {
        super.init(videoSource, videoPlayer, stopDecodingTimeout, videoSession);
        if (this.decoderCodecToUse != null) {
            this.initDecoder();
        }
        this.initRawDecodedFfmpegFrame();
        this.initAVPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDecoding(WaitForStopDecoding stopMonitor) {
        super.stopDecoding(stopMonitor);
        Object object = this.lock;
        synchronized (object) {
            if (!this.avDecoderContext.isNull()) {
                FfmpegAvCodecUtil.avcodec_free_context(this.avDecoderContext);
                if (this.ffmpegAVPacket != null && !this.ffmpegAVPacket.isNull() && this.ffmpegAVPacket.getNativeHandle() != 0L) {
                    FfmpegAvCodecUtil.av_packet_free(this.ffmpegAVPacket.getNativeHandle());
                }
            }
            if (!this.mostRecentRawDecodedFfmpegFrame.isNull()) {
                FfmpegAvCodecUtil.av_frame_free(this.mostRecentRawDecodedFfmpegFrame);
            }
            if (!this.swsContext.isNull()) {
                FfmpegSwScaleUtil.sws_freeContext(this.swsContext);
            }
        }
    }

    public static void readBytesFromInputStream(Logger log, InputStream input, byte[] intermediate, int numBytes, Object dest) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Reading " + numBytes + " data bytes");
        }
        int totalBytesRead = 0;
        int remainingBytesToRead = numBytes;
        while (remainingBytesToRead > 0) {
            int numToRead = remainingBytesToRead < intermediate.length ? remainingBytesToRead : intermediate.length;
            int bytesJustRead = input.read(intermediate, 0, numToRead);
            if (bytesJustRead == -1) {
                throw new EOFException();
            }
            if (bytesJustRead == 0) continue;
            totalBytesRead += bytesJustRead;
            if (numBytes != Integer.MAX_VALUE) {
                remainingBytesToRead -= bytesJustRead;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("<HexDump - Follows>");
                ByteArrayUtil.hexDump((byte[])intermediate, (int)0, (int)bytesJustRead);
            }
            if (dest == null) continue;
            if (dest instanceof ByteBuffer) {
                ((ByteBuffer)dest).write(intermediate, 0, bytesJustRead);
                continue;
            }
            if (dest instanceof OutputStream) {
                ((OutputStream)dest).write(intermediate, 0, bytesJustRead);
                ((OutputStream)dest).flush();
                continue;
            }
            if (!(dest instanceof PrintWriter)) continue;
            ByteArrayUtil.hexDump((PrintWriter)((PrintWriter)dest), (byte[])intermediate, (int)0, (int)bytesJustRead);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished reading " + totalBytesRead + " data bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImage(Graphics g, BWidget videoPlayer) {
        boolean showFfmpegLogo = false;
        int ffmpegLogoBackgroundAlpha = 50;
        int ffmpegLogoForegroundAlpha = 50;
        Property hasPaintedFfmpegLogoOnVideoPlayerProp = videoPlayer.getProperty("hasPaintedFfmpegLogoOnVideoPlayer");
        if (hasPaintedFfmpegLogoOnVideoPlayerProp == null) {
            hasPaintedFfmpegLogoOnVideoPlayerProp = videoPlayer.add("hasPaintedFfmpegLogoOnVideoPlayer", (BValue)BBoolean.TRUE);
            showFfmpegLogo = true;
            ffmpegLogoBackgroundAlpha = 50;
            ffmpegLogoForegroundAlpha = 50;
        } else {
            long clockTicks = Clock.ticks();
            if (this.ticksWhenFfmpegLogoFirstShown == -1L) {
                this.ticksWhenFfmpegLogoFirstShown = 0L;
                showFfmpegLogo = false;
            } else if (clockTicks - this.ticksWhenFfmpegLogoFirstShown > 4000L) {
                showFfmpegLogo = false;
            } else if (clockTicks - this.ticksWhenFfmpegLogoFirstShown > 2000L) {
                showFfmpegLogo = true;
                long remainingTimeToFade = this.ticksWhenFfmpegLogoFirstShown + 2000L + 2000L - clockTicks;
                double remainingAlphaPercent = (double)remainingTimeToFade / 2000.0;
                ffmpegLogoBackgroundAlpha = (int)(remainingAlphaPercent * 50.0);
                ffmpegLogoForegroundAlpha = (int)(remainingAlphaPercent * 50.0);
            } else {
                showFfmpegLogo = true;
                ffmpegLogoBackgroundAlpha = 50;
                ffmpegLogoForegroundAlpha = 50;
            }
        }
        double playerWidth = videoPlayer.getWidth();
        double playerHeight = videoPlayer.getHeight();
        if (showFfmpegLogo) {
            String decodingComplimentsOfFfmpeg;
            BBrush ffmpegLogoBackground = BBrush.makeSolid((BColor)BColor.make((int)50, (int)50, (int)50, (int)ffmpegLogoBackgroundAlpha));
            BBrush ffmpegLogoForeground = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)ffmpegLogoForegroundAlpha));
            if (this.ticksWhenFfmpegLogoFirstShown == -1L) {
                this.ticksWhenFfmpegLogoFirstShown = Clock.ticks();
            }
            if ((decodingComplimentsOfFfmpeg = FfmpegLexicon.LEX.get("decodingComplimentsOfFfmpeg", null)) != null && decodingComplimentsOfFfmpeg.length() > 0) {
                try {
                    g.push();
                    BVideoPlayer.paintMessage((Graphics)g, (String)decodingComplimentsOfFfmpeg, (int)Integer.MIN_VALUE, (int)80, (double)playerWidth, (double)playerHeight, (BBrush)ffmpegLogoBackground, (BBrush)ffmpegLogoForeground);
                }
                finally {
                    g.pop();
                }
            }
        }
    }
}

