/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.ui.point;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import com.tridiumemea.micros.ui.point.BMicrosPointManager;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.Lexicon;

final class MicrosPointManagerSyncDialog {
    private static final BImage RUNNING_ICON = BImage.make((String)"module://icons/x16/job/running.png");
    private static final BImage SUCCESS_ICON = BImage.make((BIcon)BIcon.make((String)"module://icons/x16/job/success.png"));
    private static final BImage FAILED_ICON = BImage.make((BIcon)BIcon.make((String)"module://icons/x16/job/failed.png"));
    private static final BImage INFO_ICON = BImage.make((BIcon)BIcon.std((String)"info.png"));
    private static final BImage WARNING_ICON = BImage.make((BIcon)BIcon.std((String)"warning.png"));
    static final BImage HELP_ICON = BImage.make((BIcon)BIcon.std((String)"questionMark.png"));
    private static final String EMPTY_COLUMN = " ";
    private static final String NEXT_BLANK_SLOT = "blank?";
    private static final BFont gridHeaderFont = BFont.make((BFont)BFont.DEFAULT, (int)1);
    private static final Lexicon lex = BMicrosPointManager.lex;
    private static final String TIMESTAMP = lex.getText("header.timestamp");
    private static final String ACTIVITY = lex.getText("header.activity");
    private static final String DETAIL = lex.getText("header.detail");
    private static final String PROPERTY = lex.getText("header.property");
    private static final String VALUE = lex.getText("header.value");
    private static final String nextSlotIcon = "icon?";
    private static final String nextSlotTimestamp = "timestamp?";
    private static final String nextSlotActivity = "activity?";
    private static final String nextSlotDetail = "detail?";
    private static final String nextSlotName = "name?";
    private static final String nextSlotValue = "value?";
    private static final Lexicon lexRt = Lexicon.make(BMicrosNetwork.class);
    private static final String SERVER_KEY = "ds.job.source.server";
    private static final String LOCAL_KEY = "ds.job.source.local";

    private MicrosPointManagerSyncDialog() {
    }

    static void showWindow(BJob job, int width, int height) {
        BTabbedPane tp = new BTabbedPane();
        BEdgePane ep = new BEdgePane();
        ep.setCenter((BWidget)tp);
        BGridPane summaryGridPane = MicrosPointManagerSyncDialog.getSummaryGridPane();
        MicrosPointManagerSyncDialog.populateSummaryData(summaryGridPane, job);
        String nextLpSlot = "lp?";
        BScrollPane summaryTabSp = MicrosPointManagerSyncDialog.getScrollPane(summaryGridPane);
        BLabelPane summaryLabelPane = new BLabelPane(lex.getText("ds.tab.summary"), (BWidget)summaryTabSp);
        tp.add(nextLpSlot, (BValue)summaryLabelPane);
        BGridPane detailGridPane = MicrosPointManagerSyncDialog.getDetailGridPane();
        MicrosPointManagerSyncDialog.populateDetailData(detailGridPane, job);
        BScrollPane detailTabSp = MicrosPointManagerSyncDialog.getScrollPane(detailGridPane);
        BLabelPane detailPane = new BLabelPane(new BLabel(lex.getText("ds.tab.detail")), (BWidget)detailTabSp);
        tp.add(nextLpSlot, (BValue)detailPane);
        BFrame f = new BFrame();
        f.setScreenBounds(100.0, 100.0, (double)width, (double)height);
        BDialog.open((BWidget)f, (String)lex.getText("ds.title"), (Object)ep, (int)1);
    }

    private static BGridPane getDetailGridPane() {
        BGridPane gp = MicrosPointManagerSyncDialog.getEmptyGridPane(4);
        gp.setColumnGap(10.0);
        gp.add("IconHeader", (BValue)new BLabel(EMPTY_COLUMN, gridHeaderFont));
        gp.add("TSHeader", (BValue)new BLabel(TIMESTAMP, gridHeaderFont));
        gp.add("ValueHeader", (BValue)new BLabel(ACTIVITY, gridHeaderFont));
        gp.add("DetailHeader", (BValue)new BLabel(DETAIL, gridHeaderFont));
        return gp;
    }

    private static BGridPane getSummaryGridPane() {
        BGridPane gp = MicrosPointManagerSyncDialog.getEmptyGridPane(2);
        gp.setRowGap(6.0);
        gp.setColumnGap(90.0);
        gp.add("PropertyHeader", (BValue)new BLabel(PROPERTY, gridHeaderFont));
        gp.add("ValueHeader", (BValue)new BLabel(VALUE, gridHeaderFont));
        return gp;
    }

    private static BGridPane getEmptyGridPane(int cols) {
        BGridPane gp = new BGridPane();
        gp.setColumnCount(cols);
        gp.setValign(BValign.top);
        IntStream.range(0, cols).forEach($ -> gp.add(NEXT_BLANK_SLOT, (BValue)new BLabel(EMPTY_COLUMN)));
        return gp;
    }

    private static BImage chooseLogItemImage(int itemId) {
        switch (itemId) {
            case 0: {
                return INFO_ICON;
            }
            case 3: {
                return SUCCESS_ICON;
            }
            case 4: {
                return FAILED_ICON;
            }
            case 2: {
                return WARNING_ICON;
            }
            case 1: {
                return RUNNING_ICON;
            }
        }
        return null;
    }

    private static void populateDetailData(BGridPane gp, BJob job) {
        JobLog log = null;
        try {
            log = JobLog.decode((String)job.readLog().getString());
        }
        catch (Exception e) {
            BMicrosPointManager.LOG.warning("Error fetching JobLog \n" + Arrays.toString(e.getStackTrace()));
        }
        if (log == null) {
            gp.add("err?", (BValue)new BLabel("Error reading jobLog"));
            return;
        }
        for (int p = 0; p < log.size(); ++p) {
            JobLogItem jobLogItem = log.getItem(p);
            BAbsTime timestamp = jobLogItem.getTimestamp();
            String message = jobLogItem.getMessage();
            String detail = jobLogItem.getDetails();
            int itemId = jobLogItem.getId();
            BImage imageToUse = MicrosPointManagerSyncDialog.chooseLogItemImage(itemId);
            if (imageToUse == null) {
                gp.add(nextSlotIcon, (BValue)new BLabel(EMPTY_COLUMN));
            } else {
                gp.add(nextSlotIcon, (BValue)new BLabel(imageToUse));
            }
            gp.add(nextSlotTimestamp, (BValue)new BLabel(timestamp.toTimeString(null)));
            gp.add(nextSlotActivity, (BValue)new BLabel(message));
            if (detail == null) {
                gp.add(nextSlotDetail, (BValue)new BLabel(EMPTY_COLUMN));
                continue;
            }
            gp.add(nextSlotDetail, (BValue)new BLabel(detail));
        }
    }

    private static void populateSummaryData(BGridPane gp, BJob job) {
        Property[] jp;
        for (Property p : jp = job.getPropertiesArray()) {
            BLabel value;
            gp.add(nextSlotName, (BValue)new BLabel(p.getDefaultDisplayName(null)));
            if (p.equals(BMicrosDatabaseSyncJob.source)) {
                boolean v = ((BIBoolean)job.get(p)).getBoolean();
                String sourceKey = v ? SERVER_KEY : LOCAL_KEY;
                value = new BLabel(lexRt.getText(sourceKey));
            } else if (p.equals(BJob.jobState)) {
                BColor stateColor;
                int js = job.getJobState().getOrdinal();
                switch (js) {
                    case 4: {
                        stateColor = BColor.green;
                        break;
                    }
                    case 5: {
                        stateColor = BColor.red;
                        break;
                    }
                    default: {
                        stateColor = BColor.black;
                    }
                }
                value = new BLabel(job.get(p).toString());
                value.setFont(BFont.make((BFont)BFont.DEFAULT, (int)1));
                value.setForeground(BBrush.makeSolid((BColor)stateColor));
            } else {
                value = new BLabel(job.get(p).toString());
            }
            gp.add(nextSlotValue, (BValue)value);
        }
    }

    private static BScrollPane getScrollPane(BGridPane gp) {
        BScrollPane sp = new BScrollPane((BWidget)gp);
        sp.setVpolicy(BScrollBarPolicy.always);
        sp.setHpolicy(BScrollBarPolicy.asNeeded);
        return sp;
    }
}

