/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.ui;

import com.tridium.ndriver.ui.device.BNDeviceManager;
import com.tridiumemea.micros.BMicrosDevice;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"micros:MicrosNetwork", "micros:MicrosDeviceFolder"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public final class BMicrosDeviceManager
extends BNDeviceManager {
    public static final Type TYPE = Sys.loadType(BMicrosDeviceManager.class);
    private static final Lexicon lex = Lexicon.make(BMicrosDeviceManager.class);
    private final MgrColumn colName = new MgrColumn.Name(4);
    private final MgrColumn colType = new MgrColumn.Type();
    private final MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BMicrosDevice());
    private final MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    private final MgrColumn colEnabled = new MgrColumn.Prop(BMicrosDevice.enabled, 2);
    private final MgrColumn colAddress = new MgrColumn.Prop(BMicrosDevice.address, 1);
    private final MgrColumn colVersionPMS = new MgrColumn.Prop(BMicrosDevice.versionPMS);
    private final MgrColumn colVersionIFC = new MgrColumn.Prop(BMicrosDevice.versionIFC);
    private final MgrColumn colHotelId = new MgrColumn.Prop(BMicrosDevice.hotelID);
    private final MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    private final MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colStatus, this.colEnabled, this.colAddress, this.colHealth, this.colVersionPMS, this.colVersionIFC, this.colHotelId};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model((BDeviceManager)this);
    }

    protected MgrController makeController() {
        return new Controller((BDeviceManager)this);
    }

    private static final class Controller
    extends DeviceController {
        private final BMicrosDeviceManager mgr;
        private final PingCommand ping;

        Controller(BDeviceManager mgr) {
            super(mgr);
            this.mgr = (BMicrosDeviceManager)mgr;
            this.ping = new PingCommand((BWidget)mgr);
            this.ping.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.edit, this.ping};
        }

        private final class PingCommand
        extends MgrController.MgrCommand {
            PingCommand(BWidget owner) {
                super(owner, lex, "dm.PingCmd");
            }

            public CommandArtifact doInvoke() {
                BMicrosDevice device = (BMicrosDevice)Controller.this.mgr.getModel().getTable().getComponentAt(0);
                device.ping();
                return null;
            }
        }
    }

    private final class Model
    extends DeviceModel {
        Model(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BMicrosDeviceManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BMicrosDevice.TYPE);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BMicrosDevice.TYPE};
        }
    }
}

