/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.timesync;

import com.tridium.platform.ntp.BNtpPlatformService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.bajax.timesync.BTimeSyncClient;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serverEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="serverPort", type="int", defaultValue="37"), @NiagaraProperty(name="clientSchedule", type="BTimeTrigger", defaultValue="new BTimeTrigger()"), @NiagaraProperty(name="clientMaxDelta", type="BRelTime", defaultValue="BRelTime.make(BRelTime.MILLIS_IN_HOUR * 2)"), @NiagaraProperty(name="clientMinDelta", type="BRelTime", defaultValue="BRelTime.make(5000)"), @NiagaraProperty(name="lastSync", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="forceSync", flags=16), @NiagaraAction(name="sync", flags=16)})
@NiagaraTopic(name="clockModified")
public class BTimeSyncService
extends BAbstractService
implements BIStatus {
    public static final Property serverEnabled = BTimeSyncService.newProperty((int)0, (boolean)false, null);
    public static final Property serverPort = BTimeSyncService.newProperty((int)0, (int)37, null);
    public static final Property clientSchedule = BTimeSyncService.newProperty((int)0, (BValue)new BTimeTrigger(), null);
    public static final Property clientMaxDelta = BTimeSyncService.newProperty((int)0, (BValue)BRelTime.make((long)0x6DDD00L), null);
    public static final Property clientMinDelta = BTimeSyncService.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    public static final Property lastSync = BTimeSyncService.newProperty((int)4, (BValue)BAbsTime.NULL, null);
    public static final Action forceSync = BTimeSyncService.newAction((int)16, null);
    public static final Action sync = BTimeSyncService.newAction((int)16, null);
    public static final Topic clockModified = BTimeSyncService.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTimeSyncService.class);
    private static final BIcon icon = BIcon.std((String)"clock.png");
    public static final long EPOCH_DELTA = 2208988800L;
    static final Logger log = Logger.getLogger("timesync");
    private boolean clientFault = false;
    private String clientFaultString;
    private boolean syncing = false;
    private Server server;
    private boolean serverFault = false;
    private String serverFaultString;

    public boolean getServerEnabled() {
        return this.getBoolean(serverEnabled);
    }

    public void setServerEnabled(boolean v) {
        this.setBoolean(serverEnabled, v, null);
    }

    public int getServerPort() {
        return this.getInt(serverPort);
    }

    public void setServerPort(int v) {
        this.setInt(serverPort, v, null);
    }

    public BTimeTrigger getClientSchedule() {
        return (BTimeTrigger)this.get(clientSchedule);
    }

    public void setClientSchedule(BTimeTrigger v) {
        this.set(clientSchedule, (BValue)v, null);
    }

    public BRelTime getClientMaxDelta() {
        return (BRelTime)this.get(clientMaxDelta);
    }

    public void setClientMaxDelta(BRelTime v) {
        this.set(clientMaxDelta, (BValue)v, null);
    }

    public BRelTime getClientMinDelta() {
        return (BRelTime)this.get(clientMinDelta);
    }

    public void setClientMinDelta(BRelTime v) {
        this.set(clientMinDelta, (BValue)v, null);
    }

    public BAbsTime getLastSync() {
        return (BAbsTime)this.get(lastSync);
    }

    public void setLastSync(BAbsTime v) {
        this.set(lastSync, (BValue)v, null);
    }

    public void forceSync() {
        this.invoke(forceSync, null, null);
    }

    public void sync() {
        this.invoke(sync, null, null);
    }

    public void fireClockModified(BValue event) {
        this.fire(clockModified, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doForceSync() {
        this.sync(true);
    }

    public void doSync() {
        this.sync(false);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void changed(Property p, Context c) {
        super.changed(p, c);
        if (c != Context.decoding) {
            if (p == enabled) {
                boolean disabled = !this.getEnabled();
                BTimeSyncClient[] ary = this.clients();
                int i = ary.length;
                while (--i >= 0) {
                    ary[i].serviceDisabled(disabled);
                }
            }
            if (p == serverEnabled || p == serverPort || p == enabled) {
                this.restartServer();
            }
        }
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        BTimeTrigger sch = this.getClientSchedule();
        this.linkTo("clientScheduleLink", (BComponent)sch, (Slot)BTimeTrigger.fireTrigger, (Slot)sync);
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.stopServer();
    }

    public void enabled() {
        this.restartServer();
    }

    public void disabled() {
        this.restartServer();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        Invocation i = new Invocation((BComponent)this, a, arg, cx);
        Thread t = new Thread((Runnable)i);
        t.start();
        return null;
    }

    public void restartServer() {
        this.stopServer();
        this.startServer();
    }

    public void started() throws Exception {
        super.started();
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync(boolean force) {
        if (this.isDisabled()) {
            return;
        }
        try {
            BTimeSyncService bTimeSyncService = this;
            synchronized (bTimeSyncService) {
                block35: {
                    if (!this.syncing) break block35;
                    return;
                }
                this.syncing = true;
            }
            try {
                BNtpPlatformService ntpService = (BNtpPlatformService)Sys.getService((Type)BNtpPlatformService.TYPE);
                ntpService.poll();
                if (ntpService.getEnabled()) {
                    this.clientFault("NTP is in use, RFC 868 clients ignored");
                    return;
                }
            }
            catch (ServiceNotFoundException ntpService) {
                // empty catch block
            }
            log.fine("Beginning client sync");
            BTimeSyncClient[] clients = this.clients();
            int len = clients.length;
            if (len == 0) {
                this.clientFault("TimeSyncService has no clients");
                return;
            }
            BTimeSyncClient.Report[] reports = new BTimeSyncClient.Report[len];
            long rawDelta = 0L;
            int rawResponses = 0;
            long saneDelta = 0L;
            int saneResponses = 0;
            long thresh = this.getClientMaxDelta().getMillis();
            for (int i = 0; i < len; ++i) {
                reports[i] = this.executePoll(clients[i]);
                if (reports[i] == null) continue;
                if (Math.abs(reports[i].delta) < thresh) {
                    ++saneResponses;
                    saneDelta += reports[i].delta;
                } else {
                    log.fine(clients[i].toPathString() + " exceeded maxClientDelta: " + reports[i].delta / 1000L + "s");
                }
                rawDelta += reports[i].delta;
                ++rawResponses;
            }
            if (rawResponses == 0) {
                this.clientFault("No clients received a response");
                return;
            }
            if (saneResponses > 0) {
                if (saneDelta != 0L) {
                    saneDelta /= (long)saneResponses;
                }
                this.clientOk();
                if (Math.abs(saneDelta) > this.getClientMinDelta().getMillis()) {
                    this.adjustTime(saneDelta);
                }
            } else if (force) {
                if (rawDelta != 0L) {
                    rawDelta /= (long)rawResponses;
                }
                this.clientOk();
                this.adjustTime(rawDelta);
            } else {
                boolean setAnyway = false;
                try {
                    BAbsTime t = Clock.time();
                    if (clients.length > 0 && clients.length == rawResponses && this.getLastSync().isAfter(t) && t.isBefore(BAbsTime.make((int)2000, (BMonth)BMonth.january, (int)1))) {
                        long min = this.getClientMinDelta().getMillis();
                        int i = reports.length;
                        while (--i > 0) {
                            int j = i;
                            while (--j >= 0) {
                                if (Math.abs(reports[i].delta - reports[j].delta) <= min) continue;
                                throw new Exception();
                            }
                        }
                        setAnyway = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (setAnyway) {
                    if (rawDelta != 0L) {
                        rawDelta /= (long)rawResponses;
                    }
                    this.clientOk();
                    this.adjustTime(rawDelta);
                } else {
                    this.clientFault("Sync delta (" + rawDelta / (long)rawResponses / 1000L + "s) exceeds clientMaxDelta");
                }
            }
            this.setLastSync(Clock.time());
        }
        finally {
            this.syncing = false;
        }
    }

    private void adjustTime(long delta) {
        long myTime = System.currentTimeMillis();
        long desiredTime = myTime + delta;
        Clock.setTime((BAbsTime)BAbsTime.make((long)desiredTime));
        String old = new Date(myTime).toString();
        String neu = new Date(desiredTime).toString();
        Sys.getAuditor().audit(new AuditEvent("Changed", this.toPathString(), "systemTime", old, neu, "admin"));
        log.warning("Timesync changed time from " + old + " to " + neu);
        this.fireClockModified(null);
    }

    private void clientFault(String msg) {
        if (!this.clientFault) {
            log.warning(msg);
        } else if (msg == null || this.clientFaultString == null) {
            log.warning(msg);
        } else if (!msg.equals(this.clientFaultString)) {
            log.warning(msg);
        }
        this.clientFault = true;
        this.clientFaultString = msg;
        this.updateServiceStatus();
    }

    private void clientOk() {
        this.clientFault = false;
        this.clientFaultString = null;
        this.updateServiceStatus();
    }

    private BTimeSyncClient[] clients() {
        return (BTimeSyncClient[])this.getChildren(BTimeSyncClient.class);
    }

    private BTimeSyncClient.Report executePoll(BTimeSyncClient client) {
        try {
            return client.poll();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void startServer() {
        try {
            this.serverFault = false;
            this.serverFaultString = null;
            if (this.isDisabled() || this.isFatalFault() || !this.getServerEnabled() || !this.isRunning()) {
                return;
            }
            this.server = new Server(this.getServerPort());
            this.server.start();
        }
        catch (Exception x) {
            this.serverFault = true;
            this.serverFaultString = "Failed to start local server: " + x.getMessage();
            log.log(Level.SEVERE, "Failed to start local Server on port " + this.getServerPort(), x);
        }
        finally {
            this.updateServiceStatus();
        }
    }

    private void stopServer() {
        if (this.server == null) {
            return;
        }
        this.server.kill();
        this.server = null;
    }

    private void updateServiceStatus() {
        if (this.isFatalFault()) {
            return;
        }
        int bits = 0;
        if (!this.getEnabled()) {
            bits |= 1;
        }
        if (this.clientFault | this.serverFault) {
            bits |= 2;
        }
        this.setStatus(BStatus.make((int)bits));
        StringBuffer buf = new StringBuffer();
        if (this.clientFault) {
            buf.append(this.clientFaultString);
        }
        if (this.clientFault && this.serverFault) {
            buf.append("; ");
        }
        if (this.serverFault) {
            buf.append(this.serverFaultString);
        }
        this.setFaultCause(buf.toString());
    }

    private class Server
    extends Thread {
        private boolean alive;
        private DatagramSocket socket;

        public Server(int port) throws IOException {
            super("TimeSync Server");
            this.alive = false;
            this.socket = new DatagramSocket(port);
            this.socket.setSoTimeout(500);
        }

        public void kill() {
            this.alive = false;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            log.info("TimeSyncService server started on port " + this.socket.getLocalPort());
            this.alive = true;
            byte[] buf = new byte[4];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            while (this.alive) {
                try {
                    this.socket.receive(packet);
                    long x = System.currentTimeMillis();
                    x = x / 1000L + 2208988800L;
                    buf[0] = (byte)(x >>> 24 & 0xFFL);
                    buf[1] = (byte)(x >>> 16 & 0xFFL);
                    buf[2] = (byte)(x >>> 8 & 0xFFL);
                    buf[3] = (byte)(x >>> 0 & 0xFFL);
                    packet.setData(buf);
                    packet.setLength(4);
                    this.socket.send(packet);
                }
                catch (InterruptedIOException x) {
                }
                catch (Exception e) {
                    if (!this.alive) continue;
                    this.alive = false;
                    BTimeSyncService.this.serverFault = true;
                    BTimeSyncService.this.serverFaultString = "Server - " + e.toString();
                    BTimeSyncService.this.updateStatus();
                    log.log(Level.SEVERE, "TimeSyncService server", e);
                }
            }
            log.info("TimeSyncService server stopped on port " + this.socket.getLocalPort());
        }
    }
}

