/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import com.tridium.ui.theme.Theme;
import com.tridiumx.analytics.ui.chart.BSpectrumChart;
import com.tridiumx.analytics.ui.chart.BSpectrumChartPane;
import javax.baja.chart.BChartCanvas;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSpectrumChartCanvas
extends BChartCanvas {
    @Generated
    public static final Type TYPE = Sys.loadType(BSpectrumChartCanvas.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void paint(Graphics g) {
        super.paint(g);
        BSpectrumChartPane.Controller controller = ((BSpectrumChartPane)this.getPane()).controller;
        if (controller.getSuperTraceX() != -1.0) {
            this.paintPopup(controller, g);
        }
    }

    private void paintPopup(BSpectrumChartPane.Controller controller, Graphics g) {
        double my;
        double mx;
        BAbsTime time;
        BSpectrumChart chart = (BSpectrumChart)this.getPane().getCharts()[0];
        BDouble value = chart.getValueForTime(time = chart.getTimeAtPoint(mx = controller.getSuperTraceX(), my = controller.getSuperTraceY()));
        if (value == null) {
            return;
        }
        String text = time.toString(null) + " - " + value.toString(null);
        BFont font = Theme.widget().getTextFont();
        double dw = font.width(text) + 10.0;
        double dh = font.getHeight() + 10.0;
        double dx = mx;
        double dy = my - dh - 5.0;
        if (dy < 0.0) {
            dy = my + 24.0;
        }
        if (dx + dw > this.getWidth()) {
            dx = mx - dw;
        }
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(dx, dy, dw, dh);
        g.setBrush(BColor.black);
        g.strokeRect(dx, dy, dw, dh);
        g.setFont(font);
        double tx = dx + 5.0;
        double ty = dy + 5.0 + font.getAscent();
        g.setBrush(BColor.black);
        g.drawString(text, tx, ty);
    }
}

