/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import java.util.HashMap;
import java.util.Map;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
public class BSpectrumChart
extends BChart {
    @Generated
    public static final Type TYPE = Sys.loadType(BSpectrumChart.class);
    HashMap<BAbsTime, BDouble> valueForTime;
    double minValue = Double.MAX_VALUE;
    double maxValue = Double.MIN_VALUE;
    double totalValues;
    double midValue;
    double minToAverage;
    double maxToAverage;
    BAbsTime minTime;
    BAbsTime maxTime;
    long interval;
    BAbsTime firstDay;
    int days;
    double colWidth;
    long intervalsPerDay;
    double rowHeight;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSpectrumChart() {
    }

    public BSpectrumChart(ChartModel model) {
        super(model);
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        ChartSpec spec = this.getModel().getSpec(0);
        this.processSeries(spec.getSeries());
        spec.getXAxis().setAxisMax((Object)this.maxTime);
        spec.getXAxis().setAxisMin((Object)this.minTime);
        this.colWidth = this.getWidth() / (double)this.days;
        BAxis yaxis = this.getModel().getSpec(0).getYAxis();
        double zeroLoc = yaxis.toDisplaySpace(yaxis.getAxisMin());
        double maxLoc = yaxis.toDisplaySpace(yaxis.getAxisMax());
        this.rowHeight = (zeroLoc - maxLoc) / (double)this.intervalsPerDay;
    }

    private void processSeries(Series series) {
        this.valueForTime = new HashMap(series.getRowCount());
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        this.minTime = BAbsTime.END_OF_TIME;
        this.maxTime = BAbsTime.DEFAULT;
        this.totalValues = 0.0;
        this.interval = -1L;
        int lastValidIndex = Integer.MIN_VALUE;
        for (int i = 0; i < series.getRowCount(); ++i) {
            BAbsTime time = (BAbsTime)series.getValue(i, 0);
            BDouble value = (BDouble)series.getValue(i, 1);
            if (time == null || value == null) continue;
            if (this.interval == -1L) {
                if (lastValidIndex != i - 1) {
                    lastValidIndex = i;
                    continue;
                }
                BAbsTime lastTime = (BAbsTime)series.getValue(lastValidIndex, 0);
                this.interval = Math.abs(time.getMillis() - lastTime.getMillis());
                this.addRecord(lastTime, (BDouble)series.getValue(lastValidIndex, 1));
            }
            this.addRecord(time, value);
        }
        this.midValue = this.maxValue - (this.maxValue - this.minValue) / 2.0;
        this.minToAverage = this.midValue - this.minValue;
        this.maxToAverage = this.maxValue - this.midValue;
        this.firstDay = this.minTime.timeOfDay(0, 0, 0, 0);
        this.intervalsPerDay = 86400000L / this.interval;
        this.days = (int)((long)series.getRowCount() / this.intervalsPerDay);
    }

    private void addRecord(BAbsTime time, BDouble value) {
        this.valueForTime.put(time, value);
        double dVal = value.getDouble();
        if (dVal > this.maxValue) {
            this.maxValue = dVal;
        }
        if (dVal < this.minValue) {
            this.minValue = dVal;
        }
        this.totalValues += dVal;
        if (time.isAfter(this.maxTime)) {
            this.maxTime = time;
        }
        if (time.isBefore(this.minTime)) {
            this.minTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPaint(Graphics g) {
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        if (this.valueForTime == null) {
            return;
        }
        if (this.valueForTime.size() < 2) {
            throw new IllegalStateException("Insufficient record count");
        }
        this.getPane().getAxes(BAxisDimension.x);
        BAxis yaxis = this.getModel().getSpec(0).getYAxis();
        double maxLoc = yaxis.toDisplaySpace(yaxis.getAxisMax());
        g.push();
        try {
            for (Map.Entry<BAbsTime, BDouble> entry : this.valueForTime.entrySet()) {
                BAbsTime time = entry.getKey();
                BDouble value = entry.getValue();
                g.setBrush(this.valueToBrush(value.getDouble()));
                long col = this.firstDay.delta(time.timeOfDay(0, 0, 0, 0)).getDays();
                double x = (double)col * this.colWidth;
                long dayMillis = time.getTimeOfDayMillis();
                long intervalStart = dayMillis - dayMillis % this.interval;
                long row = intervalStart / this.interval + 1L;
                double y = this.rowHeight * (double)(this.intervalsPerDay - row) + maxLoc;
                g.fillRect(x, y, this.colWidth, this.rowHeight);
            }
        }
        finally {
            g.pop();
        }
    }

    private BBrush valueToBrush(double value) {
        if (value > this.midValue) {
            int gb = 255 - (int)((value - this.midValue) / this.maxToAverage * 255.0);
            return BBrush.makeSolid((BColor)BColor.make((int)255, (int)gb, (int)gb));
        }
        int rg = 255 - (int)((this.midValue - value) / this.minToAverage * 255.0);
        return BBrush.makeSolid((BColor)BColor.make((int)rg, (int)rg, (int)255));
    }

    public BAbsTime getTimeAtPoint(double x, double y) {
        long dayMillis = this.firstDay.getMillis();
        while (x > this.colWidth) {
            dayMillis += 86400000L;
            x -= this.colWidth;
        }
        double height = this.getHeight() - this.rowHeight;
        long time = 0L;
        while (y < height) {
            time += this.interval;
            y += this.rowHeight;
        }
        return BAbsTime.make((long)(dayMillis + time));
    }

    public BDouble getValueForTime(BAbsTime time) {
        return this.valueForTime.get(time);
    }
}

