/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BEquipmentOperationChart
extends BChart {
    @Generated
    public static final Type TYPE = Sys.loadType(BEquipmentOperationChart.class);
    BDiscreteAxis yaxis = new BDiscreteAxis();
    BAbsTime minTime;
    BAbsTime maxTime;
    long totalSeconds;
    double colWidth;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEquipmentOperationChart() {
        this.setModel((ChartModel)new Model());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPaint(Graphics g) {
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        g.push();
        try {
            ChartModel model = this.getModel();
            int specCount = model.getSpecCount();
            for (int i = 0; i < specCount; ++i) {
                ChartSpec spec = model.getSpec(i);
                Series series = spec.getSeries();
                g.setBrush(series.getBrush());
                double rowHeight = this.getHeight() / 2.0;
                BAxis xaxis = spec.getXAxis();
                double zerolocx = xaxis.toDisplaySpace(xaxis.getAxisMin());
                double maxlocx = xaxis.toDisplaySpace(xaxis.getAxisMax());
                double width = maxlocx - zerolocx;
                this.totalSeconds = (((BAbsTime)spec.getXAxis().getAxisMax()).getMillis() - ((BAbsTime)spec.getXAxis().getAxisMin()).getMillis()) / 1000L;
                this.colWidth = width / (double)this.totalSeconds;
                double x = 0.0;
                double y = this.getHeight() / 2.0;
                for (int row = 0; row < series.getRowCount(); ++row) {
                    BAbsTime time = (BAbsTime)series.getValue(row, 0);
                    BBoolean value = (BBoolean)series.getValue(row, 1);
                    if (!value.getBoolean()) continue;
                    x = xaxis.toDisplaySpace((Object)time) - 1.0;
                    g.fillRect(x, y, 3.0, rowHeight);
                }
            }
        }
        finally {
            g.pop();
        }
    }

    private void processSeries(Series series) {
        this.minTime = BAbsTime.END_OF_TIME;
        this.maxTime = BAbsTime.DEFAULT;
        for (int i = 0; i < series.getRowCount(); ++i) {
            BAbsTime time = (BAbsTime)series.getValue(i, 0);
            if (time.isAfter(this.maxTime)) {
                this.maxTime = time;
            }
            if (!time.isBefore(this.minTime)) continue;
            this.minTime = time;
        }
    }

    class Model
    extends BoundChartModel {
        Model() {
        }

        public synchronized void doSyncBindings() {
            super.doSyncBindings();
            if (this.getSpecCount() == 0) {
                return;
            }
            for (int i = 0; i < this.getSpecCount(); ++i) {
                ChartSpec spec = this.getSpec(i);
                BEquipmentOperationChart.this.processSeries(spec.getSeries());
                spec.getYAxis().setShowSwatches(false);
                BEquipmentOperationChart.this.maxTime = BEquipmentOperationChart.this.maxTime.timeOfDay(23, 59, 59, 900);
                BEquipmentOperationChart.this.minTime = BEquipmentOperationChart.this.minTime.timeOfDay(0, 0, 0, 0);
                spec.getXAxis().setMaxAuto(false);
                spec.getXAxis().setMinAuto(false);
                spec.getXAxis().setAxisMax((Object)BEquipmentOperationChart.this.maxTime);
                spec.getXAxis().setAxisMin((Object)BEquipmentOperationChart.this.minTime);
            }
        }

        public BAxis findAxis(BAxis axis) {
            if (axis.getDimension().equals((Object)BAxisDimension.y)) {
                Object[] barray = new BBoolean[]{BBoolean.TRUE};
                BEquipmentOperationChart.this.yaxis.setRange(barray);
                return BEquipmentOperationChart.this.yaxis;
            }
            return super.findAxis(axis);
        }
    }
}

